/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.ant;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.nuiton.processor.Processor;
import org.nuiton.processor.ProcessorUtil;

public class ProcessorTask
extends MatchingTask {
    public static final int MSG_VERBOSE = 3;
    protected File srcDir;
    protected File destDir;
    protected String[] includes = new String[0];
    protected String[] excludes = new String[0];
    protected String[] files;
    protected String fileInPattern = "";
    protected String fileOutPattern = "";
    protected String filters = "org.nuiton.processor.filters.NoActionFilter";
    protected boolean overwrite = true;
    protected boolean verbose = false;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setFileOutPattern(String fileOutPattern) {
        this.fileOutPattern = fileOutPattern;
    }

    public void setFileInPattern(String fileInPattern) {
        this.fileInPattern = fileInPattern;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    protected String applyTransformationFilename(String filename) {
        return filename.replaceAll(this.fileInPattern, this.fileOutPattern);
    }

    protected void doExecute() throws BuildException {
        int numberFiles;
        Processor processor = null;
        try {
            processor = ProcessorUtil.newProcessor((String)this.filters, (String)",");
        }
        catch (Exception ex) {
            throw new BuildException("Could nto instanciate processor for reason : " + ex.getMessage(), (Throwable)ex);
        }
        for (numberFiles = 0; numberFiles < this.files.length; ++numberFiles) {
            String inputFileName = this.absoluteSourceName(this.files[numberFiles]);
            String outputFileName = this.absoluteDestinationName(this.applyTransformationFilename(this.files[numberFiles]));
            if (this.verbose) {
                this.log("Using " + inputFileName);
            }
            if (!this.overwrite && !this.isNewer(inputFileName, outputFileName)) continue;
            if (this.verbose) {
                this.log("Generating " + outputFileName);
            }
            new File(outputFileName).getParentFile().mkdirs();
            try {
                processor.process((Reader)new FileReader(inputFileName), (Writer)new FileWriter(outputFileName));
                continue;
            }
            catch (IOException eee) {
                throw new BuildException((Throwable)eee);
            }
        }
        this.log("Generating " + numberFiles + " files to " + this.destDir);
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir \"" + this.srcDir.getPath() + "\" does not exist!", this.getLocation());
        }
        if (this.destDir == null) {
            this.destDir = this.srcDir;
        }
        if (!this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
        }
        this.buildFileList();
        this.doExecute();
    }

    protected void buildFileList() {
        String[] ex;
        DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
        String[] in = this.getIncludes();
        if (in.length > 0) {
            ds.setIncludes(in);
        }
        if ((ex = this.getExcludes()).length > 0) {
            ds.setExcludes(ex);
        }
        ds.scan();
        this.files = ds.getIncludedFiles();
    }

    protected boolean isNewer(String filein, String fileout) {
        boolean result;
        boolean bl = result = new File(filein).lastModified() > new File(fileout).lastModified();
        if (result) {
            this.log(filein + " is newer than " + fileout, 3);
        }
        return result;
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setIncludes(String includes) {
        this.setIncludes(includes.split(","));
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setExcludes(String excludes) {
        this.setExcludes(excludes.split(","));
    }

    protected String absoluteDestinationName(String fileName) {
        return this.destDir.getPath() + File.separator + fileName;
    }

    protected String absoluteSourceName(String fileName) {
        return this.srcDir.getPath() + File.separator + fileName;
    }
}

