/*
 * #%L
 * Nuiton Utils :: Nuiton Maven Report Plugin
 * 
 * $Id: ApplicationConfigReport.java 2358 2012-06-11 08:36:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.5.3/nuiton-utils-maven-report-plugin/src/main/java/org/nuiton/util/plugin/report/ApplicationConfigReport.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.util.plugin.report;

import org.nuiton.util.ApplicationConfigProvider;

import java.util.HashSet;
import java.util.List;

/**
 * Generates a report for declarated application config via the
 * {@link ApplicationConfigProvider} mecanism.
 * <p/>
 * For each configuration, you can find all his options and actions.
 *
 * @author tchemit <chemit@codelutin.com>
 * @goal application-config-report
 * @requiresDependencyResolution runtime
 * @requiresProject true
 * @since 2.4.8
 */
public class ApplicationConfigReport extends AbstractApplicationConfigReport {

    /**
     * List of all class path elements.
     *
     * @parameter property="project.runtimeClasspathElements"
     * @required
     * @readonly
     * @since 2.4.8
     */
    private List<String> runtimeClasspathElements;

    @Override
    protected ClassLoader createClassLoader() {
        return createClassLoader(new HashSet<String>(runtimeClasspathElements));
    }

}
