/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin.model;

import java.awt.Color;
import java.io.File;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.KeyStroke;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.util.ObjectUtil;
import org.nuiton.version.Version;

public class OptionModel {
    private String name;
    private String key;
    private String description;
    private String type;
    private String defaultValue;
    private boolean _transient;
    private boolean _final;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        switch (type) {
            case "string": {
                this.type = String.class.getName();
                break;
            }
            case "int": {
                this.type = Integer.TYPE.getName();
                break;
            }
            case "Integer": {
                this.type = Integer.class.getName();
                break;
            }
            case "float": {
                this.type = Float.TYPE.getName();
                break;
            }
            case "Float": {
                this.type = Float.class.getName();
                break;
            }
            case "long": {
                this.type = Long.TYPE.getName();
                break;
            }
            case "Long": {
                this.type = Long.class.getName();
                break;
            }
            case "double": {
                this.type = Double.TYPE.getName();
                break;
            }
            case "Double": {
                this.type = Double.class.getName();
                break;
            }
            case "boolean": {
                this.type = Boolean.TYPE.getName();
                break;
            }
            case "Boolean": {
                this.type = Boolean.class.getName();
                break;
            }
            case "byte": {
                this.type = Byte.TYPE.getName();
                break;
            }
            case "Byte": {
                this.type = Byte.class.getName();
                break;
            }
            case "char": {
                this.type = Character.TYPE.getName();
                break;
            }
            case "Character": {
                this.type = Character.class.getName();
                break;
            }
            case "file": {
                this.type = File.class.getName();
                break;
            }
            case "version": {
                this.type = Version.class.getName();
                break;
            }
            case "color": {
                this.type = Color.class.getName();
                break;
            }
            case "keystroke": {
                this.type = KeyStroke.class.getName();
                break;
            }
            case "url": {
                this.type = URL.class.getName();
                break;
            }
            case "date": {
                this.type = Date.class.getName();
                break;
            }
            case "time": {
                this.type = Time.class.getName();
                break;
            }
            case "timestamp": {
                this.type = Timestamp.class.getName();
                break;
            }
            default: {
                this.type = type;
            }
        }
    }

    public void setType(Class type) {
        this.type = type.equals(String.class) ? "string" : (type.isPrimitive() ? type.getSimpleName() : (ObjectUtil.isPrimitive((Class)type) ? type.getSimpleName() : (type.equals(File.class) ? "file" : (type.equals(Version.class) ? "version" : (type.equals(Color.class) ? "color" : (type.equals(KeyStroke.class) ? "keystroke" : (type.equals(URL.class) ? "url" : (type.equals(Date.class) ? "date" : (type.equals(Time.class) ? "time" : (type.equals(Timestamp.class) ? "timestamp" : type.getName()))))))))));
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    public void setFinal(boolean _final) {
        this._final = _final;
    }

    public static OptionModel of(ConfigOptionDef configOptionDef) {
        OptionModel optionModel = new OptionModel();
        if (configOptionDef instanceof Enum) {
            Enum optionDef = (Enum)configOptionDef;
            optionModel.setName(GeneratorUtil.convertConstantNameToVariableName((String)optionDef.name()));
        }
        optionModel.setKey(configOptionDef.getKey());
        optionModel.setType(configOptionDef.getType());
        optionModel.setDefaultValue(configOptionDef.getDefaultValue());
        optionModel.setDescription(configOptionDef.getDescription());
        optionModel.setTransient(configOptionDef.isTransient());
        optionModel.setFinal(configOptionDef.isFinal());
        return optionModel;
    }
}

