package org.nuiton.config.example;

/*-
 * #%L
 * Nuiton Config :: Example
 * %%
 * Copyright (C) 2016 - 2025 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.config.ConfigOptionDef;


public enum NuitonConfigExampleConfigOption implements ConfigOptionDef {
    
    FIRST_NAME(
        java.lang.String.class,
        "identity.firstName",
        "Prénom de l'utilisateur",
        "Joshua",
        false,
        false),
    
    LAST_NAME(
        java.lang.String.class,
        "identity.lastName",
        "Nom de l'utilisateur",
        "Bloch",
        false,
        false),
    
    EMAIL(
        java.lang.String.class,
        "identity.email",
        "Courriel de l'utilisateur",
        null,
        false,
        false),
    
    TWITTER(
        java.lang.String.class,
        "identity.twitter",
        "Compte Twitter de l'utilisateur",
        "jbloch",
        false,
        false),
    
    AGE(
        int.class,
        "identity.age",
        "Âge de l'utilisateur",
        "56",
        false,
        false),
    
    PREFERRED_FORMAT(
        org.nuiton.config.io.ApplicationConfigReadFormat.class,
        "identify.preferredFormat",
        "Format de prédilection (il s'agit d'une enum)",
        "ini",
        false,
        false);

    private final Class type;

    private final String key;

    private final String description;

    private String defaultValue;

    private boolean _transient;

    private boolean _final;

    NuitonConfigExampleConfigOption(Class type, String key, String description, String defaultValue, boolean _transient, boolean _final) {
        this.type = type;
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this._final = _final;
        this._transient = _transient;
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class getType() {
        return type;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isTransient() {
        return _transient;
    }

    @Override
    public void setTransient(boolean _transient) {
        this._transient = _transient;
    }

    @Override
    public boolean isFinal() {
        return _final;
    }

    @Override
    public void setFinal(boolean _final) {
        this._final = _final;
    }

} //NuitonConfigExampleConfigOption
