/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import com.google.common.base.Predicate;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NumberUtil {
    private static final Log log = LogFactory.getLog(NumberUtil.class);
    public static final Predicate<Integer> NULL_OR_ZERO_INTEGER = new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return input == null || input == 0;
        }

        public boolean test(Integer input) {
            return this.apply(input);
        }
    };
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_ONE_DIGIT = new Predicate<Float>(){

        public boolean apply(Float input) {
            return input == null || (double)Math.abs(NumberUtil.roundOneDigit(input).floatValue()) < 0.1;
        }

        public boolean test(Float input) {
            return this.apply(input);
        }
    };
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_TWO_DIGITS = new Predicate<Float>(){

        public boolean apply(Float input) {
            return input == null || (double)Math.abs(NumberUtil.roundTwoDigits(input).floatValue()) < 0.01;
        }

        public boolean test(Float input) {
            return this.apply(input);
        }
    };
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_THREE_DIGITS = new Predicate<Float>(){

        public boolean apply(Float input) {
            return input == null || (double)Math.abs(NumberUtil.roundThreeDigits(input).floatValue()) < 0.001;
        }

        public boolean test(Float input) {
            return this.apply(input);
        }
    };
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_FOUR_DIGITS = new Predicate<Float>(){

        public boolean apply(Float input) {
            return input == null || (double)Math.abs(NumberUtil.roundFourDigits(input).floatValue()) < 1.0E-4;
        }

        public boolean test(Float input) {
            return this.apply(input);
        }
    };
    public static final Predicate<Float> NULL_OR_ZERO_FLOAT_FIVE_DIGITS = new Predicate<Float>(){

        public boolean apply(Float input) {
            return input == null || (double)Math.abs(NumberUtil.roundFiveDigits(input).floatValue()) < 1.0E-5;
        }

        public boolean test(Float input) {
            return this.apply(input);
        }
    };
    protected static final MathContext mc1Digit = new MathContext(1);
    protected static final MathContext mc2Digits = new MathContext(2);
    protected static final MathContext mc3Digits = new MathContext(3);
    protected static final MathContext mc4Digits = new MathContext(4);
    protected static final MathContext mc5Digits = new MathContext(5);

    public static int[] divideAndEnsureSum(int divisor, int dividend) {
        if (dividend == 0) {
            return null;
        }
        int quotient = (int)((double)divisor) / dividend;
        int[] result = new int[dividend];
        Arrays.fill(result, quotient);
        int i = 0;
        for (int sum = quotient * dividend; sum != divisor && i < dividend; ++sum) {
            int n = i++;
            result[n] = result[n] + 1;
        }
        return result;
    }

    public static Float roundOneDigit(Float number) {
        return NumberUtil.round(number, mc1Digit);
    }

    public static Float roundTwoDigits(Float number) {
        return NumberUtil.round(number, mc2Digits);
    }

    public static Float roundThreeDigits(Float number) {
        return NumberUtil.round(number, mc3Digits);
    }

    public static Float roundFourDigits(Float number) {
        return NumberUtil.round(number, mc4Digits);
    }

    public static Float roundFiveDigits(Float number) {
        return NumberUtil.round(number, mc5Digits);
    }

    public static Float roundNDigits(Float number, int digits) {
        return NumberUtil.round(number, new MathContext(digits));
    }

    public static Float round(Float number, MathContext mc) {
        float old = number.floatValue();
        float partieEntier = (int)old;
        float digit = old - (float)((int)old);
        number = Float.valueOf(partieEntier + new BigDecimal(digit).round(mc).floatValue());
        if (log.isDebugEnabled()) {
            log.debug((Object)("round " + old + " to " + number + " with mc = " + mc));
        }
        return number;
    }
}

