package org.nuiton.license.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-license-plugin.<br/> Call <pre>  mvn license:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Oct 17 03:14:08 CEST 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.nuiton:maven-license-plugin:2.4.1", 0 );
        append( sb, "", 0 );

        append( sb, "Maven License Plugin", 0 );
        append( sb, "Plugin de gestion des licenses (et en-t\u00eates) dans un project maven 2.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 7 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "add-third-party".equals( goal ) )
        {
            append( sb, "license:add-third-party", 0 );
            append( sb, "Le goal pour copier le fichier THIRD-PARTY.txt (contenant les licenses de toutes les dependances du projet) dans le classpath (et le generer s\'il n\'existe pas).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "bundleThirdPartyPath (Default: META-INF/${project.artifactId}-THIRD-PARTY.txt)", 2 );
                append( sb, "The path of the bundled third party file to produce when generateBundle is on.\nNote: This option is not available for pom module types.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedArtifacts", 2 );
                append( sb, "A filter to exclude some ArtifactsIds", 3 );
                append( sb, "", 0 );

                append( sb, "excludedGroups", 2 );
                append( sb, "A filter to exclude some GroupIds", 3 );
                append( sb, "", 0 );

                append( sb, "failIfWarning (Default: false)", 2 );
                append( sb, "A flag to fail the build if at least one dependency was detected without a license.", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "Un flag pour forcer la generation.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBundle (Default: false)", 2 );
                append( sb, "Un flag pour faire une copie nomm\u00e9 dans META-INF (prefixe avec le nom de l\'artifact).", 3 );
                append( sb, "", 0 );

                append( sb, "groupByLicense (Default: false)", 2 );
                append( sb, "A flag to change the grouping of the generated THIRD-PARTY file.\nBy default, group by dependecies.\n\nIf sets to true, the it will group by license type.\n", 3 );
                append( sb, "", 0 );

                append( sb, "includedArtifacts", 2 );
                append( sb, "A filter to include only some ArtifactsIds", 3 );
                append( sb, "", 0 );

                append( sb, "includedGroups", 2 );
                append( sb, "A filter to include only some GroupIds", 3 );
                append( sb, "", 0 );

                append( sb, "licenseMerges", 2 );
                append( sb, "To merge licenses in final file.\nEach entry represents a merge (first license is main license to keep), licenses are separated by |.\n\nExample :\n\n\n<licenseMerges>\n<licenseMerge>The\u00a0Apache\u00a0Software\u00a0License|Version\u00a02.0,Apache\u00a0License,\u00a0Version\u00a02.0</licenseMerge>\n</licenseMerges>\n</pre>\n", 3 );
                append( sb, "", 0 );

                append( sb, "missingFile (Default: src/license/THIRD-PARTY.properties)", 2 );
                append( sb, "The file where to fill the license for dependencies with unknwon license.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: target/generated-sources/license)", 2 );
                append( sb, "Repertoire de sortie des classes (classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "The reacted project.", 3 );
                append( sb, "", 0 );

                append( sb, "thirdPartyFilename (Default: THIRD-PARTY.txt)", 2 );
                append( sb, "Fichier ou ecrire les licences des dependances.", 3 );
                append( sb, "", 0 );

                append( sb, "useMissingFile (Default: false)", 2 );
                append( sb, "A flag to use the missing licenses file to consolidate the THID-PARTY file.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "aggregate-add-third-party".equals( goal ) )
        {
            append( sb, "license:aggregate-add-third-party", 0 );
            append( sb, "This aggregator goal (will be executed only once and only on pom projects) executed the add-third-party on all his modules (in a parellel build cycle) then aggreates all the third-party files in final one in the pom project.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "bundleThirdPartyPath (Default: META-INF/${project.artifactId}-THIRD-PARTY.txt)", 2 );
                append( sb, "The path of the bundled third party file to produce when generateBundle is on.\nNote: This option is not available for pom module types.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedArtifacts", 2 );
                append( sb, "A filter to exclude some ArtifactsIds", 3 );
                append( sb, "", 0 );

                append( sb, "excludedGroups", 2 );
                append( sb, "A filter to exclude some GroupIds", 3 );
                append( sb, "", 0 );

                append( sb, "failIfWarning (Default: false)", 2 );
                append( sb, "A flag to fail the build if at least one dependency was detected without a license.", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "Un flag pour forcer la generation.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBundle (Default: false)", 2 );
                append( sb, "Un flag pour faire une copie nomm\u00e9 dans META-INF (prefixe avec le nom de l\'artifact).", 3 );
                append( sb, "", 0 );

                append( sb, "groupByLicense (Default: false)", 2 );
                append( sb, "A flag to change the grouping of the generated THIRD-PARTY file.\nBy default, group by dependecies.\n\nIf sets to true, the it will group by license type.\n", 3 );
                append( sb, "", 0 );

                append( sb, "includedArtifacts", 2 );
                append( sb, "A filter to include only some ArtifactsIds", 3 );
                append( sb, "", 0 );

                append( sb, "includedGroups", 2 );
                append( sb, "A filter to include only some GroupIds", 3 );
                append( sb, "", 0 );

                append( sb, "licenseMerges", 2 );
                append( sb, "To merge licenses in final file.\nEach entry represents a merge (first license is main license to keep), licenses are separated by |.\n\nExample :\n\n\n<licenseMerges>\n<licenseMerge>The\u00a0Apache\u00a0Software\u00a0License|Version\u00a02.0,Apache\u00a0License,\u00a0Version\u00a02.0</licenseMerge>\n</licenseMerges>\n</pre>\n", 3 );
                append( sb, "", 0 );

                append( sb, "missingFile (Default: src/license/THIRD-PARTY.properties)", 2 );
                append( sb, "The file where to fill the license for dependencies with unknwon license.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: target/generated-sources/license)", 2 );
                append( sb, "Repertoire de sortie des classes (classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "The reacted project.", 3 );
                append( sb, "", 0 );

                append( sb, "thirdPartyFilename (Default: THIRD-PARTY.txt)", 2 );
                append( sb, "Fichier ou ecrire les licences des dependances.", 3 );
                append( sb, "", 0 );

                append( sb, "useMissingFile (Default: false)", 2 );
                append( sb, "A flag to use the missing licenses file to consolidate the THID-PARTY file.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "comment-style-list".equals( goal ) )
        {
            append( sb, "license:comment-style-list", 0 );
            append( sb, "Displays all the available comment style to box file headers.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail", 2 );
                append( sb, "Un drapeau pour afficher aussi le contenu des license.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "The reacted project.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "license:help", 0 );
            append( sb, "Display help information on maven-license-plugin.\nCall\n\u00a0\u00a0mvn\u00a0license:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "license-list".equals( goal ) )
        {
            append( sb, "license:license-list", 0 );
            append( sb, "Display all available licenses.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail", 2 );
                append( sb, "Un drapeau pour afficher aussi le contenu des license.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3 );
                append( sb, "", 0 );

                append( sb, "extraResolver", 2 );
                append( sb, "La baseURL d\'un resolver de license supplementaire", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "The reacted project.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "update-file-header".equals( goal ) )
        {
            append( sb, "license:update-file-header", 0 );
            append( sb, "The goal to update (or add) the header on some files described in descriptor file.\nThis goal replace the update-header goal which can not deal with Copyright.\n\nThis goal use a specific project file descriptor project.xml to describe all files to update for a whole project.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addSvnKeyWords (Default: false)", 2 );
                append( sb, "A flag to add svn:keywords on new header.\nWill add svn keywords :\n\nAuthor,\u00a0Id,\u00a0Rev,\u00a0URL\u00a0and\u00a0Date\n", 3 );
                append( sb, "", 0 );

                append( sb, "canUpdateCopyright (Default: false)", 2 );
                append( sb, "A flag to authorize update of the copyright part of the header.\nNote: By default, do NOT authorize it since copyright part should be handled by developpers (holder can change on each file for example).\n", 3 );
                append( sb, "", 0 );

                append( sb, "canUpdateDescription (Default: false)", 2 );
                append( sb, "A flag to authorize update of the description part of the header.\nNote: By default, do NOT authorize it since description can change on each file).\n", 3 );
                append( sb, "", 0 );

                append( sb, "canUpdateLicense (Default: true)", 2 );
                append( sb, "A flag to authorize update of the license part of the header.\nNote: By default, authorize it since license part should always be generated by the plugin.\n", 3 );
                append( sb, "", 0 );

                append( sb, "clearAfterOperation (Default: true)", 2 );
                append( sb, "A flag to clear everything after execution.\nNote: This property should ONLY be used for test purpose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "descriptor (Default: src/license/project.xml)", 2 );
                append( sb, "Deprecated. since 2.4.1, in version 3 we will no more use descriptor", 3 );
                append( sb, "", 0 );
                append( sb, "The project license descriptor file.\nNote: This parameter is no more required as it will be removed in version 3.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "A flag to test plugin but modify no file.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Specific files to excludes, separated by a comma. By default, thoses file type are excluded:\n-\tmodelisation\n-\timages\n-\ti18n properties\n\nNote: This parameter is not useable if you are still using a project file descriptor.\n", 3 );
                append( sb, "", 0 );

                append( sb, "extraExtensions", 2 );
                append( sb, "To associate extra extension files to an existing comment style.\nKeys of the map are the extension of extra files to treate, and the value is the comment style you want to associate.\n\nFor example, to treate file with extensions java2 and jdata as java files (says using the java comment style, declare this in your plugin configuration :\n\n<extraExtensions>\n<java2>java</java2>\n<jdata>java</jdata>\n</extraExtensions>\n\nNote: This parameter is not useable if you are still using a project file descriptor.\n", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreTag", 2 );
                append( sb, "A tag to place on files that will be ignored by the plugin.\nSometimes, it is necessary to do this when file is under a specific license.\n\nNote: If no sets, will use the default tag %%Ignore-License\n", 3 );
                append( sb, "", 0 );

                append( sb, "inceptionYear (Default: ${project.inceptionYear})", 2 );
                append( sb, "Inception year of the project.\nWill be used as first year of copyright section in new header.\n", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "Specific files to includes, separated by a comma. By default, it is \'** /*\'.\nNote: This parameter is not useable if you are still using a project file descriptor.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keepBackup (Default: false)", 2 );
                append( sb, "A flag to keep a backup of every modified file.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseName", 2 );
                append( sb, "Name of the license to use in the project.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseResolver", 2 );
                append( sb, "To specify an external extra licenses repository resolver (says the base url of the repository where the license.properties is present).", 3 );
                append( sb, "", 0 );

                append( sb, "organizationName (Default: ${project.organization.name})", 2 );
                append( sb, "Name of project\'s organization.\nWill be used as copyrigth\'s holder in new header.\n", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "The reacted project.", 3 );
                append( sb, "", 0 );

                append( sb, "projectName (Default: ${project.name})", 2 );
                append( sb, "Name of project (or module).\nWill be used as description section of new header.\n", 3 );
                append( sb, "", 0 );

                append( sb, "roots", 2 );
                append( sb, "To specify the base dir from which we apply the license.\nShould be on form \'root1,root2,rootn\'.\n\nBy default, the main roots are \'src, target\ngenerated-sources, target/processed-sources\'.\nNote: If some of these roots do not exist, they will be simply ignored.\n\nNote: This parameter is not useable if you are still using a project file descriptor.\n", 3 );
                append( sb, "", 0 );

                append( sb, "skipUpdateLicense (Default: false)", 2 );
                append( sb, "A flag to skip the goal.", 3 );
                append( sb, "", 0 );

                append( sb, "updateCopyright (Default: false)", 2 );
                append( sb, "A flag to update copyright application time (change copyright last year if required) according to the last commit made on the processed file.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "update-project-license".equals( goal ) )
        {
            append( sb, "license:update-project-license", 0 );
            append( sb, "Updates (or creates) the main project license file according to the given license project descriptor.\nCan also generate a bundle license file (to avoid collision names in class-path). This file is by default generate in META-INF class-path directory.\n\nNote: this goal replace add-license one (which does not use license project descriptor).\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "bundleLicensePath (Default: META-INF/${project.artifactId}-LICENSE.txt)", 2 );
                append( sb, "The path of the bundled license file to produce when generateBundle is on.\nNote: This option is not available for pom module types.\n", 3 );
                append( sb, "", 0 );

                append( sb, "descriptor (Default: src/license/project.xml)", 2 );
                append( sb, "Deprecated. since 2.4.1, in version 3 we will no more use descriptor", 3 );
                append( sb, "", 0 );
                append( sb, "The project license descriptor file.\nNote: This parameter is no more required as it will be removed in version 3.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "A flag to force to generate project license file even if it is up-to-date.", 3 );
                append( sb, "", 0 );

                append( sb, "generateBundle (Default: false)", 2 );
                append( sb, "A flag to copy the main license file in a bundled place.\nThis is usefull for final application to have a none confusing location to seek for the application license.\n\nIf Sets to true, will copy the license file to the bundleLicensePath to outputDirectory.\n\nNote: This option is not available for pom module types.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keepBackup (Default: false)", 2 );
                append( sb, "A flag to keep a backup of every modified file.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseFile (Default: ${basedir}/LICENSE.txt)", 2 );
                append( sb, "Project license file to synchronize with main license defined in descriptor file.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseName", 2 );
                append( sb, "Name of the license to use in the project.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseResolver", 2 );
                append( sb, "To specify an external extra licenses repository resolver (says the base url of the repository where the license.properties is present).", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: target/generated-sources/license)", 2 );
                append( sb, "The directory where to generate license resources.\nNote: This option is not available for pom module types.\n", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "The reacted project.", 3 );
                append( sb, "", 0 );

                append( sb, "skipUpdateProjectLicense (Default: false)", 2 );
                append( sb, "A flag to skip the goal.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
