/*
 * #%L
 * Maven License Plugin
 * 
 * $Id: CommentStyleListMojo.java 1797 2010-06-29 10:55:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-license-plugin/tags/maven-license-plugin-2.3.1/src/main/java/org/nuiton/license/plugin/CommentStyleListMojo.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.license.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.license.plugin.header.transformer.FileHeaderTransformer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Displays all the available comment style to box file headers.
 *
 * @author themit <chemit@codelutin.com>
 * @requiresProject false
 * @requiresDirectInvocation
 * @goal comment-style-list
 * @since 2.1
 */
public class CommentStyleListMojo extends AbstractLicenseMojo {

    /**
     * Un drapeau pour afficher aussi le contenu des license.
     *
     * @parameter expression="${detail}"
     * @since 2.1
     */
    private boolean detail;

    /**
     * All available header transformers.
     *
     * @component role="org.nuiton.license.plugin.header.transformer.FileHeaderTransformer"
     * @since 2.1
     */
    private Map<String, FileHeaderTransformer> transformers;

    @Override
    protected void init() throws Exception {
        //nothing to do
    }

    @Override
    public void doAction() throws MojoExecutionException, MojoFailureException {

        StringBuilder buffer = new StringBuilder();
        if (isVerbose()) {
            buffer.append("\n\n-------------------------------------------------------------------------------\n");
            buffer.append("                           maven-license-plugin\n");
            buffer.append("-------------------------------------------------------------------------------\n\n");
        }
        List<String> names = new ArrayList<String>(transformers.keySet());
        Collections.sort(names);

        int maxLength = 0;
        for (String name : names) {
            if (name.length() > maxLength) {
                maxLength = name.length();
            }
        }

        String pattern = "  - %1$-" + maxLength + "s : %2$s\n";

        buffer.append("List of available comment styles:\n\n");
        for (String transformerName : names) {
            FileHeaderTransformer transformer =
                    transformers.get(transformerName);
            buffer.append(String.format(pattern,
                                        transformerName,
                                        transformer.getDescription())
            );
            if (detail) {
                buffer.append("\n   example : \n");
                buffer.append(transformer.boxComment("header", true));
                buffer.append('\n');
            }
        }

        getLog().info(buffer.toString());
    }

    public boolean isDetail() {
        return detail;
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    public Map<String, FileHeaderTransformer> getTransformers() {
        return transformers;
    }

    public void setTransformers(Map<String, FileHeaderTransformer> transformers) {
        this.transformers = transformers;
    }
}
