/*
 * #%L
 * Maven helper plugin
 * 
 * $Id: SortedProperties.java 701 2010-04-15 14:01:44Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.2.5/src/main/java/org/nuiton/io/SortedProperties.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.io;

import org.nuiton.plugin.*;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

/**
 * Permet d'avoir les fichiers de proprietes tries.
 *
 * @author julien
 * @author tchemit <chemit@codelutin.com>
 */
public class SortedProperties extends Properties {

    private static final long serialVersionUID = -1147150444452577558L;
    /** l'encoding a utiliser pour lire et ecrire le properties. */
    protected String encoding;
    /** un drapeau pour savoir s'il faut enlever l'entete generere */
    protected boolean removeHeader;

    public SortedProperties(String encoding) {
        this(encoding, true);
    }

    public SortedProperties(String encoding, boolean removeHeader) {
        this.encoding = encoding;
        this.removeHeader = removeHeader;
    }

    public SortedProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        List<Object> objects = Collections.list(super.keys());
        Vector<Object> result;
        try {
            // Attention, si les clef ne sont pas des string, ca ne marchera pas
            List<String> list = PluginHelper.toGenericList(objects, String.class);
            Collections.sort(list);
            result = new Vector<Object>(list);
        } catch (IllegalArgumentException e) {
            // keys are not string !!!
            // can not sort keys
            result = new Vector<Object>(objects);
        }
        return result.elements();
    }

    /**
     * Charge le properties a partir d'un fichier.
     *
     * @param src le fichier src a charger en utilisant l'encoding declare
     * @return l'instance du properties
     * @throws IOException if any io pb
     */
    public SortedProperties load(File src) throws IOException {
        super.load(new InputStreamReader(new FileInputStream(src), encoding));
        return this;
    }

    /**
     * Sauvegarde le properties dans un fichier, sans commentaire et en utilisant l'encoding declare.
     *
     * @param dst the fichier de destination
     * @throws IOException if any io pb
     */
    public void store(File dst) throws IOException {
        if (removeHeader) {
            super.store(new OutputStreamWriter(new PropertiesDateRemoveFilterStream(new FileOutputStream(dst)), encoding), null);
        } else {
            super.store(new FileOutputStream(dst), null);
        }
    }

    /**
     * Sauvegarde le properties dans un fichier, sans commentaire en laissant java encode en unicode.
     *
     * @param dst le fichier de destination
     * @throws IOException if any io pb
     */
    public void store(OutputStream dst) throws IOException {
        if (removeHeader) {
            super.store(new PropertiesDateRemoveFilterStream(dst), null);
        } else {
            super.store(dst, null);
        }
    }
}
