/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.js.wro;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.util.ObjectFactory;

public class NuitonJsWroConfigurationFactory
implements ObjectFactory<WroConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(NuitonJsWroConfigurationFactory.class);
    protected FilterConfig filterConfig;

    public NuitonJsWroConfigurationFactory() {
    }

    public NuitonJsWroConfigurationFactory(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public final WroConfiguration create() {
        Properties properties = this.initProperties();
        properties = this.loadContextProperties(properties);
        return new PropertyWroConfigurationFactory(properties).create();
    }

    protected String getUserConfigPath() {
        return "/nuiton-js.properties";
    }

    protected Properties getDefaultConfig() {
        Properties result = new Properties();
        result.setProperty("managerFactoryClassName", "org.nuiton.js.wro.NuitonJsWroManagerFactory");
        result.setProperty("debug", "true");
        result.setProperty("preProcessors", "cssUrlRewriting,cssImport,semicolonAppender,cssMinJawr");
        result.setProperty("postProcessors", "cssVariables,jsMin");
        result.setProperty("uriLocators", " servletContext,uri,classpath");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties initProperties() {
        InputStream propertyStream;
        Properties result;
        block4: {
            result = this.getDefaultConfig();
            propertyStream = null;
            String file = this.getUserConfigPath();
            try {
                LOG.debug("loading config resource from: {}", (Object)file);
                propertyStream = this.loadAsStream(file);
                if (propertyStream == null) break block4;
                Properties props = new Properties();
                props.load(propertyStream);
                result.putAll((Map<?, ?>)props);
            }
            catch (Exception e) {
                try {
                    LOG.info("Cannot read properties file stream from default location: {}. Using default configuration.", (Object)file);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(propertyStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)propertyStream);
            }
        }
        IOUtils.closeQuietly((InputStream)propertyStream);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected Properties loadContextProperties(Properties current) {
        InputStream propertyStream;
        block4: {
            propertyStream = null;
            String file = "/WEB-INF/nuiton-js.properties";
            try {
                LOG.debug("loading config resource from: {}", (Object)file);
                propertyStream = this.getServletContext().getResourceAsStream(file);
                if (propertyStream == null) break block4;
                LOG.warn("Loading configuration from deprecated {} location. Update configuration to use classpath '/nuiton-js.properties' instead", (Object)file);
                Properties props = new Properties();
                props.load(propertyStream);
                current.putAll((Map<?, ?>)props);
            }
            catch (Exception e) {
                try {
                    LOG.debug("Cannot read properties file stream from servlet context location: {}.", (Object)file);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(propertyStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)propertyStream);
            }
        }
        IOUtils.closeQuietly((InputStream)propertyStream);
        return current;
    }

    protected InputStream loadAsStream(String file) throws Exception {
        InputStream result = NuitonJsWroConfigurationFactory.class.getResourceAsStream(file);
        return result;
    }

    protected ServletContext getServletContext() {
        ServletContext result = this.filterConfig != null ? this.filterConfig.getServletContext() : Context.get().getServletContext();
        return result;
    }
}

