package jaxx.runtime.swing.editor;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class NumberEditor extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_POPUP = "autoPopup";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_MODEL_TEXT = "modelText";
    public static final String PROPERTY_MODEL_TYPE = "modelType";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_SHOW_POPUP_BUTTON = "showPopupButton";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_USE_FLOAT = "useFloat";
    public static final String PROPERTY_USE_SIGN = "useSign";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_ENABLED = "button.enabled";
    public static final String BINDING_DOT_ENABLED = "dot.enabled";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_TEXT_FIELD_ENABLED = "textField.enabled";
    public static final String BINDING_TEXT_FIELD_TEXT = "textField.text";
    public static final String BINDING_TOGGLE_SIGN_ENABLED = "toggleSign.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON12_ENABLED = "$JButton12.enabled";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON7_ENABLED = "$JButton7.enabled";
    private static final String BINDING_$JTOOL_BAR0_VISIBLE = "$JToolBar0.visible";
    private static final String BINDING_$JTOOL_BAR1_VISIBLE = "$JToolBar1.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWYTW8bRRjHx05i561NISVqoKBAIg5IcZymgYZUpU1LKFFSojqgCEvQsXdiT1jvTHZnEweJl4/AR4A7ICFx41Q4cEQcuCC+AkIcuCKemV17vH5ZT5lIsZyZ//zmP8/MPM9uvv4TjQU+evEYN5sFP/QEbZDCzp3Dw3cqx6Qq7pGg6lMumI+in0wWZctoymm3BwItlnfl8JV4+Mpd1uDMI17H6M1dNBmIc5cEdUKEQM8nR1SDYKXU7t5s8tBvUdum+lG//Puv7BfO519lEWpycLcES1kYNkqvZHQXZakj0NMw0ylecbFXAxs+9Wrg94Jsu+viIHiAG+QEfYryuyjHsQ8wgV4yX7JiqPFNLtD40s4+9ohbFOjlhNPgDOYtEIfC2MKDsFEh/pvqD87V6ByM5T7jxBfnAl2S7grScSFyrFWjFYK9hCLaS60YazCHuAlJNKGWTCjJwTknAs1omVpLh6EwINsuwxCQp7RoizEXLGhZHmQlWvPkn892zIFDwfYZD3lXx0xQZ2eqYysUgvWMk90PSUBEd0dkmjRVx0XdMc0l7D0a0IpLugbl69hzXIgqWjbbj/uRviOcii7QnAxBMx64o/zvES/sCFe896tw5JJa2SpFr+i1LO1Ei4eDMpsQ65gsw9wOrVHRM2hVNlxL11wz0KwlNFXYVr9Hc92As26gedVA85qBnxsGnI3Bmsl2DIsmoo5I897elBhPClarue170RKNyxuOZWKNdSMOE6kCPdtafy8HcB+3sA8H6XLiIMXtUjjR1k/58mLpM6ZwH+pjKeB2bVPiOt3n/aDVkeTp+VWkcLI3V1ETCTTf5UyGRpuocUjszyWuJ5SMgi4ZOqdnymjMD6FZoCvl3irzELqi+nKlq75IoOr9d272tx/++H67VVTWYO5n+ko7aiIk+zg5Uzn1TFRRQkHdlT3MN8uQtIgLSVgVzKt9jJXibjAH80XZVA4v3MdBHRBj+d8f/zT36NcRlN1Gk5BznW0s9W/DltRhz+rMdZr8jdvK0fTZOHxegt8R2LIjVg0DDJkPjuARdmF70bRq28fUE8TRzSD1xHJAP4bv2dXrTQjT1T5hanutTPz8z2zpu9utUGXA+vxAuQ7X2PsoRz2XekRV4Li49q24UzwgocN0Ee1XVhFk33x8C+J0e6I+w56AZOBIHjGf1HwWeo6slm5ImqEUf6JWIL99lgAmbq4pN79YLG5sFIvD0MnrbEof8Ykz1LROjynYKbXlZ4TW6kJGQx6jNLCqslDP2SmUwCeD5zzmN7BrjH+C4ORcfM4AgC7edLDACxXqOZBJbvXMlZGfk9zgkFRw9aMo3FLzbX9SwYCUqzDfIb4VRTZ/Y+ljVKZuePK4Gd28BXhq8ynkXzIgSqtGrh7Ljx/7E9atCTcM1pUnnkxuadu0aW3EnnDLmnDHmnDPiPBLSiTfsvZgT9ixJuxZE/bNIzmAULLei3etV2FGSPNwaO3BjJDmoWztYTgB0ietRg+jA1x8YMC4EJWC+LkrxdAjA9jEkXzzxvEbrQUof6pfjAcsbjgGmjOXUwhV620eTuh6rk0JiwlLPzdbgqYEvAAdUN76x8T/Rg2LEDG/CDaEzHzKKupGhBesCBDSBm7SRtgowatKynJMUDnG8UmYtsdmS1q08jHs+hxbHw4jQqaYEgczwro14fUhhP8AGuIMG7QWAAA=";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.NumberEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean autoPopup;
    protected java.lang.Object bean;
    protected javax.swing.JToggleButton button;
    protected javax.swing.JButton dot;
    protected jaxx.runtime.swing.editor.NumberEditorHandler handler;
    protected java.lang.Number model;
    protected java.lang.String modelText;
    protected java.lang.Class modelType;
    protected javax.swing.JPopupMenu popup;
    protected java.lang.Boolean popupVisible;
    protected java.lang.String property;
    protected javax.swing.JButton resetButton;
    protected java.lang.Boolean showPopupButton;
    protected java.lang.Boolean showReset;
    protected javax.swing.JTextField textField;
    protected javax.swing.JButton toggleSign;
    protected java.lang.Boolean useFloat;
    protected java.lang.Boolean useSign;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NumberEditor $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JButton $JButton3;
    private javax.swing.JButton $JButton4;
    private javax.swing.JButton $JButton5;
    private javax.swing.JButton $JButton6;
    private javax.swing.JButton $JButton7;
    private javax.swing.JButton $JButton8;
    private javax.swing.JButton $JButton9;
    private javax.swing.JButton $JButton10;
    private javax.swing.JButton $JButton11;
    private javax.swing.JButton $JButton12;
    private javax.swing.JButton $JButton13;
    private javax.swing.JToolBar $JToolBar0;
    private javax.swing.JToolBar $JToolBar1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() {
        handler.init();
    }
    
    public NumberEditor getEditor() {
        return this;
    }
    
    public void addChar(ActionEvent event) {
        getHandler().addChar(((JButton)event.getSource()).getText());
    }
    
    void showPopup() {
       if ( popupVisible || autoPopup ) {
           if (!popupVisible) {
               setPopupVisible(true);
           } else if (!getPopup().isVisible()) {
               getHandler().setPopupVisible(true);
           }
       }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor() {
        $initialize();
    }

    public NumberEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton10(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doMouseEntered__on__$JButton10(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton10, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton10.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton10.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton5(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doFocusGained__on__textField(java.awt.event.FocusEvent event) {
        showPopup();
    }

    public void doKeyReleased__on__textField(java.awt.event.KeyEvent event) {
        getHandler().setModel(textField.getText());
    }

    public void doMouseExited__on__$JButton10(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton10, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton10.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton10.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton10.setFont($JButton10.getFont().deriveFont($JButton10.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton4(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton4, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton4.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton4.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton4(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton4, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton4.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton4.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton4.setFont($JButton4.getFont().deriveFont($JButton4.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton5(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton5, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton5.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton5.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton5(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton5, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton5.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton5.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton5.setFont($JButton5.getFont().deriveFont($JButton5.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doActionPerformed__on__$JButton6(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doMouseEntered__on__$JButton6(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton6, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton6.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton6.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton6(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton6, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton6.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton6.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton6.setFont($JButton6.getFont().deriveFont($JButton6.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton13(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton13, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton13.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton13.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton13(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton13, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton13.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton13.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton13.setFont($JButton13.getFont().deriveFont($JButton13.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton1(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton1, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton1.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton1.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton7(java.awt.event.ActionEvent event) {
        getHandler().removeChar();
    }

    public void doActionPerformed__on__dot(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doMouseEntered__on__$JButton1(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton1, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton1.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton1.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton1.setFont($JButton1.getFont().deriveFont($JButton1.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton7(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton7, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton7.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton7.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton0(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton0, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton0.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__dot(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, dot, "font-weight", "normal", jaxx.runtime.css.Pseudoclasses.wrap((dot.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (dot.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() | Font.BOLD));
            } else {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton7(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton7, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton7.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton7.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton7.setFont($JButton7.getFont().deriveFont($JButton7.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton0(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton0, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton0.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton11(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton11, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton11.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton11.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        setModel(null);
    }

    public void doMouseEntered__on__$JButton3(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton3, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton3.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton3.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doActionPerformed__on__$JButton12(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__toggleSign(java.awt.event.ActionEvent event) {
        getHandler().toggleSign();
    }

    public void doFocusGained__on__$JPanel0(java.awt.event.FocusEvent event) {
        textField.requestFocus();
    }

    public void doMouseEntered__on__$JButton12(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton12, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton12.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton12.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doFocusLost__on__$JPanel0(java.awt.event.FocusEvent event) {
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doMouseEntered__on__$JButton11(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton11, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton11.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton11.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton11.setFont($JButton11.getFont().deriveFont($JButton11.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__$JButton9(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton9, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton9.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton9.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doActionPerformed__on__$JButton8(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__$JButton13(java.awt.event.ActionEvent event) {
        getHandler().validate();
    }

    public void doActionPerformed__on__$JButton9(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doActionPerformed__on__button(java.awt.event.ActionEvent event) {
        getHandler().setPopupVisible(!popup.isVisible());
    }

    public void doActionPerformed__on__resetButton(java.awt.event.ActionEvent event) {
        setModel(null);
    }

    public void doMouseEntered__on__$JButton8(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton8, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton8.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton8.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__resetButton(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, resetButton, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap((resetButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (resetButton.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() | Font.BOLD));
            } else {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__toggleSign(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, toggleSign, "font-weight", "normal", jaxx.runtime.css.Pseudoclasses.wrap((toggleSign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (toggleSign.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() | Font.BOLD));
            } else {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton3(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton3, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton3.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton3.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton3.setFont($JButton3.getFont().deriveFont($JButton3.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton12(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton12, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton12.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton12.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton12.setFont($JButton12.getFont().deriveFont($JButton12.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        addChar(event);
    }

    public void doMouseEntered__on__$JButton2(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.applyProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton2, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton2.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton2.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton2(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton2, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton2.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton2.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton2.setFont($JButton2.getFont().deriveFont($JButton2.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JPanel0(java.awt.event.MouseEvent event) {
        setPopupVisible(false);popup.setVisible(false);
    }

    public void doMouseExited__on__$JButton9(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton9, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton9.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton9.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton9.setFont($JButton9.getFont().deriveFont($JButton9.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton8(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, $JButton8, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap(($JButton8.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if ($JButton8.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton8.setFont($JButton8.getFont().deriveFont($JButton8.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__dot(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, dot, "font-weight", "normal", jaxx.runtime.css.Pseudoclasses.wrap((dot.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (dot.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() | Font.BOLD));
            } else {
                dot.setFont(dot.getFont().deriveFont(dot.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__resetButton(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, resetButton, "font-weight", "bold", jaxx.runtime.css.Pseudoclasses.wrap((resetButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (resetButton.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() | Font.BOLD));
            } else {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__toggleSign(java.awt.event.MouseEvent event) {
        java.lang.Object value = jaxx.runtime.css.Pseudoclasses.removeProperty(jaxx.runtime.swing.editor.NumberEditor.this, toggleSign, "font-weight", "normal", jaxx.runtime.css.Pseudoclasses.wrap((toggleSign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof jaxx.runtime.css.DataBinding)) {
            if (toggleSign.getFont() != null) {
            if (((java.lang.String) value).equals("bold")) {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() | Font.BOLD));
            } else {
                toggleSign.setFont(toggleSign.getFont().deriveFont(toggleSign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeVisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAutoPopup() {
        return autoPopup;
    }

    public java.lang.Object getBean() {
        return bean;
    }

    public javax.swing.JToggleButton getButton() {
        return button;
    }

    public javax.swing.JButton getDot() {
        return dot;
    }

    public jaxx.runtime.swing.editor.NumberEditorHandler getHandler() {
        return handler;
    }

    public java.lang.Number getModel() {
        return model;
    }

    public java.lang.String getModelText() {
        return modelText;
    }

    public java.lang.Class getModelType() {
        return modelType;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public java.lang.Boolean getPopupVisible() {
        return popupVisible;
    }

    public java.lang.String getProperty() {
        return property;
    }

    public javax.swing.JButton getResetButton() {
        return resetButton;
    }

    public java.lang.Boolean getShowPopupButton() {
        return showPopupButton;
    }

    public java.lang.Boolean getShowReset() {
        return showReset;
    }

    public javax.swing.JTextField getTextField() {
        return textField;
    }

    public javax.swing.JButton getToggleSign() {
        return toggleSign;
    }

    public java.lang.Boolean getUseFloat() {
        return useFloat;
    }

    public java.lang.Boolean getUseSign() {
        return useSign;
    }

    public java.lang.Boolean isAutoPopup() {
        return autoPopup !=null && autoPopup;
    }

    public java.lang.Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    public java.lang.Boolean isShowPopupButton() {
        return showPopupButton !=null && showPopupButton;
    }

    public java.lang.Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public java.lang.Boolean isUseFloat() {
        return useFloat !=null && useFloat;
    }

    public java.lang.Boolean isUseSign() {
        return useSign !=null && useSign;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoPopup(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.autoPopup;
        this.autoPopup = newValue;
        firePropertyChange(PROPERTY_AUTO_POPUP, oldValue, newValue);
    }

    public void setBean(java.lang.Object newValue) {
        java.lang.Object oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setModel(java.lang.Number newValue) {
        java.lang.Number oldValue = this.model;
        this.model = newValue;
        firePropertyChange(PROPERTY_MODEL, oldValue, newValue);
    }

    public void setModelText(java.lang.String newValue) {
        java.lang.String oldValue = this.modelText;
        this.modelText = newValue;
        firePropertyChange(PROPERTY_MODEL_TEXT, oldValue, newValue);
    }

    public void setModelType(java.lang.Class newValue) {
        java.lang.Class oldValue = this.modelType;
        this.modelType = newValue;
        firePropertyChange(PROPERTY_MODEL_TYPE, oldValue, newValue);
    }

    public void setPopupVisible(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popupVisible;
        this.popupVisible = newValue;
        firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, newValue);
    }

    public void setProperty(java.lang.String newValue) {
        java.lang.String oldValue = this.property;
        this.property = newValue;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, newValue);
    }

    public void setShowPopupButton(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showPopupButton;
        this.showPopupButton = newValue;
        firePropertyChange(PROPERTY_SHOW_POPUP_BUTTON, oldValue, newValue);
    }

    public void setShowReset(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.showReset;
        this.showReset = newValue;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, newValue);
    }

    public void setUseFloat(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.useFloat;
        this.useFloat = newValue;
        firePropertyChange(PROPERTY_USE_FLOAT, oldValue, newValue);
    }

    public void setUseSign(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.useSign;
        this.useSign = newValue;
        firePropertyChange(PROPERTY_USE_SIGN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JButton get$JButton5() {
        return $JButton5;
    }

    protected javax.swing.JButton get$JButton6() {
        return $JButton6;
    }

    protected javax.swing.JButton get$JButton7() {
        return $JButton7;
    }

    protected javax.swing.JButton get$JButton8() {
        return $JButton8;
    }

    protected javax.swing.JButton get$JButton9() {
        return $JButton9;
    }

    protected javax.swing.JButton get$JButton10() {
        return $JButton10;
    }

    protected javax.swing.JButton get$JButton11() {
        return $JButton11;
    }

    protected javax.swing.JButton get$JButton12() {
        return $JButton12;
    }

    protected javax.swing.JButton get$JButton13() {
        return $JButton13;
    }

    protected javax.swing.JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected javax.swing.JToolBar get$JToolBar1() {
        return $JToolBar1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add($JPanel1);
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("numbereditor.7"));
        $JButton0.setFocusable(false);
        $JButton0.setFocusPainted(false);
        if ($JButton0.getFont() != null) {
            $JButton0.setFont($JButton0.getFont().deriveFont((float) 14));
        }
        $JButton0.setForeground(new Color(0, 0, 255));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        $JButton0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton0"));
        $JButton0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton0"));
    }

    protected void create$JButton1() {
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("numbereditor.8"));
        $JButton1.setFocusable(false);
        $JButton1.setFocusPainted(false);
        if ($JButton1.getFont() != null) {
            $JButton1.setFont($JButton1.getFont().deriveFont((float) 14));
        }
        $JButton1.setForeground(new Color(0, 0, 255));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        $JButton1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton1"));
        $JButton1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton1"));
    }

    protected void create$JButton2() {
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("numbereditor.9"));
        $JButton2.setFocusable(false);
        $JButton2.setFocusPainted(false);
        if ($JButton2.getFont() != null) {
            $JButton2.setFont($JButton2.getFont().deriveFont((float) 14));
        }
        $JButton2.setForeground(new Color(0, 0, 255));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        $JButton2.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton2"));
        $JButton2.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton2"));
    }

    protected void create$JButton3() {
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("numbereditor.clearAll"));
        $JButton3.setFocusable(false);
        $JButton3.setFocusPainted(false);
        if ($JButton3.getFont() != null) {
            $JButton3.setFont($JButton3.getFont().deriveFont((float) 14));
        }
        $JButton3.setForeground(new Color(255, 0, 0));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        $JButton3.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton3"));
        $JButton3.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton3"));
    }

    protected void create$JButton4() {
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("numbereditor.4"));
        $JButton4.setFocusable(false);
        $JButton4.setFocusPainted(false);
        if ($JButton4.getFont() != null) {
            $JButton4.setFont($JButton4.getFont().deriveFont((float) 14));
        }
        $JButton4.setForeground(new Color(0, 0, 255));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        $JButton4.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton4"));
        $JButton4.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton4"));
    }

    protected void create$JButton5() {
        $objectMap.put("$JButton5", $JButton5 = new javax.swing.JButton());
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("numbereditor.5"));
        $JButton5.setFocusable(false);
        $JButton5.setFocusPainted(false);
        if ($JButton5.getFont() != null) {
            $JButton5.setFont($JButton5.getFont().deriveFont((float) 14));
        }
        $JButton5.setForeground(new Color(0, 0, 255));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        $JButton5.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton5"));
        $JButton5.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton5"));
    }

    protected void create$JButton6() {
        $objectMap.put("$JButton6", $JButton6 = new javax.swing.JButton());
        $JButton6.setName("$JButton6");
        $JButton6.setText(_("numbereditor.6"));
        $JButton6.setFocusable(false);
        $JButton6.setFocusPainted(false);
        if ($JButton6.getFont() != null) {
            $JButton6.setFont($JButton6.getFont().deriveFont((float) 14));
        }
        $JButton6.setForeground(new Color(0, 0, 255));
        $JButton6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        $JButton6.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton6"));
        $JButton6.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton6"));
    }

    protected void create$JButton7() {
        $objectMap.put("$JButton7", $JButton7 = new javax.swing.JButton());
        $JButton7.setName("$JButton7");
        $JButton7.setText(_("numbereditor.clearOne"));
        $JButton7.setFocusable(false);
        $JButton7.setFocusPainted(false);
        if ($JButton7.getFont() != null) {
            $JButton7.setFont($JButton7.getFont().deriveFont((float) 14));
        }
        $JButton7.setForeground(new Color(255, 0, 0));
        $JButton7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton7"));
        $JButton7.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton7"));
        $JButton7.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton7"));
    }

    protected void create$JButton8() {
        $objectMap.put("$JButton8", $JButton8 = new javax.swing.JButton());
        $JButton8.setName("$JButton8");
        $JButton8.setText(_("numbereditor.1"));
        $JButton8.setFocusable(false);
        $JButton8.setFocusPainted(false);
        if ($JButton8.getFont() != null) {
            $JButton8.setFont($JButton8.getFont().deriveFont((float) 14));
        }
        $JButton8.setForeground(new Color(0, 0, 255));
        $JButton8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton8"));
        $JButton8.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton8"));
        $JButton8.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton8"));
    }

    protected void create$JButton9() {
        $objectMap.put("$JButton9", $JButton9 = new javax.swing.JButton());
        $JButton9.setName("$JButton9");
        $JButton9.setText(_("numbereditor.2"));
        $JButton9.setFocusable(false);
        $JButton9.setFocusPainted(false);
        if ($JButton9.getFont() != null) {
            $JButton9.setFont($JButton9.getFont().deriveFont((float) 14));
        }
        $JButton9.setForeground(new Color(0, 0, 255));
        $JButton9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton9"));
        $JButton9.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton9"));
        $JButton9.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton9"));
    }

    protected void create$JButton10() {
        $objectMap.put("$JButton10", $JButton10 = new javax.swing.JButton());
        $JButton10.setName("$JButton10");
        $JButton10.setText(_("numbereditor.3"));
        $JButton10.setFocusable(false);
        $JButton10.setFocusPainted(false);
        if ($JButton10.getFont() != null) {
            $JButton10.setFont($JButton10.getFont().deriveFont((float) 14));
        }
        $JButton10.setForeground(new Color(0, 0, 255));
        $JButton10.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton10"));
        $JButton10.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton10"));
        $JButton10.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton10"));
    }

    protected void create$JButton11() {
        $objectMap.put("$JButton11", $JButton11 = new javax.swing.JButton());
        $JButton11.setName("$JButton11");
        $JButton11.setEnabled(false);
        $JButton11.setFocusable(false);
        $JButton11.setFocusPainted(false);
        if ($JButton11.getFont() != null) {
            $JButton11.setFont($JButton11.getFont().deriveFont((float) 14));
        }
        $JButton11.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton11"));
        $JButton11.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton11"));
    }

    protected void create$JButton12() {
        $objectMap.put("$JButton12", $JButton12 = new javax.swing.JButton());
        $JButton12.setName("$JButton12");
        $JButton12.setText(_("numbereditor.0"));
        $JButton12.setFocusable(false);
        $JButton12.setFocusPainted(false);
        if ($JButton12.getFont() != null) {
            $JButton12.setFont($JButton12.getFont().deriveFont((float) 14));
        }
        $JButton12.setForeground(new Color(0, 0, 255));
        $JButton12.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton12"));
        $JButton12.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton12"));
        $JButton12.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton12"));
    }

    protected void create$JButton13() {
        $objectMap.put("$JButton13", $JButton13 = new javax.swing.JButton());
        $JButton13.setName("$JButton13");
        $JButton13.setFocusable(false);
        $JButton13.setFocusPainted(false);
        if ($JButton13.getFont() != null) {
            $JButton13.setFont($JButton13.getFont().deriveFont((float) 14));
        }
        $JButton13.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton13"));
        $JButton13.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton13"));
        $JButton13.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton13"));
    }

    protected void createAutoPopup() {
        $objectMap.put("autoPopup", autoPopup = false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createButton() {
        $objectMap.put("button", button = new javax.swing.JToggleButton());
        button.setName("button");
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setToolTipText(_("numbereditor.action.show.tip"));
        button.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__button"));
    }

    protected void createDot() {
        $objectMap.put("dot", dot = new javax.swing.JButton());
        dot.setName("dot");
        dot.setText(_("numbereditor.."));
        dot.setFocusable(false);
        dot.setFocusPainted(false);
        if (dot.getFont() != null) {
            dot.setFont(dot.getFont().deriveFont((float) 14));
        }
        dot.setForeground(new Color(0, 153, 0));
        dot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__dot"));
        dot.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__dot"));
        dot.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__dot"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new jaxx.runtime.swing.editor.NumberEditorHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createModelText() {
        $objectMap.put("modelText", modelText = "");
    }

    protected void createModelType() {
        $objectMap.put("modelType", modelType = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new javax.swing.JPopupMenu());
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeVisible", this, "doPopupMenuWillBecomeVisible__on__popup"));
    }

    protected void createPopupVisible() {
        $objectMap.put("popupVisible", popupVisible = false);
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new javax.swing.JButton());
        resetButton.setName("resetButton");
        resetButton.setFocusPainted(false);
        resetButton.setFocusable(false);
        resetButton.setToolTipText(_("numbereditor.action.reset.tip"));
        if (resetButton.getFont() != null) {
            resetButton.setFont(resetButton.getFont().deriveFont((float) 14));
        }
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
        resetButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__resetButton"));
        resetButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__resetButton"));
    }

    protected void createShowPopupButton() {
        $objectMap.put("showPopupButton", showPopupButton = false);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new javax.swing.JTextField());
        textField.setName("textField");
        textField.setColumns(15);
        textField.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__textField"));
        textField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textField"));
    }

    protected void createToggleSign() {
        $objectMap.put("toggleSign", toggleSign = new javax.swing.JButton());
        toggleSign.setName("toggleSign");
        toggleSign.setText(_("numbereditor.toggleSign"));
        toggleSign.setFocusable(false);
        toggleSign.setFocusPainted(false);
        if (toggleSign.getFont() != null) {
            toggleSign.setFont(toggleSign.getFont().deriveFont((float) 14));
        }
        toggleSign.setForeground(new Color(0, 153, 0));
        toggleSign.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__toggleSign"));
        toggleSign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__toggleSign"));
        toggleSign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__toggleSign"));
    }

    protected void createUseFloat() {
        $objectMap.put("useFloat", useFloat = false);
    }

    protected void createUseSign() {
        $objectMap.put("useSign", useSign = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add($JToolBar0, BorderLayout.WEST);
        add(textField, BorderLayout.CENTER);
        add($JToolBar1, BorderLayout.EAST);
        addChildrenToPopup();
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton0);
        $JPanel1.add($JButton1);
        $JPanel1.add($JButton2);
        $JPanel1.add($JButton3);
        $JPanel1.add($JButton4);
        $JPanel1.add($JButton5);
        $JPanel1.add($JButton6);
        $JPanel1.add($JButton7);
        $JPanel1.add($JButton8);
        $JPanel1.add($JButton9);
        $JPanel1.add($JButton10);
        $JPanel1.add($JButton11);
        $JPanel1.add($JButton12);
        $JPanel1.add(toggleSign);
        $JPanel1.add(dot);
        $JPanel1.add($JButton13);
        // inline complete setup of $JToolBar0
        $JToolBar0.add(resetButton);
        // inline complete setup of $JToolBar1
        $JToolBar1.add(button);
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        $JPanel1.setBackground(Color.WHITE);
        $JPanel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        $JButton13.setIcon(jaxx.runtime.SwingUtil.createActionIcon("numbereditor-validate"));
        resetButton.setIcon(jaxx.runtime.SwingUtil.createActionIcon("numbereditor-reset"));
        $JToolBar1.setMaximumSize(new Dimension(24,24));
        button.setIcon(jaxx.runtime.SwingUtil.createActionIcon("numbereditor-calculator"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 11 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createProperty();
        createBean();
        createModel();
        createModelType();
        createUseFloat();
        createUseSign();
        createAutoPopup();
        createShowPopupButton();
        createShowReset();
        createModelText();
        createPopupVisible();
        createHandler();
        createPopup();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(4,4));
        create$JButton0();
        create$JButton1();
        create$JButton2();
        create$JButton3();
        create$JButton4();
        create$JButton5();
        create$JButton6();
        create$JButton7();
        create$JButton8();
        create$JButton9();
        create$JButton10();
        create$JButton11();
        create$JButton12();
        createToggleSign();
        createDot();
        create$JButton13();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new javax.swing.JToolBar());
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        createResetButton();
        createTextField();
        // inline creation of $JToolBar1
        $objectMap.put("$JToolBar1", $JToolBar1 = new javax.swing.JToolBar());
        $JToolBar1.setName("$JToolBar1");
        $JToolBar1.setBorderPainted(false);
        $JToolBar1.setFloatable(false);
        $JToolBar1.setOpaque(false);
        createButton();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JPanel0"));
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$JPanel0"));
        $JPanel0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JPanel0"));
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON3_ENABLED, true ,"modelText") {
        
            @Override
            public void processDataBinding() {
                if (getModelText() != null) {
                    $JButton3.setEnabled(!getModelText().isEmpty());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON7_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("modelText", this);
                if (textField != null) {
                    textField.addPropertyChangeListener("caretPosition", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModelText() != null && textField != null) {
                    $JButton7.setEnabled(!(getModelText().isEmpty() || textField.getCaretPosition() ==0 ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("modelText", this);
                if (textField != null) {
                    textField.removePropertyChangeListener("caretPosition", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON12_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getEditor() != null) {
                    getEditor().addPropertyChangeListener("modelText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEditor() != null && getEditor().getModelText() != null) {
                    $JButton12.setEnabled(!getEditor().getModelText().equals("0"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getEditor() != null) {
                    getEditor().removePropertyChangeListener("modelText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOGGLE_SIGN_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("useSign", this);
                if (getEditor() != null) {
                    getEditor().addPropertyChangeListener("modelText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEditor() != null && getEditor().getModelText() != null) {
                    toggleSign.setEnabled(isUseSign() && !getEditor().getModelText().isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("useSign", this);
                if (getEditor() != null) {
                    getEditor().removePropertyChangeListener("modelText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOT_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("useFloat", this);
                if (getEditor() != null) {
                    getEditor().addPropertyChangeListener("modelText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEditor() != null && getEditor().getModelText() != null) {
                    dot.setEnabled(isUseFloat() && getEditor().getModelText().indexOf(".") == -1 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("useFloat", this);
                if (getEditor() != null) {
                    getEditor().removePropertyChangeListener("modelText", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR0_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                $JToolBar0.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_FIELD_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textField.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_FIELD_TEXT, true ,"modelText") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText(textField, getModelText());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTOOL_BAR1_VISIBLE, true ,"showPopupButton") {
        
            @Override
            public void processDataBinding() {
                $JToolBar1.setVisible(isShowPopupButton());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                button.setEnabled(isEnabled());
            }
        });
    }

}