/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.absolute;

import com.google.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import jaxx.runtime.spi.UIHandler;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.DmsCoordinate;
import org.nuiton.jaxx.widgets.gis.DmsCoordinateConverter;
import org.nuiton.jaxx.widgets.gis.MaskFormatterFromConverter;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditorModel;
import org.nuiton.jaxx.widgets.jformattedtextfield.JFormattedTextFieldNavigationManager;
import org.nuiton.util.beans.BeanUtil;

public class AbsoluteDmsCoordinateEditorHandler
implements UIHandler<AbsoluteDmsCoordinateEditor> {
    private static final Log log = LogFactory.getLog(AbsoluteDmsCoordinateEditorHandler.class);
    protected AbsoluteDmsCoordinateEditor ui;
    protected Method degreeMutator;
    protected Method minuteMutator;
    protected Method secondMutator;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;
    protected DmsCoordinateConverter coordinateConverter;

    public void beforeInit(AbsoluteDmsCoordinateEditor ui) {
        this.ui = ui;
        this.coordinateConverter = new DmsCoordinateConverter();
    }

    public void afterInit(AbsoluteDmsCoordinateEditor ui) {
    }

    public void resetModel() {
        this.ui.getModel().reset();
    }

    public void init(boolean longitudeEditor) {
        MaskFormatterFromConverter<DmsCoordinate> maskFormatter;
        final AbsoluteDmsCoordinateEditorModel model = this.ui.getModel();
        Preconditions.checkNotNull((Object)model.getBean(), (Object)("could not find bean in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyDegree(), (Object)("could not find propertyDegree in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertyMinute(), (Object)("could not find propertyMinute in " + this.ui));
        Preconditions.checkNotNull((Object)model.getPropertySecond(), (Object)("could not find propertySecond in " + this.ui));
        Serializable bean = model.getBean();
        this.degreeMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDegree());
        Preconditions.checkNotNull((Object)this.degreeMutator, (Object)("could not find mutator for " + model.getPropertyDegree()));
        this.minuteMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyMinute());
        Preconditions.checkNotNull((Object)this.minuteMutator, (Object)("could not find mutator for " + model.getPropertyMinute()));
        this.secondMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertySecond());
        Preconditions.checkNotNull((Object)this.secondMutator, (Object)("could not find mutator for " + model.getPropertySecond()));
        this.coordinateConverter.setForLongitude(longitudeEditor);
        String pattern = this.getMaskFormatterPattern(longitudeEditor);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DmsCoordinate.class, pattern, (Converter)this.coordinateConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        JFormattedTextField editor = this.ui.getEditor();
        DefaultFormatterFactory formatterFactory = new DefaultFormatterFactory(maskFormatter);
        editor.setFormatterFactory(formatterFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DmsCoordinate newValue = (DmsCoordinate)((Object)evt.getNewValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Value has changed: " + (Object)((Object)newValue)));
                }
                model.setValue(newValue);
            }
        });
        JFormattedTextFieldNavigationManager.install((JFormattedTextField)editor);
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreeMutator));
        model.addPropertyChangeListener("minute", new ModelPropertyChangeListener(model, this.minuteMutator));
        model.addPropertyChangeListener("second", new ModelPropertyChangeListener(model, this.secondMutator));
    }

    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) {
        block5: {
            this.coordinateConverter.setDisplayZeroWhenNull(displayZeroWhenNull);
            if (log.isDebugEnabled()) {
                log.debug((Object)("setDisplayZeroWhenNull: " + displayZeroWhenNull));
            }
            AbsoluteDmsCoordinateEditorModel model = this.ui.getModel();
            JFormattedTextField editor = this.ui.getEditor();
            JFormattedTextField.AbstractFormatter formatter = editor.getFormatter();
            if (formatter != null) {
                try {
                    String newStringValue = formatter.valueToString((Object)model);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("updating string value: " + newStringValue));
                    }
                    editor.setText(newStringValue);
                }
                catch (ParseException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Could not parse new string value", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(DmsCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue((Object)value);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
    }

    protected String getMaskFormatterPattern(boolean longitudeEditor) {
        String pattern = "**\u00b0**''**''''";
        if (longitudeEditor) {
            pattern = "*" + pattern;
        }
        return pattern;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final AbsoluteDmsCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(AbsoluteDmsCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!AbsoluteDmsCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    AbsoluteDmsCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke((Object)this.model.getBean(), newValue);
                    }
                    finally {
                        AbsoluteDmsCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

