/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import com.google.common.base.Preconditions;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.plaf.basic.BasicSliderUI;
import jaxx.runtime.spi.UIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditorModel;
import org.nuiton.util.beans.BeanUtil;

public class DateTimeEditorHandler
implements UIHandler<DateTimeEditor> {
    private static final Log log = LogFactory.getLog(DateTimeEditorHandler.class);
    protected DateTimeEditor ui;
    protected final Calendar calendarMinute = new GregorianCalendar();
    protected final Calendar calendarHour = new GregorianCalendar();

    public void beforeInit(DateTimeEditor ui) {
        DateTimeEditorModel model = new DateTimeEditorModel();
        ui.setContextValue(model);
        this.ui = ui;
    }

    public void afterInit(DateTimeEditor ui) {
        ui.getMinuteEditor().setEditor(new JSpinner.DateEditor(ui.getMinuteEditor(), "mm"));
        ui.getHourEditor().setEditor(new JSpinner.DateEditor(ui.getHourEditor(), "HH"));
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < 25; i += 2) {
            labelTable.put(i * 60, new JLabel(i + ""));
        }
        JSlider slider = ui.getSlider();
        slider.setLabelTable(labelTable);
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int value = this.getSliderValue(e);
                JSlider slider = (JSlider)e.getComponent();
                slider.setValueIsAdjusting(true);
                slider.setValue(value);
                slider.setValueIsAdjusting(false);
                this.showToolTip(e);
                e.consume();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.showToolTip(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.showToolTip(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.showToolTip(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showToolTip(e);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JSlider slider = (JSlider)e.getComponent();
                int nb = e.getWheelRotation();
                int value = slider.getValue() - nb;
                slider.setValueIsAdjusting(true);
                slider.setValue(value);
                slider.setValueIsAdjusting(false);
                e.consume();
            }

            int getSliderValue(MouseEvent e) {
                JSlider slider = (JSlider)e.getSource();
                int value = -1;
                if (slider.getUI() instanceof BasicSliderUI) {
                    BasicSliderUI ui = (BasicSliderUI)slider.getUI();
                    value = slider.getOrientation() == 0 ? ui.valueForXPosition(e.getX()) : ui.valueForYPosition(e.getY());
                }
                return value;
            }

            void showToolTip(MouseEvent e) {
                int value = this.getSliderValue(e);
                if (value == -1) {
                    return;
                }
                int h = value / 60;
                int m = value % 60;
                String text = "";
                if (h < 10) {
                    text = "0";
                }
                text = text + h + " : ";
                if (m < 10) {
                    text = text + "0";
                }
                text = text + m;
                JSlider source = (JSlider)e.getSource();
                source.setToolTipText(text);
            }
        };
        slider.addMouseListener(m);
        slider.addMouseMotionListener(m);
        slider.addMouseWheelListener(m);
    }

    public void init(DateTimeEditor ui) {
        DateTimeEditorModel model = ui.getModel();
        Serializable bean = model.getBean();
        if (bean != null) {
            if (model.getPropertyDayDate() != null) {
                Method dayDateMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDayDate());
                Preconditions.checkNotNull((Object)dayDateMutator, (Object)("could not find mutator for " + model.getPropertyDayDate()));
                model.addPropertyChangeListener("dayDate", new ModelPropertyChangeListener(model, dayDateMutator));
            }
            if (model.getPropertyTimeDate() != null) {
                Method timeDateMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyTimeDate());
                Preconditions.checkNotNull((Object)timeDateMutator, (Object)("could not find mutator for " + model.getPropertyTimeDate()));
                model.addPropertyChangeListener("timeDate", new ModelPropertyChangeListener(model, timeDateMutator));
            }
            if (model.getPropertyDate() != null) {
                Method fullDateMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDate());
                Preconditions.checkNotNull((Object)fullDateMutator, (Object)("could not find mutator for " + model.getPropertyDate()));
                model.addPropertyChangeListener("date", new ModelPropertyChangeListener(model, fullDateMutator));
            }
        }
    }

    public Date getMinuteModelValue(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = new Date();
        }
        this.calendarMinute.setTime(incomingDate);
        this.calendarMinute.set(11, 0);
        incomingDate = this.calendarMinute.getTime();
        return incomingDate;
    }

    public Date getHourModelValue(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = new Date();
        }
        this.calendarHour.setTime(incomingDate);
        this.calendarHour.set(12, 0);
        incomingDate = this.calendarHour.getTime();
        return incomingDate;
    }

    public void setHours(Date hourDate) {
        DateTimeEditorModel model = this.ui.getModel();
        Date oldTimeDate = model.getTimeDate();
        if (oldTimeDate == null) {
            return;
        }
        this.calendarHour.setTime(hourDate);
        int newHour = this.calendarHour.get(11);
        int newMinute = this.calendarHour.get(12);
        int oldHour = model.getHour(oldTimeDate);
        int oldMinute = model.getMinute(oldTimeDate);
        if (oldHour == newHour && oldMinute == newMinute) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Do not update time model , stay on same time = " + oldHour + ":" + oldMinute));
            }
            return;
        }
        int hour = newHour;
        int minute = oldMinute;
        if (log.isDebugEnabled()) {
            log.debug((Object)("hh:mm (old from dateModel)   = " + oldHour + ":" + oldMinute));
            log.debug((Object)("hh:mm (new from hourModel) = " + newHour + ":" + newMinute));
        }
        Integer dayAdjust = null;
        if (newHour == 0 && oldHour == 23) {
            dayAdjust = 1;
        } else if (newHour == 23 && oldHour == 0) {
            dayAdjust = -1;
        }
        if (dayAdjust != null) {
            Date oldDayDate = model.getDayDate();
            this.calendarHour.setTime(oldDayDate);
            this.calendarHour.add(6, dayAdjust);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update day to " + this.calendarHour.get(6)));
            }
            Date newDayDate = this.calendarHour.getTime();
            model.setDayDate(newDayDate);
        }
        model.setTimeInMinutes(hour * 60 + minute);
    }

    public void setMinutes(Date minuteDate) {
        DateTimeEditorModel model = this.ui.getModel();
        Date oldTimeDate = model.getTimeDate();
        if (oldTimeDate == null) {
            return;
        }
        this.calendarMinute.setTime(minuteDate);
        int newHour = this.calendarMinute.get(11);
        int newMinute = this.calendarMinute.get(12);
        int oldHour = model.getHour(oldTimeDate);
        int oldMinute = model.getMinute(oldTimeDate);
        if (oldHour == newHour && oldMinute == newMinute) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Do not update time model , stay on same time = " + oldHour + ":" + oldMinute));
            }
            return;
        }
        int hour = oldHour;
        int minute = newMinute;
        if (log.isDebugEnabled()) {
            log.debug((Object)("hh:mm (old from dateModel)   = " + oldHour + ":" + oldMinute));
            log.debug((Object)("hh:mm (new from minuteModel) = " + newHour + ":" + newMinute));
        }
        Integer dayAdjust = null;
        if (newMinute == 0) {
            if (newHour == 1) {
                if (oldHour == 23) {
                    dayAdjust = 1;
                }
                hour = (oldHour + 1) % 24;
            }
        } else if (newMinute == 59 && newHour == 23) {
            if (oldHour == 0) {
                dayAdjust = -1;
            }
            hour = (oldHour - 1) % 24;
        }
        if (dayAdjust != null) {
            Date oldDayDate = model.getDayDate();
            this.calendarHour.setTime(oldDayDate);
            this.calendarHour.add(6, dayAdjust);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update day to " + this.calendarHour.get(6)));
            }
            Date newDayDate = this.calendarHour.getTime();
            model.setDayDate(newDayDate);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Update time model to hh:mm = " + hour + ":" + minute));
        }
        model.setTimeInMinutes(hour * 60 + minute);
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final DateTimeEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(DateTimeEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.model.isValueIsAdjusting()) {
                Object newValue = evt.getNewValue();
                try {
                    this.mutator.invoke((Object)this.model.getBean(), newValue);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

