/*
 * Decompiled with CFR 0.152.
 */
package jaxx.demo.config;

import java.awt.Frame;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jaxx.demo.config.DemoConfig;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.util.ApplicationConfig;

public class RunDemo {
    private static Log log = LogFactory.getLog(RunDemo.class);
    protected static DefaultApplicationContext context;

    public static void main(String[] args) {
        log.info((Object)("JAXX Demo start at " + new Date() + " args: " + Arrays.toString(args)));
        try {
            I18n.setInitializer((I18nInitializer)new DefaultI18nInitializer("jaxx-tutorial-config-i18n"));
            DemoConfig config = new DemoConfig();
            I18n.init((Locale)config.getLocale());
            try {
                SwingUtil.initNimbusLoookAndFeel();
            }
            catch (Exception e) {
                log.warn((Object)I18n._((String)"jaxxdemo.warning.nimbus.landf"));
            }
            catch (Throwable e) {
                log.warn((Object)I18n._((String)"jaxxdemo.warning.no.ui"));
            }
            ConfigUIHelper helper = new ConfigUIHelper((ApplicationConfig)config);
            RunDemo.buildConfigUI(helper);
            JFrame parentUI = new JFrame();
            helper.displayUI((Frame)parentUI, false);
            parentUI.dispose();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void buildConfigUI(ConfigUIHelper helper) {
        Runnable reloadUICallback = new Runnable(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will say Hello world");
                }
                JOptionPane.showMessageDialog(null, "Hello World!");
            }
        };
        Runnable reloadApplicationCallback = new Runnable(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"will reload appplication");
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"will say Good Bye world");
                }
                JOptionPane.showMessageDialog(null, "Good Bye World!");
            }
        };
        helper.registerCallBack("ui", I18n.n_((String)"demo.action.reload.ui"), (Icon)SwingUtil.createActionIcon((String)"reload-ui"), reloadUICallback);
        helper.registerCallBack("application", I18n.n_((String)"demo.action.reload.application"), (Icon)SwingUtil.createActionIcon((String)"reload-application"), reloadApplicationCallback);
        helper.addCategory(I18n.n_((String)"jaxxdemo.config.category.directories"), I18n.n_((String)"jaxxdemo.config.category.directories.description"));
        helper.addOption((ApplicationConfig.OptionDef)DemoConfig.Option.CONFIG_FILE);
        helper.addCategory(I18n.n_((String)"jaxxdemo.config.category.other"), I18n.n_((String)"jaxxdemo.config.category.other.description"));
        helper.addOption((ApplicationConfig.OptionDef)DemoConfig.Option.FULL_SCREEN);
        helper.setOptionPropertyName("fullscreen");
        helper.setOptionCallBack("ui");
        helper.addOption((ApplicationConfig.OptionDef)DemoConfig.Option.FONT_SIZE);
        helper.setOptionPropertyName("fontSize");
        helper.setOptionCallBack("application");
        helper.addOption((ApplicationConfig.OptionDef)DemoConfig.Option.LOCALE);
        helper.setOptionPropertyName("locale");
        helper.setOptionCallBack("ui");
        helper.buildUI((JAXXContext)new JAXXInitialContext(), "jaxxdemo.config.category.other");
    }
}

