/*
 * #%L
 * JAXX :: Runtime
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jaxx.runtime.swing.editor;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import java.awt.Component;

/**
 * @author Sylvain Lletellier
 */
public class KeyStrokeCellEditor extends AbstractCellEditor
        implements TableCellEditor {

    protected final KeyStrokeEditor keyStrokeEditor;

    public KeyStrokeCellEditor() {
        keyStrokeEditor = new KeyStrokeEditor();
        keyStrokeEditor.addActionListener(e -> fireEditingStopped());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        keyStrokeEditor.setKeyStroke((KeyStroke) value);
        return keyStrokeEditor;
    }

    @Override
    public Object getCellEditorValue() {
        return keyStrokeEditor.getKeyStroke();
    }
}
