/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator;

import java.util.List;
import java.util.Map;
import jaxx.runtime.validator.SimpleBean;
import jaxx.runtime.validator.XWorkBeanValidator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XWorkBeanValidatorTest {
    protected XWorkBeanValidator<SimpleBean> validator;
    protected SimpleBean bean;
    protected Map<String, List<String>> messages;

    @Before
    public void setUp() {
        this.bean = new SimpleBean();
        this.validator = new XWorkBeanValidator(SimpleBean.class, "simple");
    }

    @After
    public void tearDown() {
        this.bean = null;
        this.messages = null;
    }

    @Test
    public void testUnknownField() {
        Assert.assertEquals((Object)false, (Object)this.validator.containsField("fake_" + System.nanoTime()));
    }

    @Test(expected=NullPointerException.class)
    public void testValidateNPE() {
        this.validator.validate(null);
    }

    @Test
    public void testValidate() {
        this.messages = this.validator.validate((Object)this.bean);
        this.assertFieldInError("stringValue", "stringValue.null", true, this.messages);
        this.assertFieldInError("intValue", "intValue.null", true, this.messages);
        this.bean.setStringValue("notnull");
        this.messages = this.validator.validate((Object)this.bean);
        this.assertFieldInError("stringValue", "stringValue.null", false, this.messages);
        this.assertFieldInError("intValue", "intValue.null", true, this.messages);
        this.bean.setIntValue(1);
        this.messages = this.validator.validate((Object)this.bean);
        this.assertFieldInError("stringValue", "stringValue.null", false, this.messages);
        this.assertFieldInError("intValue", "intValue.null", false, this.messages);
    }

    @Test
    public void testSetContextName() {
        String expected = "simple";
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("intValue"));
        expected = "error";
        this.validator.setContextName("error");
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("intValue"));
        expected = "warning";
        this.validator.setContextName("warning");
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)false, (Object)this.validator.containsField("intValue"));
        expected = "info";
        this.validator.setContextName("info");
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)false, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("intValue"));
        expected = "fake_" + System.nanoTime();
        this.validator.setContextName(expected);
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)false, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)false, (Object)this.validator.containsField("intValue"));
    }

    @Test
    public void testSetIncludeDefaultContext() {
        this.validator.setIncludeDefaultContext(false);
        String expected = "simple";
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("intValue"));
        expected = "error";
        this.validator.setContextName("error");
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("intValue"));
        expected = "warning";
        this.validator.setContextName("warning");
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)false, (Object)this.validator.containsField("intValue"));
        expected = "info";
        this.validator.setContextName("info");
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)false, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)true, (Object)this.validator.containsField("intValue"));
        expected = "fake_" + System.nanoTime();
        this.validator.setContextName(expected);
        Assert.assertEquals((Object)expected, (Object)this.validator.getContextName());
        Assert.assertEquals((Object)false, (Object)this.validator.containsField("stringValue"));
        Assert.assertEquals((Object)false, (Object)this.validator.containsField("intValue"));
    }

    protected void assertFieldInError(String fieldName, String error, boolean required, Map<String, List<String>> messages) {
        Assert.assertEquals((Object)true, (Object)this.validator.containsField(fieldName));
        List<String> fieldMessages = messages.get(fieldName);
        if (fieldMessages != null) {
            for (String o : fieldMessages) {
                if (!o.equals(error)) continue;
                Assert.assertTrue((boolean)required);
                return;
            }
        }
        Assert.assertFalse((boolean)required);
    }
}

