/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: CompilerConfiguration.java 2490 2012-08-11 07:57:06Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.30/jaxx-compiler/src/main/java/jaxx/compiler/CompilerConfiguration.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler;

import jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import jaxx.compiler.spi.Initializer;
import jaxx.runtime.JAXXContext;

import java.io.File;
import java.util.Map;

/**
 * Configuration of a compiler task.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.0
 */
public interface CompilerConfiguration {

    /** @return the class loader used by compilers */
    ClassLoader getClassLoader();

    /** @return the type of compiler to use */
    Class<? extends JAXXCompiler> getCompilerClass();

    /** @return the type of default decorator to use if none specified */
    Class<? extends CompiledObjectDecorator> getDefaultDecoratorClass();

    /** @return the type of the default error UI to use for validation */
    Class<?> getDefaultErrorUI();

    /** @return extra imports to add on all generated jaxx object */
    String[] getExtraImports();

    /**
     * @return the FQN of the help broker (can not directly a type since
     *         the help broker should (may?) be inside the sources.
     */
    String getHelpBrokerFQN();

    /**
     * @return the FQN of the validator factory used to instanciate new validators.
     * @since 2.6
     */
    String getValidatorFactoryFQN();


    /** @return the type of context to use in each generated jaxx object */
    Class<? extends JAXXContext> getJaxxContextClass();

    /**
     * Returns whether or not optimization should be performed.
     *
     * @return whether or not optimizations should be performed
     */
    boolean getOptimize();

    /**
     * Returns whether or not auto css should be used.
     *
     * @return {@code true} if a css file with same name as jaxx file should
     *         be included in jaxx file if found.
     * @since 2.0.2
     */
    boolean isAutoImportCss();

    /**
     * Returns whether or not should recurse in css for existing JAXX Object.
     * <p/>
     * <b>Note:</b> This functionnality was here at the beginning of the project
     * but offers nothing very usefull, will be remove probably in JAXX 3.0.
     *
     * @return {@code true} if a css file with same name as jaxx file should
     *         be included in jaxx file if found.
     * @since 2.0.2
     */
    boolean isAutoRecurseInCss();

    /**
     * Returns the target directory.
     *
     * @return the target directory
     */
    File getTargetDirectory();

    /** @return {@code true} if a logger must add on each generated jaxx object */
    boolean isAddLogger();

    /** @return {@code true} if we are generating help */
    boolean isGenerateHelp();

    /** @return {@code true} if we use the i18n system */
    boolean isI18nable();

    /** @return {@code true} to generate optimized code */
    boolean isOptimize();

    /** @return {@code true} if a profile pass must be done */
    boolean isProfile();

    /** @return {@code true} if states must be reset after the compilation */
    boolean isResetAfterCompile();

    /** @return {@code true} if UIManager is used to retrieve icons */
    boolean isUseUIManagerForIcon();

    /** @return {@code true} if compiler is verbose */
    boolean isVerbose();

    /**
     * @return {@code true} to trace the Class descriptor loading.
     * @since 2.4
     */
    boolean isShowClassDescriptorLoading();

    /** @return the encoding to use to write files */
    String getEncoding();

    Map<String, CompiledObjectDecorator> getDecorators();

    Map<String, JAXXCompilerFinalizer> getFinalizers();

    Map<String, Initializer> getInitializers();
}
