/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.awt.BorderLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.CompilerException;
import jaxx.compiler.DefaultCompilerConfiguration;
import jaxx.compiler.EventHandler;
import jaxx.compiler.IDHelper;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.SymbolTable;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.UnsupportedTagException;
import jaxx.compiler.binding.DataBindingHelper;
import jaxx.compiler.css.StylesheetHelper;
import jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import jaxx.compiler.java.JavaElementFactory;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.compiler.java.parser.ParseException;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.script.ScriptManager;
import jaxx.compiler.tags.DefaultObjectHandler;
import jaxx.compiler.tags.TagHandler;
import jaxx.compiler.tags.TagManager;
import jaxx.runtime.ComponentDescriptor;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.css.Rule;
import jaxx.runtime.css.Stylesheet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.extension.ImportsManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class JAXXCompiler {
    protected static final Log log = LogFactory.getLog(JAXXCompiler.class);
    public static boolean STRICT_CHECKS;
    public static final String JAXX_NAMESPACE = "http://www.jaxxframework.org/";
    public static final String JAXX_INTERNAL_NAMESPACE = "http://www.jaxxframework.org/internal";
    public static final int INLINE_THRESHOLD = 300;
    protected static String lineSeparator;
    public static final String BORDER_LAYOUT_PREFIX;
    protected final DefaultObjectHandler firstPassClassTagHandler;
    protected boolean failed;
    protected CompiledObject root;
    protected Set<String> importedPackages;
    protected Set<String> importedClasses;
    protected Stack<CompiledObject> openComponents;
    protected final IDHelper idHelper;
    protected final DataBindingHelper bindingHelper;
    protected SymbolTable symbolTable;
    protected File baseDir;
    protected File src;
    protected Document document;
    protected String outputClassName;
    protected ScriptManager scriptManager;
    protected Stylesheet stylesheet;
    protected List<Rule> inlineStyles;
    protected Map<String, Map<ClassDescriptor, List<EventHandler>>> eventHandlers;
    protected Map<EventHandler, String> eventHandlerMethodNames;
    protected ClassLoader classLoader;
    protected List<Runnable> initializers;
    private String[] extraInterfaces;
    private boolean abstractClass;
    private String genericType;
    private String superGenericType;
    protected StringBuilder initializer;
    protected StringBuilder lateInitializer;
    protected StringBuilder bodyCode;
    protected boolean mainDeclared;
    protected JavaFile javaFile;
    protected Stack<Element> tagsBeingCompiled;
    protected Stack<File> sourceFiles;
    protected Map<String, CompiledObject> objects;
    protected Map<CompiledObject, String> ids;
    protected CompiledObjectDecorator defaultDecorator;
    protected final JAXXEngine engine;
    protected final CompilerConfiguration defaultConfiguration = new DefaultCompilerConfiguration();
    protected final JAXXCompilerFile jaxxFile;
    protected boolean identCssFound;
    @Deprecated
    protected boolean needSwingUtil;
    public static final String[] EMPTY_STRING_ARRAY;

    public JAXXCompiler() {
        this(null, null, null);
    }

    public JAXXCompiler(JAXXEngine engine, JAXXCompilerFile jaxxFile, List<String> defaultImports) {
        this.engine = engine;
        this.jaxxFile = jaxxFile;
        this.ids = new LinkedHashMap<CompiledObject, String>();
        this.objects = new LinkedHashMap<String, CompiledObject>();
        this.bodyCode = new StringBuilder();
        this.lateInitializer = new StringBuilder();
        this.initializer = new StringBuilder();
        this.tagsBeingCompiled = new Stack();
        this.initializers = new ArrayList<Runnable>();
        this.eventHandlerMethodNames = new HashMap<EventHandler, String>();
        this.eventHandlers = new HashMap<String, Map<ClassDescriptor, List<EventHandler>>>();
        this.inlineStyles = new ArrayList<Rule>();
        this.scriptManager = new ScriptManager(this);
        this.symbolTable = new SymbolTable();
        this.openComponents = new Stack();
        this.importedPackages = new HashSet<String>();
        this.importedClasses = new HashSet<String>();
        this.sourceFiles = new Stack();
        if (jaxxFile == null) {
            this.src = null;
            this.baseDir = null;
            this.outputClassName = null;
        } else {
            this.src = jaxxFile.getJaxxFile();
            this.baseDir = this.src.getParentFile();
            this.outputClassName = jaxxFile.getClassName();
            this.sourceFiles.push(this.src);
            this.addImport(this.outputClassName.substring(0, this.outputClassName.lastIndexOf(".") + 1) + "*");
        }
        this.firstPassClassTagHandler = new DefaultObjectHandler(ClassDescriptorHelper.getClassDescriptor(Object.class));
        this.bindingHelper = new DataBindingHelper(this);
        if (defaultImports != null) {
            for (String defaultImport : defaultImports) {
                this.addDefaultImport(defaultImport);
            }
        }
        if (engine != null) {
            CompilerConfiguration configuration = engine.getConfiguration();
            if (configuration.getExtraImports() != null) {
                for (String extraImport : configuration.getExtraImports()) {
                    this.addImport(extraImport);
                }
            }
            this.defaultDecorator = engine.getDecorator(configuration.getDefaultDecoratorClass());
            if (this.defaultDecorator == null) {
                throw new IllegalArgumentException("could not find default decorator : " + configuration.getDefaultDecoratorClass());
            }
            this.idHelper = new IDHelper(configuration.isOptimize());
        } else {
            this.idHelper = new IDHelper(false);
        }
    }

    public void runInitializers() {
        for (Runnable runnable : this.initializers) {
            if (log.isDebugEnabled()) {
                log.debug((Object)runnable);
            }
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.reportError(e.getMessage());
                return;
            }
        }
        this.initializers.clear();
    }

    public void registerInitializer(Runnable r) {
        this.initializers.add(r);
    }

    public void compileFirstPass(final Element tag) throws IOException {
        TagHandler handler;
        String fullClassName;
        boolean namespacePrefix;
        this.tagsBeingCompiled.push(tag);
        String namespace = tag.getNamespaceURI();
        String localName = tag.getLocalName();
        boolean bl = namespacePrefix = tag.getPrefix() != null;
        if (namespace != null && namespace.endsWith("*")) {
            String packageName = namespace.substring(0, namespace.length() - 1);
            if (localName.startsWith(packageName)) {
                fullClassName = TagManager.resolveClassName(localName, this);
            } else {
                fullClassName = TagManager.resolveClassName(packageName + localName, this);
                if (fullClassName == null && !namespacePrefix) {
                    fullClassName = TagManager.resolveClassName(localName, this);
                }
            }
        } else {
            fullClassName = TagManager.resolveClassName(localName, this);
        }
        if (fullClassName != null) {
            String interfacesStr;
            String id;
            this.addDependencyClass(fullClassName);
            namespace = fullClassName.substring(0, fullClassName.lastIndexOf(".") + 1) + "*";
            if (this.symbolTable.getSuperclassName() == null) {
                this.symbolTable.setSuperclassName(fullClassName);
            }
            if (!(id = tag.getAttribute("id")).isEmpty()) {
                MethodDescriptor methodDescriptor;
                String capitalizeName;
                this.symbolTable.getClassTagIds().put(id, fullClassName);
                if (tag.getAttributeNode("javaBean") != null) {
                    capitalizeName = StringUtils.capitalize((String)id);
                    methodDescriptor = new MethodDescriptor("get" + capitalizeName, 1, fullClassName, EMPTY_STRING_ARRAY, this.classLoader);
                    this.symbolTable.getScriptMethods().add(methodDescriptor);
                    if (Boolean.class.getName().equals(fullClassName)) {
                        methodDescriptor = new MethodDescriptor("is" + capitalizeName, 1, fullClassName, EMPTY_STRING_ARRAY, this.classLoader);
                        this.symbolTable.getScriptMethods().add(methodDescriptor);
                    }
                    methodDescriptor = new MethodDescriptor("set" + capitalizeName, 1, "void", new String[]{fullClassName}, this.classLoader);
                    this.symbolTable.getScriptMethods().add(methodDescriptor);
                } else {
                    capitalizeName = StringUtils.capitalize((String)id);
                    methodDescriptor = new MethodDescriptor("get" + capitalizeName, 1, fullClassName, EMPTY_STRING_ARRAY, this.classLoader);
                    this.symbolTable.getScriptMethods().add(methodDescriptor);
                }
            }
            if (!(interfacesStr = tag.getAttribute("implements")).isEmpty()) {
                try {
                    Object[] interfaces = JavaGeneratorUtil.splitFqnList((String)interfacesStr, (char)',');
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("detect interfaces : " + Arrays.toString(interfaces)));
                    }
                    this.symbolTable.setInterfaces((String[])interfaces);
                }
                catch (Exception e) {
                    throw new CompilerException("Syntax error of interfaces " + interfacesStr);
                }
            }
        }
        TagHandler tagHandler = handler = namespace != null && namespace.endsWith("*") ? this.firstPassClassTagHandler : TagManager.getTagHandler(tag.getNamespaceURI(), localName, namespacePrefix, this);
        if (!this.firstPassClassTagHandler.equals(handler) && handler instanceof DefaultObjectHandler) {
            fullClassName = ((DefaultObjectHandler)handler).getBeanClass().getName();
            handler = this.firstPassClassTagHandler;
        }
        if (this.firstPassClassTagHandler.equals(handler)) {
            final String finalClassName = fullClassName;
            this.registerInitializer(new Runnable(){

                @Override
                public void run() {
                    DefaultObjectHandler handler = (DefaultObjectHandler)TagManager.getTagHandler(null, finalClassName, JAXXCompiler.this);
                    if (handler == null) {
                        throw new CompilerException("Internal error: missing TagHandler for '" + finalClassName + "'");
                    }
                    handler.registerCompiledObject(tag, JAXXCompiler.this);
                }
            });
        }
        if (handler == null) {
            this.reportError("Could not find a Java class corresponding to: <" + tag.getTagName() + ">");
            this.failed = true;
        } else {
            try {
                handler.compileFirstPass(tag, this);
            }
            catch (CompilerException e) {
                this.reportError(e);
            }
        }
        Element finished = this.tagsBeingCompiled.pop();
        if (finished != tag) {
            throw new IllegalStateException("internal error: just finished compiling " + tag + ", but top of tagsBeingCompiled stack is " + finished);
        }
    }

    public void compileSecondPass(Element tag) throws IOException {
        this.tagsBeingCompiled.push(tag);
        TagHandler handler = TagManager.getTagHandler(tag.getNamespaceURI(), tag.getLocalName(), tag.getPrefix() != null, this);
        if (handler == null) {
            this.reportError("Could not find a Java class corresponding to: <" + tag.getTagName() + ">");
            this.failed = true;
        } else {
            handler.compileSecondPass(tag, this);
        }
        Element finished = this.tagsBeingCompiled.pop();
        if (!tag.equals(finished)) {
            throw new RuntimeException("internal error: just finished compiling " + tag + ", but top of tagsBeingCompiled stack is " + finished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileFirstPass() throws IOException {
        FileInputStream in = new FileInputStream(this.src);
        try {
            this.document = JAXXCompiler.parseDocument(in);
            this.compileFirstPass(this.document.getDocumentElement());
        }
        catch (SAXParseException e) {
            this.reportError(e.getLineNumber(), "Invalid XML: " + e.getMessage());
        }
        catch (SAXException e) {
            this.reportError(null, "Error parsing XML document: " + e);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public void compileSecondPass() throws IOException {
        if (!this.tagsBeingCompiled.isEmpty()) {
            throw new RuntimeException("Internal error: starting pass two, but tagsBeingCompiled is not empty: " + this.tagsBeingCompiled);
        }
        this.compileSecondPass(this.document.getDocumentElement());
    }

    public void openComponent(CompiledObject component) throws CompilerException {
        this.openComponent(component, null);
    }

    public void openComponent(CompiledObject component, String constraints) throws CompilerException {
        if (constraints != null && constraints.startsWith(BORDER_LAYOUT_PREFIX)) {
            this.addImport(BorderLayout.class.getName());
        }
        CompiledObject parent = this.getOpenComponent();
        this.openInvisibleComponent(component);
        if (parent != null && !component.isOverride()) {
            parent.addChild(component, constraints, this);
        }
    }

    public void openInvisibleComponent(CompiledObject component) {
        if (!this.ids.containsKey(component)) {
            this.registerCompiledObject(component);
        }
        this.openComponents.push(component);
    }

    public CompiledObject getOpenComponent() {
        if (this.openComponents.isEmpty()) {
            return null;
        }
        return this.openComponents.peek();
    }

    public void closeComponent(CompiledObject component) {
        if (component == null) {
            throw new NullPointerException("can not close a null component");
        }
        if (!component.equals(this.openComponents.pop())) {
            throw new IllegalArgumentException("can only close the topmost open object");
        }
    }

    public void registerCompiledObject(CompiledObject object) {
        if (this.root == null) {
            this.root = object;
        }
        String id = object.getId();
        if (this.ids.containsKey(object)) {
            this.reportError("object '" + object + "' is already registered with id '" + this.ids.get(object) + "', cannot re-register as '" + id + "'");
        }
        if (this.objects.containsKey(id) && !(this.objects.get(id) instanceof Element)) {
            this.reportError("id '" + id + "' is already registered to component " + this.objects.get(id));
        }
        this.objects.put(id, object);
        this.ids.put(object, id);
        if (object.getDecorator() == null) {
            object.setDecorator(this.defaultDecorator);
        }
    }

    public CompiledObject getCompiledObject(String id) {
        this.runInitializers();
        return this.objects.get(id);
    }

    public boolean inlineCreation(CompiledObject object) {
        return object.getId().startsWith("$") && object.getInitializationCode(this).length() < 300;
    }

    public void checkOverride(CompiledObject object) throws CompilerException {
        ClassDescriptor ancestor;
        String fieldName = object.getId();
        if (fieldName.startsWith("$")) {
            return;
        }
        if (object.getObjectClass().equals(ancestor)) {
            return;
        }
        for (ancestor = this.root.getObjectClass(); ancestor != null; ancestor = ancestor.getSuperclass()) {
            try {
                FieldDescriptor f = ancestor.getDeclaredFieldDescriptor(fieldName);
                if (!f.getType().isAssignableFrom(object.getObjectClass())) {
                    this.reportError("attempting to redefine superclass member '" + fieldName + "' as incompatible type  (was " + f.getType() + ", redefined as " + object.getObjectClass() + ")");
                }
                object.setOverride(true);
                object.setOverrideType(f.getType());
                if (JAXXCompiler.getCanonicalName(f.getType()).equals(JAXXCompiler.getCanonicalName(object))) break;
                String simpleType = this.getImportedType(JAXXCompiler.getCanonicalName(object));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Simple type for " + object.getId() + " : " + JAXXCompiler.getCanonicalName(object) + " against : " + JAXXCompiler.getCanonicalName(f.getType())));
                }
                object.setSimpleType(simpleType);
                break;
            }
            catch (NoSuchFieldException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(">>>>> could not find declared field [" + fieldName + "] in " + ancestor.getName()));
                continue;
            }
        }
    }

    public DataBindingHelper getBindingHelper() {
        return this.bindingHelper;
    }

    public void registerEventHandler(EventHandler handler) {
        ClassDescriptor listenerClass;
        List<EventHandler> handlerList;
        String objectCode = handler.getObjectCode();
        Map<ClassDescriptor, List<EventHandler>> listeners = this.eventHandlers.get(objectCode);
        if (listeners == null) {
            listeners = new HashMap<ClassDescriptor, List<EventHandler>>();
            this.eventHandlers.put(objectCode, listeners);
        }
        if ((handlerList = listeners.get(listenerClass = handler.getListenerClass())) == null) {
            handlerList = new ArrayList<EventHandler>();
            listeners.put(listenerClass, handlerList);
        }
        handlerList.add(handler);
    }

    public String getEventHandlerMethodName(EventHandler handler) {
        String result = this.eventHandlerMethodNames.get(handler);
        if (result == null) {
            if (this.getConfiguration().isOptimize()) {
                result = "$ev" + this.eventHandlerMethodNames.size();
            } else {
                String id = handler.getEventId().substring(0, handler.getEventId().indexOf("."));
                result = "do" + StringUtils.capitalize((String)handler.getListenerMethod().getName()) + "__on__" + id;
                if (this.eventHandlerMethodNames.containsValue(result)) {
                    String result2;
                    int index = 0;
                    while (this.eventHandlerMethodNames.containsValue(result2 = result + "_" + index++)) {
                    }
                    result = result2;
                }
            }
            this.eventHandlerMethodNames.put(handler, result);
        }
        return result;
    }

    public void addScriptField(FieldDescriptor field) {
        this.symbolTable.getScriptFields().add(field);
    }

    public void addScriptMethod(MethodDescriptor method) {
        if (method.getName().equals("main") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].getName().equals("[Ljava.lang.String;")) {
            this.setMainDeclared(true);
        }
        this.symbolTable.getScriptMethods().add(method);
    }

    public void registerScript(String script) throws CompilerException {
        this.registerScript(script, null);
    }

    public void registerScript(String script, File sourceFile) throws CompilerException {
        File pop;
        if (sourceFile != null) {
            this.sourceFiles.push(sourceFile);
        }
        if (!("".equals(script = script.trim()) || script.endsWith("}") || script.endsWith(";"))) {
            script = script + ";";
        }
        this.scriptManager.registerScript(script);
        if (sourceFile != null && !sourceFile.equals(pop = this.sourceFiles.pop())) {
            throw new RuntimeException("leaving registerScript(), but " + sourceFile + " was not the top entry on the stack (found " + pop + " instead)");
        }
    }

    public String preprocessScript(String script) throws CompilerException {
        return this.scriptManager.preprocessScript(script);
    }

    public boolean isIdentCssFound() {
        return this.identCssFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStyleSheetFile(File styleFile) throws IOException {
        File identCssFile;
        if (!this.identCssFound && this.getConfiguration().isAutoImportCss() && (identCssFile = this.jaxxFile.getCssFile()).exists()) {
            this.identCssFound = true;
            this.reportWarning("autoImportCss mode is on, you can remove style declaration with source " + styleFile);
        }
        String content = this.loadFile(styleFile);
        this.getSourceFiles().push(styleFile);
        try {
            Stylesheet stylesheet = StylesheetHelper.processStylesheet(content);
            this.registerStylesheet(stylesheet);
        }
        finally {
            this.getSourceFiles().pop();
        }
    }

    public void applyStylesheets() {
        Iterator<CompiledObject> i$ = new ArrayList<CompiledObject>(this.objects.values()).iterator();
        while (i$.hasNext()) {
            CompiledObject o;
            CompiledObject object = o = i$.next();
            DefaultObjectHandler tagHandler = TagManager.getTagHandler(object.getObjectClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("will apply css on object " + object.getId() + " from handler " + tagHandler));
            }
            tagHandler.applyStylesheets(object, this);
        }
    }

    public void registerStylesheet(Stylesheet stylesheet) {
        if (this.stylesheet == null) {
            this.stylesheet = stylesheet;
        } else {
            this.stylesheet.add(stylesheet.getRules());
        }
    }

    public void addInlineStyle(CompiledObject object, String propertyName, boolean dataBinding) {
        Rule style = StylesheetHelper.inlineAttribute(object, propertyName, dataBinding);
        this.inlineStyles.add(style);
    }

    public void reportWarning(String warning) {
        Element currentTag = null;
        if (!this.tagsBeingCompiled.isEmpty()) {
            currentTag = this.tagsBeingCompiled.peek();
        }
        this.reportWarning(currentTag, warning, 0);
    }

    public void reportWarning(Element tag, String warning, int lineOffset) {
        String lineAttr;
        String lineNumber = null;
        if (tag != null && (lineAttr = tag.getAttributeNS(JAXX_INTERNAL_NAMESPACE, "line")).length() > 0) {
            lineNumber = lineAttr;
        }
        File srcFile = this.sourceFiles.peek();
        try {
            srcFile = srcFile.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(srcFile);
        if (lineNumber != null) {
            buffer.append(":");
            buffer.append(this.sourceFiles.size() == 1 ? Integer.parseInt(lineNumber) + lineOffset : lineOffset + 1);
        }
        buffer.append(JAXXCompiler.getLineSeparator()).append(warning.trim());
        if (this.engine != null) {
            this.engine.addWarning(buffer.toString());
        } else {
            System.err.println(buffer.toString());
        }
    }

    public void reportError(String error) {
        Element currentTag = null;
        if (!this.tagsBeingCompiled.isEmpty()) {
            currentTag = this.tagsBeingCompiled.peek();
        }
        this.reportError(currentTag, error);
    }

    public void reportError(CompilerException ex) {
        this.reportError(null, ex);
    }

    public void reportError(String extraMessage, CompilerException ex) {
        String message = ex.getMessage();
        if (UnsupportedAttributeException.class.equals(ex.getClass()) || UnsupportedTagException.class.equals(ex.getClass())) {
            String exceptionName = ex.getClass().getName();
            message = exceptionName.substring(exceptionName.lastIndexOf(".") + 1) + ": " + message;
        }
        int lineOffset = ex instanceof ParseException ? Math.max(0, ((ParseException)ex).getLine() - 1) : 0;
        Element currentTag = null;
        if (!this.tagsBeingCompiled.isEmpty()) {
            currentTag = this.tagsBeingCompiled.peek();
        }
        this.reportError(currentTag, extraMessage != null ? extraMessage + message : message, lineOffset);
    }

    public void reportError(Element tag, String error) {
        this.reportError(tag, error, 0);
    }

    public void reportError(Element tag, String error, int lineOffset) {
        String lineAttr;
        int lineNumber = 0;
        if (tag != null && (lineAttr = tag.getAttributeNS(JAXX_INTERNAL_NAMESPACE, "line")).length() > 0) {
            lineNumber = Integer.parseInt(lineAttr);
        }
        lineNumber = Math.max(lineNumber, 1) + lineOffset;
        this.reportError(lineNumber, error);
    }

    public void reportError(int lineNumber, String error) {
        File errorFile = this.sourceFiles.isEmpty() ? null : this.sourceFiles.peek();
        try {
            if (errorFile != null) {
                errorFile = errorFile.getCanonicalFile();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(errorFile != null ? errorFile.getPath() : "<unknown source>");
        if (lineNumber > 0) {
            buffer.append(":").append(lineNumber);
        }
        buffer.append(JAXXCompiler.getLineSeparator()).append(": ").append(error);
        if (this.engine != null) {
            this.engine.addError(buffer.toString());
        } else {
            System.err.println(buffer.toString());
        }
        this.failed = true;
    }

    public Map<String, CompiledObject> getObjects() {
        return this.objects;
    }

    public Map<String, Map<ClassDescriptor, List<EventHandler>>> getEventHandlers() {
        return this.eventHandlers;
    }

    public CompilerConfiguration getConfiguration() {
        JAXXEngine engine = this.getEngine();
        if (engine == null) {
            return this.defaultConfiguration;
        }
        return engine.getConfiguration();
    }

    public String getOutputClassName() {
        return this.outputClassName;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Set<String> getImportedClasses() {
        return this.importedClasses;
    }

    public Set<String> getImportedPackages() {
        return this.importedPackages;
    }

    public Iterator<CompiledObject> getObjectCreationOrder() {
        return this.objects.values().iterator();
    }

    public CompiledObject getRootObject() {
        return this.root;
    }

    public Stack<File> getSourceFiles() {
        return this.sourceFiles;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public Stylesheet getStylesheet() {
        Stylesheet merged = new Stylesheet();
        if (this.stylesheet != null) {
            merged.add(this.stylesheet.getRules());
        }
        merged.add(this.inlineStyles.toArray(new Rule[this.inlineStyles.size()]));
        return merged;
    }

    public FieldDescriptor[] getScriptFields() {
        List<FieldDescriptor> scriptFields = this.symbolTable.getScriptFields();
        return scriptFields.toArray(new FieldDescriptor[scriptFields.size()]);
    }

    public FieldDescriptor getScriptField(String fieldName) {
        for (FieldDescriptor f : this.symbolTable.getScriptFields()) {
            if (!fieldName.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    public MethodDescriptor[] getScriptMethods() {
        List<MethodDescriptor> scriptMethods = this.symbolTable.getScriptMethods();
        return scriptMethods.toArray(new MethodDescriptor[scriptMethods.size()]);
    }

    public MethodDescriptor getScriptMethod(String methodName) {
        for (MethodDescriptor m : this.symbolTable.getScriptMethods()) {
            if (!methodName.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public IDHelper getIdHelper() {
        return this.idHelper;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            CompilerConfiguration configuration = this.getConfiguration();
            if (configuration.getClassLoader() != null) {
                this.classLoader = configuration.getClassLoader();
            } else {
                throw new NullPointerException("compiler configuration requires a classLoader! :\n" + configuration);
            }
        }
        return this.classLoader;
    }

    public boolean isSuperClassAware(Class<?> type) throws ClassNotFoundException {
        ClassDescriptor superClass = this.root.getObjectClass();
        if (superClass == null) {
            return false;
        }
        boolean aware = ClassDescriptorHelper.isAssignableFrom(superClass, type);
        return aware;
    }

    public JAXXObjectDescriptor getJAXXObjectDescriptor() {
        this.runInitializers();
        CompiledObject[] components = new ArrayList<CompiledObject>(this.objects.values()).toArray(new CompiledObject[this.objects.size()]);
        assert (this.initializers.isEmpty()) : "there are pending initializers remaining";
        assert (this.root != null) : "root object has not been defined";
        assert (Arrays.asList(components).contains(this.root)) : "root object is not registered";
        ComponentDescriptor[] descriptors = new ComponentDescriptor[components.length];
        for (int i = 0; i < components.length; ++i) {
            int j;
            CompiledObject parent = components[i].getParent();
            while (parent != null) {
                boolean found = false;
                for (j = i + 1; j < components.length; ++j) {
                    if (components[j] != parent) continue;
                    components[j] = components[i];
                    components[i] = parent;
                    found = true;
                    break;
                }
                if (!found) break;
                parent = components[i].getParent();
            }
            int parentIndex = -1;
            if (parent != null) {
                for (j = 0; j < i; ++j) {
                    if (!components[j].equals(parent)) continue;
                    parentIndex = j;
                    break;
                }
            }
            descriptors[i] = new ComponentDescriptor(components[i].getId(), components[i] == this.root ? this.outputClassName : components[i].getObjectClass().getName(), components[i].getStyleClass(), parentIndex != -1 ? descriptors[parentIndex] : null);
        }
        Stylesheet css = this.getStylesheet();
        if (css == null) {
            css = new Stylesheet();
        }
        return new JAXXObjectDescriptor(descriptors, css);
    }

    public StringBuilder getInitializer() {
        return this.initializer;
    }

    public StringBuilder getLateInitializer() {
        return this.lateInitializer;
    }

    public StringBuilder getBodyCode() {
        return this.bodyCode;
    }

    public boolean isMainDeclared() {
        return this.mainDeclared;
    }

    public void setMainDeclared(boolean mainDeclared) {
        this.mainDeclared = mainDeclared;
    }

    public void appendInitializerCode(String code) {
        this.initializer.append(code);
    }

    public void appendBodyCode(String code) {
        this.bodyCode.append(code);
    }

    public void appendLateInitializer(String code) {
        this.lateInitializer.append(code);
    }

    public boolean hasMethod(String methodName) {
        for (JavaMethod method : this.getJavaFile().getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    public void addImport(Class<?> clazz) {
        this.addImport(clazz.getName());
    }

    public void addImport(String text) {
        if (text.endsWith("*")) {
            this.importedPackages.add(text.substring(0, text.length() - 1));
        } else {
            this.importedClasses.add(text);
        }
        if (!text.equals("*")) {
            this.getJavaFile().addImport(text);
        }
    }

    protected void addDefaultImport(String text) {
        if (text.endsWith("*")) {
            this.importedPackages.add(text.substring(0, text.length() - 1));
        } else {
            this.importedClasses.add(text);
        }
    }

    public void addDependencyClass(String className) {
        if (this.engine.containsJaxxFileClassName(className)) {
            return;
        }
        URL jaxxURL = ClassDescriptorHelper.getURL(this.getClassLoader(), className, "jaxx");
        if (jaxxURL == null) {
            return;
        }
        if (!this.engine.isCompileFirstPassTask()) {
            throw new IllegalStateException("Internal error: adding dependency class " + className + " during second compilation pass");
        }
        if (jaxxURL.toString().startsWith("file:")) {
            File jaxxFile = JAXXCompiler.URLtoFile(jaxxURL);
            try {
                jaxxFile = jaxxFile.getCanonicalFile();
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
            String jaxxFileName = className.substring(className.lastIndexOf(".") + 1) + ".jaxx";
            assert (jaxxFile.getName().equalsIgnoreCase(jaxxFileName)) : "expecting file name to match " + className + ", but found " + jaxxFile.getName();
            if (jaxxFile.getName().equals(jaxxFileName)) {
                this.engine.addFileToCompile(jaxxFile, className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadFile(File file) {
        String string;
        if (!file.exists()) {
            this.reportError("Could not found file " + file);
            return "";
        }
        FileReader in = new FileReader(file);
        try {
            int c;
            StringWriter styleBuffer = new StringWriter();
            char[] readBuffer = new char[2048];
            while ((c = in.read(readBuffer)) > 0) {
                styleBuffer.write(readBuffer, 0, c);
            }
            string = styleBuffer.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                this.reportError("Could not read file " + file + " for reason " + e.getMessage());
                return "";
            }
        }
        in.close();
        return string;
    }

    public String checkJavaCode(String javaCode) {
        javaCode = this.scriptManager.trimScript(javaCode);
        this.scriptManager.checkParse(javaCode);
        return javaCode;
    }

    public boolean checkReference(Element tag, String reference, boolean strict, String attribute) {
        String component = this.getSymbolTable().getClassTagIds().get(reference);
        if (component == null) {
            if (strict) {
                String msg = attribute != null ? "tag '" + tag.getLocalName() + "' could not find the reference '" + reference + "' on attribute [" + attribute + "]" : "tag '" + tag.getLocalName() + "' could not find the reference '" + reference + "'";
                this.reportError(msg);
            }
            return false;
        }
        return true;
    }

    public String getAutoId(String name) {
        return this.idHelper.nextId(name);
    }

    public String getUniqueId(Object object) {
        return this.idHelper.getUniqueId(object);
    }

    public void setExtraInterfaces(String[] extraInterfaces) {
        this.extraInterfaces = extraInterfaces;
    }

    public String[] getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public void setAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    public String getGenericType() {
        return this.genericType;
    }

    public void setGenericType(String genericType) {
        this.genericType = genericType;
    }

    public String getSuperGenericType() {
        return this.superGenericType;
    }

    public void setSuperGenericType(String superGenericType) {
        this.superGenericType = superGenericType;
    }

    public void addSimpleField(JavaField javaField) {
        this.getJavaFile().addSimpleField(javaField);
    }

    public JavaFile getJavaFile() {
        if (this.javaFile == null) {
            String outputClassName = this.getOutputClassName();
            if (outputClassName == null) {
                this.javaFile = JavaElementFactory.newFile(0, "");
            } else {
                int dotPos = outputClassName.lastIndexOf(".");
                String packageName = dotPos != -1 ? outputClassName.substring(0, dotPos) : null;
                String simpleClassName = outputClassName.substring(dotPos + 1);
                this.javaFile = JavaElementFactory.newFile(1, packageName + "." + simpleClassName);
            }
        }
        return this.javaFile;
    }

    public void preFinalizeCompiler() throws Exception {
    }

    public void finalizeCompiler() throws Exception {
        int dotPos = this.getOutputClassName().lastIndexOf(".");
        String packageName = dotPos != -1 ? this.getOutputClassName().substring(0, dotPos) : null;
        String simpleClassName = this.getOutputClassName().substring(dotPos + 1);
        CompiledObject compiledObject = this.getRootObject();
        String genericType = this.getGenericType();
        if (StringUtils.isNotEmpty((CharSequence)genericType)) {
            String[] allTypes;
            StringBuilder sb = new StringBuilder();
            for (String type : allTypes = JavaGeneratorUtil.splitFqnList((String)genericType, (char)',')) {
                int anExtends = type.indexOf("extends");
                if (anExtends > -1) {
                    type = type.substring(0, anExtends - 1).trim();
                }
                sb.append(", ").append(type);
            }
            String finalType = allTypes.length > 0 ? sb.substring(2) : sb.toString();
            compiledObject.setGenericTypes(finalType);
        }
        for (CompiledObject object : this.getObjects().values()) {
            CompiledObjectDecorator decorator = object.getDecorator();
            decorator.finalizeCompiler(this, this.root, object, this.javaFile, packageName, simpleClassName, this.getOutputClassName());
        }
        ArrayList<JAXXCompilerFinalizer> realFinalizers = new ArrayList<JAXXCompilerFinalizer>();
        for (JAXXCompilerFinalizer finalizer : this.getConfiguration().getFinalizers().values()) {
            if (!finalizer.accept(this)) continue;
            realFinalizers.add(finalizer);
        }
        for (JAXXCompilerFinalizer finalizer : realFinalizers) {
            if (!finalizer.accept(this)) continue;
            finalizer.finalizeCompiler(compiledObject, this, this.javaFile, packageName, simpleClassName);
        }
        for (CompiledObject object : this.getObjects().values()) {
            object.finalizeCompiler(this);
        }
        this.getBindingHelper().finalizeBindings();
        for (JAXXCompilerFinalizer finalizer : realFinalizers) {
            finalizer.prepareJavaFile(compiledObject, this, this.javaFile, packageName, simpleClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(JavaFileGenerator generator) throws IOException {
        String fqn = this.getOutputClassName();
        File dest = this.getConfiguration().getTargetDirectory() != null ? new File(this.getConfiguration().getTargetDirectory(), fqn.replace('.', File.separatorChar) + ".java") : new File(this.getBaseDir(), fqn.substring(fqn.lastIndexOf(".") + 1) + ".java");
        File parentFile = dest.getParentFile();
        if (parentFile == null) {
            throw new IOException("No parent file for " + dest);
        }
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Could not create directory " + parentFile);
        }
        if (dest.exists() && !dest.setLastModified(System.currentTimeMillis())) {
            log.warn((Object)("could not touch file " + dest));
        }
        PrintWriter out = new PrintWriter(new FileWriter(dest));
        try {
            generator.generateFile(this.javaFile, out);
        }
        finally {
            out.close();
        }
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getCanonicalName(Class<?> clazz) {
        if (clazz.isArray()) {
            String canonicalName = JAXXCompiler.getCanonicalName(clazz.getComponentType());
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        return clazz.getName().replace('$', '.');
    }

    public static String getCanonicalName(ClassDescriptor clazz) {
        if (clazz.isArray()) {
            String canonicalName = JAXXCompiler.getCanonicalName(clazz.getComponentType());
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        return clazz.getName().replace('$', '.');
    }

    public static String getCanonicalName(CompiledObject compiled) {
        ClassDescriptor clazz = compiled.getObjectClass();
        if (clazz.isArray()) {
            String canonicalName = JAXXCompiler.getCanonicalName(clazz.getComponentType());
            if (canonicalName != null) {
                if (compiled.getGenericTypesLength() > 0) {
                    canonicalName = canonicalName + compiled.getGenericTypes();
                }
                return canonicalName + "[]";
            }
            return null;
        }
        String canonicalName = clazz.getName().replace('$', '.');
        if (compiled.getGenericTypesLength() > 0) {
            canonicalName = canonicalName + compiled.getGenericTypes();
        }
        return canonicalName;
    }

    public static String escapeJavaString(String raw) {
        StringBuilder out = new StringBuilder(raw);
        for (int i = 0; i < out.length(); ++i) {
            char c = out.charAt(i);
            if (c == '\\' || c == '\"') {
                out.insert(i, '\\');
                ++i;
                continue;
            }
            if (c == '\n') {
                out.replace(i, i + 1, "\\n");
                ++i;
                continue;
            }
            if (c == '\r') {
                out.replace(i, i + 1, "\\r");
                ++i;
                continue;
            }
            if (c >= ' ' && c <= '\u007f') continue;
            String value = Integer.toString(c, 16);
            while (value.length() < 4) {
                value = "0" + value;
            }
            out.replace(i, i + 1, "\\u" + value);
            i += 5;
        }
        return out.toString();
    }

    public static File URLtoFile(URL url) {
        return JAXXCompiler.URLtoFile(url.toString());
    }

    public static File URLtoFile(String urlString) {
        if (!urlString.startsWith("file:")) {
            throw new IllegalArgumentException("url must start with 'file:'");
        }
        if ((urlString = urlString.substring("file:".length())).startsWith("/") && System.getProperty("os.name").startsWith("Windows")) {
            urlString = urlString.substring(1);
        }
        try {
            return new File(URLDecoder.decode(urlString.replace('/', File.separatorChar), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static SAXParser getSAXParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            return parser;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parseDocument(InputStream in) throws IOException, SAXException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException ex) throws TransformerException {
                    throw ex;
                }

                @Override
                public void error(TransformerException ex) throws TransformerException {
                    throw ex;
                }

                @Override
                public void fatalError(TransformerException ex) throws TransformerException {
                    throw ex;
                }
            });
            DOMResult result = new DOMResult();
            transformer.transform(new SAXSource(new XMLFilterImpl(JAXXCompiler.getSAXParser().getXMLReader()){
                Locator locator;

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    AttributesImpl resultAtts = new AttributesImpl(atts);
                    resultAtts.addAttribute(JAXXCompiler.JAXX_INTERNAL_NAMESPACE, "line", "internal:line", "CDATA", String.valueOf(this.locator.getLineNumber()));
                    this.getContentHandler().startElement(uri, localName, qName, resultAtts);
                }
            }, new InputSource(in)), result);
            return (Document)result.getNode();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            Throwable ex = e;
            while (((Throwable)ex).getCause() != null) {
                ex = ((Throwable)ex).getCause();
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof SAXException) {
                throw (SAXException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public JAXXEngine getEngine() {
        return this.engine;
    }

    public void clear() {
        this.idHelper.clear();
        this.bindingHelper.clear();
        this.objects.clear();
        this.ids.clear();
        if (this.symbolTable != null) {
            this.symbolTable.clear();
        }
    }

    public void setIdentCssFound(boolean identCssFound) {
        this.identCssFound = identCssFound;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getImportedType(Class<?> type) {
        return this.getJavaFile().getImportedType(type);
    }

    public String getImportedType(String type) {
        return this.getJavaFile().getImportedType(type);
    }

    @Deprecated
    public ImportsManager getImportManager() {
        return this.getJavaFile().getImportManager();
    }

    @Deprecated
    public boolean isNeedSwingUtil() {
        return this.needSwingUtil;
    }

    @Deprecated
    public void setNeedSwingUtil(boolean needSwingUtil) {
        this.needSwingUtil = needSwingUtil;
    }

    public boolean containsScriptField(String fieldName) {
        FieldDescriptor[] scriptFields;
        for (FieldDescriptor f : scriptFields = this.getScriptFields()) {
            if (!fieldName.equals(f.getName())) continue;
            return true;
        }
        return false;
    }

    static {
        lineSeparator = System.getProperty("line.separator", "\n");
        BORDER_LAYOUT_PREFIX = BorderLayout.class.getSimpleName() + ".";
        EMPTY_STRING_ARRAY = new String[0];
    }
}

