/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.finalizers;

import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerException;
import jaxx.compiler.EventHandler;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.binding.writers.DefaultJAXXBindingWriter;
import jaxx.compiler.binding.writers.JAXXBindingWriter;
import jaxx.compiler.binding.writers.SimpleJAXXObjectBindingWriter;
import jaxx.compiler.finalizers.AbstractFinalizer;
import jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaElementFactory;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.MemberDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.Base64Coder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=JAXXCompilerFinalizer.class, hint="default")
public class DefaultFinalizer
extends AbstractFinalizer {
    protected static final Log log = LogFactory.getLog(DefaultFinalizer.class);
    private static final String PARAMETER_NAME_$BINDING = "$binding";
    public static final String FIELD_NAME_$BINDING_SOURCES = "$bindingSources";
    public static final String FIELD_NAME_$OBJECT_MAP = "$objectMap";
    public static final String FIELD_NAME_$ACTIVE_BINDINGS = "$activeBindings";
    public static final String FIELD_NAME_ALL_COMPONENTS_CREATED = "allComponentsCreated";
    public static final String FIELD_NAME_CONTEXT_INITIALIZED = "contextInitialized";
    public static final String FIELD_NAME_$PREVIOUS_VALUES = "$previousValues";
    public static final String FIELD_NAME_$BINDINGS = "$bindings";
    public static final String FIELD_NAME_$PROPERTY_CHANGE_SUPPORT = "$propertyChangeSupport";
    public static final String FIELD_NAME_DELEGATE_CONTEXT = "delegateContext";
    public static final String FIELD_NAME_SERIAL_VERSION_UID = "serialVersionUID";
    public static final String FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR = "$jaxxObjectDescriptor";
    public static final String METHOD_NAME_$GET_JAXXOBJECT_DESCRIPTOR = "$getJAXXObjectDescriptor";
    public static final String METHOD_NAME_$REGISTER_DEFAULT_BINDINGS = "$registerDefaultBindings";
    public static final String METHOD_NAME_REGISTER_DATA_BINDING = "registerDataBinding";
    public static final String METHOD_NAME_REMOVE_DATA_BINDING = "removeDataBinding";
    public static final String METHOD_NAME_APPLY_DATA_BINDING = "applyDataBinding";
    public static final String METHOD_NAME_PROCESS_DATA_BINDING = "processDataBinding";
    public static final String METHOD_NAME_FIRE_PROPERTY_CHANGE = "firePropertyChange";
    public static final String METHOD_NAME_$GET_PROPERTY_CHANGE_SUPPORT = "$getPropertyChangeSupport";
    public static final String METHOD_NAME_$INITIALIZE = "$initialize";
    public static final String METHOD_NAME_$COMPLETE_SETUP = "$completeSetup";
    public static final String METHOD_NAME_$AFTER_COMPLETE_SETUP = "$afterCompleteSetup";
    protected static final JavaField SERIAL_VERSION_UID_FIELD = JavaElementFactory.newField(26, "long", "serialVersionUID", false, "1L", new String[0]);
    protected static final JavaField ACTIVE_BINDINGS_FIELD = JavaElementFactory.newField(4, List.class.getName() + "<" + "Object" + ">", "$activeBindings", false, "new %s<Object>()", ArrayList.class.getName());
    protected static final JavaField BINDING_SOURCES_FIELD = JavaElementFactory.newField(4, Map.class.getName() + "<" + "String" + ", " + "Object" + ">", "$bindingSources", false, "new %s<String, Object>()", HashMap.class.getName());
    protected static final JavaField OBJECT_MAP_FIELD = JavaElementFactory.newField(4, Map.class.getName() + "<" + "String" + ", " + "Object" + ">", "$objectMap", true, "new %s<String, Object>()", HashMap.class.getName());
    protected static final JavaField ALL_COMPONENTS_CREATED_FIELD = JavaElementFactory.newField(2, "boolean", "allComponentsCreated", false);
    protected static final JavaField CONTEXT_INITIALIZED = JavaElementFactory.newField(2, "boolean", "contextInitialized", false, "true", new String[0]);
    protected static final JavaField PREVIOUS_VALUES_FIELD = JavaElementFactory.newField(4, Map.class.getName() + "<?,?>", "$previousValues", false, "new %s<Object, Object>()", HashMap.class.getName());
    protected static final JavaField BINDINGS_FIELD = JavaElementFactory.newField(20, Map.class.getName() + "<" + "String" + ", " + JAXXBinding.class.getName() + ">", "$bindings", false, "new %s<String, %s>()", TreeMap.class.getName(), JAXXBinding.class.getName());
    protected static final JavaField PROPERTY_CHANGE_SUPPORT_FIELD = JavaElementFactory.newField(4, PropertyChangeSupport.class.getName(), "$propertyChangeSupport", false);
    protected static final JavaMethod GET_CONTEXT_VALUE_METHOD = JavaElementFactory.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, null);", true, JavaElementFactory.newArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_CONTEXT_VALUE_NAMED_METHOD = JavaElementFactory.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, name);", true, JavaElementFactory.newArgument("Class<T>", "clazz"), JavaElementFactory.newArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_NAMED_METHOD = JavaElementFactory.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, name);", true, JavaElementFactory.newArgument("T", "o"), JavaElementFactory.newArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_METHOD = JavaElementFactory.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, null);", true, JavaElementFactory.newArgument("T", "o"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_NAMED_METHOD = JavaElementFactory.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, name);", true, JavaElementFactory.newArgument("Class<T>", "clazz"), JavaElementFactory.newArgument("String", "name"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_METHOD = JavaElementFactory.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, null);", true, JavaElementFactory.newArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_MORE_METHOD = JavaElementFactory.newMethod(1, "<O extends Container> O", "getParentContainer", "return %s.getParentContainer(source, clazz);", true, JavaElementFactory.newArgument("Object", "source"), JavaElementFactory.newArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_METHOD = JavaElementFactory.newMethod(1, "<O extends Container> O", "getParentContainer", "return %s.getParentContainer(this, clazz);", true, JavaElementFactory.newArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_OBJECT_BY_ID_METHOD = JavaElementFactory.newMethod(1, "Object", "getObjectById", "return $objectMap.get(id);", true, JavaElementFactory.newArgument("String", "id"));
    protected static final JavaMethod GET_JAXX_OBJECT_DESCRIPTOR_METHOD = JavaElementFactory.newMethod(9, JAXXObjectDescriptor.class.getName(), "$getJAXXObjectDescriptor", "return %s.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);", false, new JavaArgument[0]);
    protected static final JavaMethod PROCESS_DATA_BINDING_METHOD = JavaElementFactory.newMethod(1, "void", "processDataBinding", "processDataBinding($binding, false);", true, JavaElementFactory.newArgument("String", "$binding"));
    protected static final JavaMethod REGISTER_DATA_BINDING_METHOD = JavaElementFactory.newMethod(1, "void", "registerDataBinding", "$bindings.put(binding.getId(), binding);", true, JavaElementFactory.newArgument(JAXXBinding.class.getName(), "binding"));
    protected static final JavaMethod GET_DATA_BINDINGS_METHOD = JavaElementFactory.newMethod(1, JAXXBinding.class.getName() + "[]", "getDataBindings", "return $bindings.values().toArray(new %s[$bindings.size()]);", true, new JavaArgument[0]);
    protected static final JavaMethod GET_DATA_BINDING_METHOD = JavaElementFactory.newMethod(1, JAXXBinding.class.getName(), "getDataBinding", "return $bindings.get(bindingId);", true, JavaElementFactory.newArgument("String", "bindingId"));
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_METHOD = JavaElementFactory.newMethod(1, "void", "firePropertyChange", "super.firePropertyChange(propertyName, oldValue, newValue);", true, JavaElementFactory.newArgument("String", "propertyName"), JavaElementFactory.newArgument("Object", "oldValue"), JavaElementFactory.newArgument("Object", "newValue"));
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_NAMED_METHOD = JavaElementFactory.newMethod(1, "void", "firePropertyChange", "$getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);", true, JavaElementFactory.newArgument("String", "propertyName"), JavaElementFactory.newArgument("Object", "oldValue"), JavaElementFactory.newArgument("Object", "newValue"));
    protected static final JavaMethod GET_PROPERTY_CHANGE_SUPPORT_METHOD = JavaElementFactory.newMethod(0, PropertyChangeSupport.class.getName(), "$getPropertyChangeSupport", "if ($propertyChangeSupport == null)\n    $propertyChangeSupport = new PropertyChangeSupport(this);\nreturn $propertyChangeSupport;", false, new JavaArgument[0]);
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_METHOD = JavaElementFactory.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(listener);", true, JavaElementFactory.newArgument(PropertyChangeListener.class.getName(), "listener"));
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaElementFactory.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(property, listener);", true, JavaElementFactory.newArgument("String", "property"), JavaElementFactory.newArgument(PropertyChangeListener.class.getName(), "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD = JavaElementFactory.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(listener);", true, JavaElementFactory.newArgument(PropertyChangeListener.class.getName(), "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaElementFactory.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(property, listener);", true, JavaElementFactory.newArgument("String", "property"), JavaElementFactory.newArgument(PropertyChangeListener.class.getName(), "listener"));
    private static final String PARAMETER_NAME_PARENT_CONTEXT = "parentContext";
    public static final String METHOD_NAME$BEFORE_INIT = "beforeInit";
    private static final String METHOD_NAME$AFTER_INIT = "afterInit";
    protected final JAXXBindingWriter<?>[] bindingWriters = new JAXXBindingWriter[]{new SimpleJAXXObjectBindingWriter(), new DefaultJAXXBindingWriter()};

    @Override
    public boolean accept(JAXXCompiler compiler) {
        return true;
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        String fullClassName;
        String string = fullClassName = packageName != null ? packageName + "." + className : className;
        if (root == null) {
            throw new CompilerException("root tag can not be null");
        }
        ClassDescriptor superclass = root.getObjectClass();
        boolean superclassIsJAXXObject = compiler.isSuperClassAware(JAXXObject.class);
        javaFile.setModifiers(1);
        javaFile.setName(fullClassName);
        javaFile.setSimpleName(className);
        javaFile.setSuperClass(JAXXCompiler.getCanonicalName(superclass));
        javaFile.setSuperclassIsJAXXObject(superclassIsJAXXObject);
        javaFile.addInterface(compiler.getExtraInterfaces());
        javaFile.setAbstractClass(compiler.isAbstractClass());
        javaFile.setGenericType(compiler.getGenericType());
        javaFile.setSuperGenericType(compiler.getSuperGenericType());
        if (!superclassIsJAXXObject) {
            javaFile.addInterface(JAXXObject.class.getName());
        }
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        this.addLoggerSupport(compiler, javaFile, className);
        this.addJAXXObjectSupport(compiler, root, javaFile);
        this.addSimpleField(javaFile, SERIAL_VERSION_UID_FIELD);
        this.addSimpleField(javaFile, ALL_COMPONENTS_CREATED_FIELD);
        this.addJAXXObjectDescriptorField(compiler, javaFile);
        this.addMethod(javaFile, GET_JAXX_OBJECT_DESCRIPTOR_METHOD, JAXXUtil.class.getName());
        this.addPreviousValuesField(compiler, javaFile, root);
        DataBinding[] bindings = compiler.getBindingHelper().getDataBindings();
        this.addInitializerMethod(compiler, javaFile, bindings.length);
        javaFile.addBodyCode(compiler.getBodyCode().toString());
        this.addDataBindings(compiler, javaFile, bindings);
        this.addCompleteSetupMethod(compiler, javaFile);
        this.addEventHandlers(compiler, javaFile);
    }

    protected void addDataBindings(JAXXCompiler compiler, JavaFile javaFile, DataBinding[] bindings) {
        if (bindings.length < 1) {
            return;
        }
        for (JAXXBindingWriter<?> writer : this.bindingWriters) {
            writer.reset();
        }
        this.addRegisteredDefaultBindingsMethod(compiler, javaFile);
        for (JAXXBindingWriter<?> writer : this.bindingWriters) {
            if (!writer.isUsed()) continue;
            compiler.getJavaFile().addImport(writer.getType());
        }
        for (DataBinding binding : bindings) {
            String constantId = binding.getConstantId();
            compiler.addSimpleField(JavaElementFactory.newField((constantId.startsWith("BINDING_$") ? 2 : 1) | 0x10 | 8, "String", constantId, false, TypeManager.getJavaCode(binding.getRealId()), new String[0]));
        }
    }

    protected void addConstructors(JAXXCompiler compiler, JavaFile javaFile, String className) {
        MethodDescriptor[] methods;
        boolean superclassIsJAXXObject = javaFile.isSuperclassIsJAXXObject();
        boolean constructorDetected = false;
        for (MethodDescriptor m : methods = compiler.getScriptMethods()) {
            try {
                m.getReturnType();
                if (!className.equals(m.getName())) continue;
                constructorDetected = true;
                break;
            }
            catch (Exception e) {
                log.warn((Object)("could not find return type " + m));
            }
        }
        if (!constructorDetected) {
            JavaMethod constructor = this.createConstructor(compiler, className, superclassIsJAXXObject);
            javaFile.addMethod(constructor);
            constructor = this.createConstructorWithInitialContext(compiler, className, superclassIsJAXXObject);
            javaFile.addMethod(constructor);
        }
    }

    protected void addJAXXObjectSupport(JAXXCompiler compiler, CompiledObject root, JavaFile javaFile) {
        String jaxxContextImplementorClass = compiler.getConfiguration().getJaxxContextClass().getName();
        boolean superclassIsJAXXObject = javaFile.isSuperclassIsJAXXObject();
        if (superclassIsJAXXObject) {
            javaFile.addImport(JAXXContext.class);
        } else {
            this.addField(javaFile, OBJECT_MAP_FIELD);
            this.addSimpleField(javaFile, BINDING_SOURCES_FIELD);
            this.addSimpleField(javaFile, ACTIVE_BINDINGS_FIELD);
            this.addSimpleField(javaFile, BINDINGS_FIELD);
            javaFile.addMethod(GET_OBJECT_BY_ID_METHOD);
            this.addMethod(javaFile, REGISTER_DATA_BINDING_METHOD, new String[0]);
            this.addMethod(javaFile, GET_DATA_BINDINGS_METHOD, JAXXBinding.class.getSimpleName());
            this.addMethod(javaFile, GET_DATA_BINDING_METHOD, JAXXBinding.class.getSimpleName());
            javaFile.addMethod(this.createApplyDataBindingMethod());
            javaFile.addMethod(this.createProcessDataBindingMethod());
            javaFile.addMethod(this.createRemoveDataBindingMethod());
            String type = javaFile.getImportedType(jaxxContextImplementorClass);
            javaFile.addField(JavaElementFactory.newField(20, JAXXContext.class.getName(), FIELD_NAME_DELEGATE_CONTEXT, true, "new " + type + "()", new String[0]));
            javaFile.addImport(Container.class);
            javaFile.addMethod(SET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(SET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_NAMED_METHOD);
            this.addMethod(javaFile, GET_PARENT_CONTAINER_METHOD, SwingUtil.class.getName());
            this.addMethod(javaFile, GET_PARENT_CONTAINER_MORE_METHOD, SwingUtil.class.getName());
            this.addPropertyChangeSupport(root, javaFile);
            javaFile.addMethod(PROCESS_DATA_BINDING_METHOD);
        }
    }

    protected void addLoggerSupport(JAXXCompiler compiler, JavaFile javaFile, String className) {
        if (compiler.getConfiguration().isAddLogger()) {
            javaFile.addSimpleField(JavaElementFactory.newField(26, Log.class.getName(), "log", false, "%s.getLog(" + className + ".class)", LogFactory.class.getName()));
        }
    }

    protected JavaField addJAXXObjectDescriptorField(JAXXCompiler compiler, JavaFile javaFile) {
        JavaField field;
        try {
            JAXXObjectDescriptor descriptor = compiler.getJAXXObjectDescriptor();
            String data = Base64Coder.serialize((Object)descriptor, (boolean)true);
            int sizeLimit = 65000;
            if (data.length() < sizeLimit) {
                field = JavaElementFactory.newField(26, "String", FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR, false, TypeManager.getJavaCode(data), new String[0]);
            } else {
                StringBuilder initializer = new StringBuilder();
                for (int i = 0; i < data.length(); i += sizeLimit) {
                    String name = FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR + i;
                    javaFile.addField(JavaElementFactory.newField(10, "String", name, false, TypeManager.getJavaCode(data.substring(i, Math.min(i + sizeLimit, data.length()))), new String[0]));
                    if (initializer.length() > 0) {
                        initializer.append(" + ");
                    }
                    initializer.append("String.valueOf(");
                    initializer.append(name);
                    initializer.append(")");
                }
                field = JavaElementFactory.newField(26, "String", FIELD_NAME_$JAXX_OBJECT_DESCRIPTOR, false, initializer.toString(), new String[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
        javaFile.addSimpleField(field);
        return field;
    }

    protected void addPreviousValuesField(JAXXCompiler compiler, JavaFile javaFile, CompiledObject root) {
        boolean superclassIsJAXXObject = javaFile.isSuperclassIsJAXXObject();
        if (compiler.getStylesheet() != null) {
            boolean needField = true;
            if (superclassIsJAXXObject) {
                JAXXCompiler parentCompiler;
                ClassDescriptor superclass = root.getObjectClass();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("superclass : " + superclass));
                }
                if ((parentCompiler = compiler.getEngine().getJAXXCompiler(superclass.getName())) != null) {
                    needField = parentCompiler.getStylesheet() == null;
                } else {
                    try {
                        superclass.getDeclaredFieldDescriptor(PREVIOUS_VALUES_FIELD.getName());
                        needField = false;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                if (needField && log.isDebugEnabled()) {
                    log.debug((Object)("no " + PREVIOUS_VALUES_FIELD.getName() + " field in super class"));
                }
            }
            if (needField) {
                this.addSimpleField(javaFile, PREVIOUS_VALUES_FIELD);
            }
        }
    }

    protected void addPropertyChangeSupport(CompiledObject root, JavaFile javaFile) {
        int modifiers;
        ClassDescriptor currentClass = root.getObjectClass();
        MemberDescriptor firePropertyChange = null;
        while (firePropertyChange == null && currentClass != null) {
            try {
                firePropertyChange = currentClass.getDeclaredMethodDescriptor(METHOD_NAME_FIRE_PROPERTY_CHANGE, ClassDescriptorHelper.getClassDescriptor(String.class), ClassDescriptorHelper.getClassDescriptor(Object.class), ClassDescriptorHelper.getClassDescriptor(Object.class));
            }
            catch (NoSuchMethodException e) {
                currentClass = currentClass.getSuperclass();
            }
        }
        int n = modifiers = firePropertyChange != null ? firePropertyChange.getModifiers() : 0;
        if (Modifier.isPublic(modifiers)) {
            return;
        }
        if (Modifier.isProtected(modifiers)) {
            javaFile.addMethod(FIRE_PROPERTY_CHANGE_METHOD);
        } else {
            this.addField(javaFile, PROPERTY_CHANGE_SUPPORT_FIELD);
            this.addMethod(javaFile, GET_PROPERTY_CHANGE_SUPPORT_METHOD, PropertyChangeSupport.class.getName());
            this.addMethod(javaFile, ADD_PROPERTY_CHANGE_SUPPORT_METHOD, new String[0]);
            this.addMethod(javaFile, ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD, new String[0]);
            this.addMethod(javaFile, REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD, new String[0]);
            this.addMethod(javaFile, REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD, new String[0]);
            this.addMethod(javaFile, FIRE_PROPERTY_CHANGE_NAMED_METHOD, new String[0]);
        }
    }

    protected JavaMethod addRegisteredDefaultBindingsMethod(JAXXCompiler compiler, JavaFile javaFile) {
        DataBinding[] bindings = compiler.getBindingHelper().getDataBindings();
        StringBuilder initCode = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        JavaFileGenerator generator = new JavaFileGenerator(eol, true);
        initCode.append("// register ");
        initCode.append(bindings.length);
        initCode.append(" data bindings");
        initCode.append(eol);
        block0: for (DataBinding binding : bindings) {
            for (JAXXBindingWriter<?> writer : this.bindingWriters) {
                if (!writer.accept(binding)) continue;
                writer.write(binding, generator, initCode);
                continue block0;
            }
        }
        JavaMethod method = JavaElementFactory.newMethod(2, "void", METHOD_NAME_$REGISTER_DEFAULT_BINDINGS, initCode.toString(), false, new JavaArgument[0]);
        javaFile.addMethod(method);
        return method;
    }

    protected void addEventHandlers(JAXXCompiler compiler, JavaFile javaFile) {
        for (Map.Entry<String, Map<ClassDescriptor, List<EventHandler>>> e1 : compiler.getEventHandlers().entrySet()) {
            for (Map.Entry<ClassDescriptor, List<EventHandler>> e2 : e1.getValue().entrySet()) {
                for (EventHandler handler : e2.getValue()) {
                    String methodName = compiler.getEventHandlerMethodName(handler);
                    MethodDescriptor listenerMethod = handler.getListenerMethod();
                    if (listenerMethod.getParameterTypes().length != 1) {
                        throw new CompilerException("Expected event handler " + listenerMethod.getName() + " of class " + handler.getListenerClass() + " to have exactly one argument");
                    }
                    ClassDescriptor eventType = listenerMethod.getParameterTypes()[0];
                    JavaArgument argument = JavaElementFactory.newArgument(JAXXCompiler.getCanonicalName(eventType), "event");
                    String body = JavaFileGenerator.addDebugLoggerInvocation(compiler, "event");
                    body = body + handler.getJavaCode();
                    javaFile.addMethod(JavaElementFactory.newMethod(1, "void", methodName, body, false, argument));
                }
            }
        }
    }

    protected JavaMethod createConstructor(JAXXCompiler compiler, String className, boolean superclassIsJAXXObject) throws CompilerException {
        StringBuilder code = new StringBuilder();
        String constructorParams = compiler.getRootObject().getConstructorParams();
        String eol = JAXXCompiler.getLineSeparator();
        if (constructorParams != null) {
            code.append("        super(");
            code.append(constructorParams);
            code.append(");");
            code.append(eol);
        }
        code.append("$initialize();");
        code.append(eol);
        return JavaElementFactory.newMethod(1, null, className, code.toString(), false, new JavaArgument[0]);
    }

    protected JavaMethod createConstructorWithInitialContext(JAXXCompiler compiler, String className, boolean superclassIsJAXXObject) throws CompilerException {
        StringBuilder code = new StringBuilder();
        String constructorParams = compiler.getRootObject().getConstructorParams();
        String eol = JAXXCompiler.getLineSeparator();
        String realConstructorParams = "";
        if (superclassIsJAXXObject) {
            realConstructorParams = PARAMETER_NAME_PARENT_CONTEXT;
        }
        if (constructorParams != null) {
            if (superclassIsJAXXObject) {
                realConstructorParams = realConstructorParams + " ,";
            }
            realConstructorParams = realConstructorParams + constructorParams;
        }
        if (StringUtils.isNotEmpty((CharSequence)(realConstructorParams = realConstructorParams.trim()))) {
            code.append("        super(");
            code.append(realConstructorParams);
            code.append(");");
            code.append(eol);
        }
        if (!superclassIsJAXXObject) {
            String prefix = compiler.getImportedType(JAXXUtil.class);
            code.append(prefix);
            code.append(".initContext(this, parentContext);");
            code.append(eol);
        }
        code.append("$initialize();");
        code.append(eol);
        JavaArgument argument = JavaElementFactory.newArgument(JAXXContext.class.getName(), PARAMETER_NAME_PARENT_CONTEXT);
        return JavaElementFactory.newMethod(1, null, className, code.toString(), false, argument);
    }

    public JavaMethod addInitializerMethod(JAXXCompiler compiler, JavaFile javaFile, int nbBindings) throws CompilerException {
        boolean overrideContextInitialized = compiler.containsScriptField(FIELD_NAME_CONTEXT_INITIALIZED);
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder code = new StringBuilder();
        CompiledObject root = compiler.getRootObject();
        code.append("if (allComponentsCreated");
        if (overrideContextInitialized) {
            code.append("|| !contextInitialized");
        }
        code.append(") {");
        code.append(eol);
        code.append("    return;").append(eol);
        code.append("}").append(eol);
        code.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        boolean useHandler = compiler.isUseHandler();
        if (useHandler) {
            code.append("handler.beforeInit(this);").append(eol);
        }
        code.append("$objectMap.put(");
        String rootId = root.getId();
        code.append(TypeManager.getJavaCode(rootId));
        code.append(", ").append(rootId).append(");").append(eol);
        Iterator<CompiledObject> i = compiler.getObjectCreationOrder();
        boolean lastWasMethodCall = false;
        while (i.hasNext()) {
            CompiledObject object = i.next();
            if (object == root) continue;
            CompiledObjectDecorator decorator = object.getDecorator();
            lastWasMethodCall = decorator.createInitializer(compiler, root, object, code, lastWasMethodCall);
        }
        root.getDecorator().createInitializer(compiler, root, root, code, lastWasMethodCall);
        if (compiler.getInitializer().length() > 0) {
            code.append((CharSequence)compiler.getInitializer());
        }
        if (nbBindings > 0) {
            code.append("// registers ");
            code.append(nbBindings);
            code.append(" data bindings");
            code.append(eol);
            code.append("$registerDefaultBindings();");
            code.append(eol);
        }
        code.append("$completeSetup();");
        code.append(eol);
        if (useHandler) {
            code.append("handler.afterInit(this);").append(eol);
        }
        JavaMethod method = JavaElementFactory.newMethod(2, "void", METHOD_NAME_$INITIALIZE, code.toString(), false, new JavaArgument[0]);
        javaFile.addMethod(method);
        return method;
    }

    protected JavaMethod addCompleteSetupMethod(JAXXCompiler compiler, JavaFile javaFile) {
        MethodDescriptor method;
        StringBuilder code = new StringBuilder();
        code.append("allComponentsCreated = true;");
        String eol = JAXXCompiler.getLineSeparator();
        code.append(eol);
        code.append(JavaFileGenerator.addDebugLoggerInvocation(compiler, "this"));
        for (CompiledObject object : compiler.getObjects().values()) {
            CompiledObjectDecorator decorator = object.getDecorator();
            code.append(decorator.createCompleteSetupMethod(compiler, object, javaFile));
        }
        String simpleBindingsCode = this.createInitBindingsCode(compiler);
        if (simpleBindingsCode != null && !simpleBindingsCode.isEmpty()) {
            code.append(simpleBindingsCode).append(eol);
        }
        if (compiler.getLateInitializer().length() > 0) {
            code.append("// late initializer").append(eol);
            code.append((CharSequence)compiler.getLateInitializer()).append(eol);
        }
        if ((method = compiler.getScriptMethod(METHOD_NAME_$AFTER_COMPLETE_SETUP)) != null) {
            if (compiler.isUseHandler()) {
                compiler.reportWarning("Should not use deprecated api $afterCompleteSetup, prefer declare a 'handler' attribute on root object.");
            }
            code.append("$afterCompleteSetup();").append(eol);
        }
        JavaMethod javaMethod = JavaElementFactory.newMethod(2, "void", METHOD_NAME_$COMPLETE_SETUP, code.toString(), false, new JavaArgument[0]);
        javaFile.addMethod(javaMethod);
        return javaMethod;
    }

    protected String createInitBindingsCode(JAXXCompiler compiler) {
        String eol = JAXXCompiler.getLineSeparator();
        StringBuilder result = new StringBuilder();
        DataBinding[] bindings = compiler.getBindingHelper().getDataBindings();
        if (bindings.length > 0) {
            result.append(eol);
            result.append("// apply ");
            result.append(bindings.length);
            result.append(" data bindings");
            result.append(eol);
            result.append(JAXXUtil.class.getSimpleName());
            result.append(".applyDataBinding(this, $bindings.keySet());");
            result.append(eol);
        }
        if ((bindings = compiler.getBindingHelper().getSimpleBindings()).length > 0) {
            StringBuilder initCode = new StringBuilder();
            for (DataBinding binding : bindings) {
                String binding1 = binding.getInitDataBinding();
                if (binding1 == null || binding1.trim().isEmpty()) continue;
                initCode.append(binding1);
            }
            if (initCode.length() > 0) {
                result.append(eol);
                result.append("// apply ");
                result.append(bindings.length);
                result.append(" property setters");
                result.append(eol);
                result.append(initCode.toString().trim());
            }
        }
        return result.toString();
    }

    protected JavaMethod createApplyDataBindingMethod() {
        StringBuilder buffer = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        buffer.append("if (allComponentsCreated && $bindings.containsKey($binding)) {");
        buffer.append(eol);
        buffer.append("    getDataBinding($binding).applyDataBinding();");
        buffer.append(eol);
        buffer.append("}");
        buffer.append(eol);
        buffer.append("processDataBinding($binding);");
        return JavaElementFactory.newMethod(1, "void", METHOD_NAME_APPLY_DATA_BINDING, buffer.toString(), true, JavaElementFactory.newArgument("String", PARAMETER_NAME_$BINDING));
    }

    protected JavaMethod createRemoveDataBindingMethod() {
        StringBuilder buffer = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        buffer.append("if (allComponentsCreated && $bindings.containsKey($binding)) {");
        buffer.append(eol);
        buffer.append("    getDataBinding($binding).removeDataBinding();");
        buffer.append(eol);
        buffer.append("}");
        return JavaElementFactory.newMethod(1, "void", METHOD_NAME_REMOVE_DATA_BINDING, buffer.toString(), true, JavaElementFactory.newArgument("String", PARAMETER_NAME_$BINDING));
    }

    protected JavaMethod createProcessDataBindingMethod() {
        StringBuilder code = new StringBuilder();
        String eol = JAXXCompiler.getLineSeparator();
        code.append("    if (!$force && $activeBindings.contains($binding)) { ");
        code.append(eol);
        code.append("    return;");
        code.append(eol);
        code.append("}").append(eol);
        code.append("$activeBindings.add($binding);");
        code.append(eol);
        code.append("try {").append(eol);
        code.append("    if (allComponentsCreated && $bindings.containsKey($binding)) {");
        code.append(eol);
        code.append("        getDataBinding($binding).processDataBinding();");
        code.append(eol);
        code.append("    }").append(eol);
        code.append("} finally {").append(eol);
        code.append("    $activeBindings.remove($binding);");
        code.append(eol);
        code.append("}").append(eol);
        return JavaElementFactory.newMethod(1, "void", METHOD_NAME_PROCESS_DATA_BINDING, code.toString(), true, JavaElementFactory.newArgument("String", PARAMETER_NAME_$BINDING), JavaElementFactory.newArgument("boolean", "$force"));
    }
}

