/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: JAXXListHandler.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.4.2/jaxx-compiler/src/main/java/jaxx/compiler/tags/swing/JAXXListHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.tags.swing;

import jaxx.compiler.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.DefaultComponentHandler;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.swing.JAXXList;
import jaxx.runtime.swing.Item;
import org.w3c.dom.Element;

import javax.swing.event.ListSelectionListener;
import java.io.IOException;
import java.util.List;

public class JAXXListHandler extends DefaultComponentHandler {

    public JAXXListHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(getClass(), beanClass, JAXXList.class);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("getSelectedIndex", ListSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectedIndices", ListSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectedValue", ListSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectedValues", ListSelectionListener.class, "selectionModel");
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledItemContainer(id, getBeanClass(), compiler);
    }

    @Override
    public void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        super.compileChildrenSecondPass(tag, compiler);
        CompiledItemContainer list = (CompiledItemContainer) compiler.getOpenComponent();
        List<Item> items = list.getItems();
        if (items != null && !items.isEmpty()) {
            String listName = list.getId() + "$items";
            //TODO Add the correct generic type
            list.appendAdditionCode("java.util.List<jaxx.runtime.swing.Item> " + listName + " = new java.util.ArrayList<jaxx.runtime.swing.Item>();");
            for (Item item : items) {
                String id = item.getId();
                CompiledObject compiledItem = new CompiledObject(id, ClassDescriptorHelper.getClassDescriptor(Item.class), compiler);
                compiledItem.setConstructorParams(TypeManager.getJavaCode(id) + ", " + TypeManager.getJavaCode(item.getLabel()) + ", " + TypeManager.getJavaCode(item.getValue()) + ", " + item.isSelected());
                compiler.registerCompiledObject(compiledItem);
                list.appendAdditionCode(listName + ".add(" + id + ");");
            }
            list.appendAdditionCode(list.getId() + ".setItems(" + listName + ");");
        }
    }
}



