/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.binding;

import java.beans.Introspector;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.UnsupportedAttributeException;
import jaxx.compiler.binding.DataBindingHelper;
import jaxx.compiler.binding.DataListener;
import jaxx.compiler.binding.JavaParserUtil;
import jaxx.compiler.java.JavaElementFactory;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.compiler.java.parser.JavaParser;
import jaxx.compiler.java.parser.JavaParserConstants;
import jaxx.compiler.java.parser.JavaParserTreeConstants;
import jaxx.compiler.java.parser.SimpleNode;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.tags.DefaultObjectHandler;
import jaxx.compiler.tags.TagManager;
import jaxx.compiler.types.TypeManager;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSource {
    protected static final Log log = LogFactory.getLog(DataSource.class);
    private final String id;
    protected final String constantId;
    private final String source;
    private final JAXXCompiler compiler;
    private final List<DataListener> trackers;
    private String objectCode;
    protected final List<JavaMethod> methods;
    private Set<String> overrideIds;

    public DataSource(String id, String constantId, String source, JAXXCompiler compiler, List<JavaMethod> methods) {
        this.id = id;
        this.constantId = constantId;
        this.source = source;
        this.compiler = compiler;
        this.methods = methods;
        this.trackers = new ArrayList<DataListener>();
    }

    public String getObjectCode() {
        return this.objectCode;
    }

    public DataListener[] getTrackers() {
        return this.trackers.toArray(new DataListener[this.trackers.size()]);
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        b.append("source:id", (Object)this.id);
        b.append("source:source", (Object)this.source);
        b.append("source:objectCode", (Object)this.getObjectCode());
        if (!this.trackers.isEmpty()) {
            b.append("source:trackers", this.trackers.size());
            for (DataListener d : this.trackers) {
                b.append("source:tracker", (Object)d);
            }
        }
        return b.toString();
    }

    public boolean showLog() {
        return DataBindingHelper.SHOW_LOG;
    }

    protected boolean compile() throws CompilerException, IllegalStateException {
        boolean isBinding;
        if (this.showLog()) {
            log.info((Object)("======= Start compile of " + this.source));
        }
        JavaParser p = new JavaParser(new StringReader(this.source));
        LinkedHashMap<SimpleNode, List<SimpleNode>> expressions = new LinkedHashMap<SimpleNode, List<SimpleNode>>();
        LinkedHashMap<SimpleNode, List<SimpleNode>> castsExpressions = new LinkedHashMap<SimpleNode, List<SimpleNode>>();
        ArrayList<SimpleNode> literalExpressions = new ArrayList<SimpleNode>();
        while (!p.Line()) {
            SimpleNode node = p.popNode();
            if (log.isTraceEnabled()) {
                log.trace((Object)("will scan node " + node.getText()));
            }
            JavaParserUtil.getExpressions(node, expressions, literalExpressions, castsExpressions);
        }
        JavaParserUtil.removeLiteralExpressions(expressions, literalExpressions);
        literalExpressions.clear();
        JavaParserUtil.removeNoneStandaloneExpressions(expressions, castsExpressions);
        for (SimpleNode node : expressions.keySet()) {
            if (this.showLog()) {
                log.info((Object)("Will parse expression " + node.getText()));
            }
            this.scanNode(node);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trackers=" + this.trackers));
        }
        boolean bl = isBinding = !this.trackers.isEmpty();
        if (isBinding) {
            Set<String> result = JavaParserUtil.getRequired(expressions.keySet(), castsExpressions);
            if (result == null || result.isEmpty()) {
                this.objectCode = "";
            } else {
                StringBuilder buffer = new StringBuilder();
                Iterator<String> itr = result.iterator();
                this.overrideIds = new HashSet<String>();
                String realSource = this.getJavaCode(itr.next());
                buffer.append(realSource).append(" != null");
                while (itr.hasNext()) {
                    realSource = this.getJavaCode(itr.next());
                    buffer.append(" && ").append(realSource).append(" != null");
                }
                this.objectCode = buffer.toString().trim();
            }
        }
        castsExpressions.clear();
        expressions.clear();
        return isBinding;
    }

    private String getJavaCode(String s) {
        CompiledObject o = this.compiler.getCompiledObject(s);
        if (o != null && o.isOverride()) {
            if (this.showLog()) {
                log.info((Object)("Use an override identifier : " + o.getJavaCode()));
            }
            this.overrideIds.add(s);
        }
        return s;
    }

    public Set<String> getOverrideIds() {
        return this.overrideIds;
    }

    private void scanNode(SimpleNode node) throws CompilerException {
        if (node.getId() == 22 || node.getId() == 17) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)node.getText());
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            this.scanNode(node.getChild(i));
        }
        ClassDescriptor type = null;
        if (node.jjtGetNumChildren() == 1) {
            type = node.getChild(0).getJavaType();
        }
        switch (node.getId()) {
            case 31: {
                type = ClassDescriptorHelper.getClassDescriptor(Class.class);
                break;
            }
            case 62: {
                type = this.determineExpressionType(node);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("result of determineExpressionType for " + node.getText() + " = " + type));
                break;
            }
            case 66: {
                type = this.determineLiteralType(node);
                break;
            }
            case 61: {
                type = TagManager.resolveClass(node.getChild(0).getText(), this.compiler);
            }
        }
        node.setJavaType(type);
    }

    private ClassDescriptor determineExpressionType(SimpleNode expression) {
        assert (expression.getId() == 62);
        SimpleNode prefix = expression.getChild(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("for expression " + expression.getText() + " - prefix " + prefix + " - nb childrens of prefix: " + prefix.jjtGetNumChildren() + ", nb childrens of expression : " + expression.jjtGetNumChildren()));
        }
        if (prefix.jjtGetNumChildren() == 1) {
            int type = prefix.getChild(0).getId();
            if (type == 66 || type == 39) {
                prefix.setJavaType(prefix.getChild(0).getJavaType());
            } else if (type == 37 && expression.jjtGetNumChildren() == 1) {
                ClassDescriptor classDescriptor = this.scanCompoundSymbol(prefix.getText().trim(), this.compiler.getRootObject().getObjectClass(), false);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("scanCompoundSymbol result for node " + prefix.getText().trim() + " = " + classDescriptor));
                }
                prefix.setJavaType(classDescriptor);
            }
        }
        if (expression.jjtGetNumChildren() == 1) {
            return prefix.getJavaType();
        }
        ClassDescriptor contextClass = prefix.getJavaType();
        if (contextClass == null) {
            contextClass = this.compiler.getRootObject().getObjectClass();
        }
        String lastNode = prefix.getText().trim();
        for (int i = 1; i < expression.jjtGetNumChildren(); ++i) {
            SimpleNode suffix;
            block29: {
                suffix = expression.getChild(i);
                if (suffix.jjtGetNumChildren() == 1 && suffix.getChild(0).getId() == 69 && suffix.getChild(0).jjtGetNumChildren() == 0) {
                    contextClass = this.scanCompoundSymbol(lastNode, contextClass, true);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("scanCompoundSymbol result for node " + lastNode + " = " + contextClass));
                    }
                    if (contextClass == null) {
                        return null;
                    }
                    int dotPos = lastNode.lastIndexOf(".");
                    String code = dotPos == -1 ? "" : lastNode.substring(0, dotPos);
                    for (int j = i - 2; j >= 0; --j) {
                        code = expression.getChild(j).getText() + code;
                    }
                    if (code.length() == 0) {
                        code = this.compiler.getRootObject().getJavaCode();
                    }
                    String methodName = lastNode.substring(dotPos + 1).trim();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("try to find type for method " + methodName + ", code : " + code));
                    }
                    try {
                        MethodDescriptor method = contextClass.getMethodDescriptor(methodName, new ClassDescriptor[0]);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Will trackMemberIfPossible from method " + method.getName() + " with objectCode = " + code));
                        }
                        this.trackMemberIfPossible(code, contextClass, method.getName(), true);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("method found = " + method));
                        }
                        return method.getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        CompiledObject compiledObject;
                        MethodDescriptor newMethod;
                        if (this.showLog()) {
                            log.info((Object)("Could not find method " + methodName + ", code : " + code + " on : " + contextClass));
                            if (log.isDebugEnabled()) {
                                for (MethodDescriptor descriptor : contextClass.getMethodDescriptors()) {
                                    log.debug((Object)(" - " + Modifier.toString(descriptor.getModifiers()) + " " + descriptor.getName() + "(...) : " + descriptor.getReturnType()));
                                }
                            }
                        }
                        String propertyName = null;
                        if (methodName.startsWith("is")) {
                            propertyName = Introspector.decapitalize(methodName.substring("is".length()));
                        } else if (methodName.startsWith("get")) {
                            propertyName = Introspector.decapitalize(methodName.substring("get".length()));
                        }
                        if (propertyName == null || (newMethod = this.compiler.getScriptMethod(methodName)) == null) break block29;
                        String bindingId = this.compiler.getRootObject().getId() + "." + propertyName;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("detect a dependency [" + bindingId + "] from a script method " + newMethod.getName() + ", will try to add a listener in method is part of javaBean ..."));
                        }
                        if ((compiledObject = this.compiler.getObjects().get(propertyName)) != null && compiledObject.isJavaBean()) {
                            String objectCode = null;
                            if (this.showLog()) {
                                log.info((Object)("Detect a dependency from compiled object [" + objectCode + "]a script method '" + newMethod.getName() + "' which  reflect a javaBean property " + propertyName));
                                log.info((Object)("Try to add a listener [symbol:" + bindingId + ",objectCode:" + objectCode + "]"));
                                log.debug((Object)(">> lastnode = " + lastNode + "(), suffix = " + suffix.getText() + ", expression = " + expression.getText()));
                            }
                            this.addListener(bindingId, objectCode, "addPropertyChangeListener(\"" + propertyName + "\", this);" + JAXXCompiler.getLineSeparator(), "removePropertyChangeListener(\"" + propertyName + "\", this);" + JAXXCompiler.getLineSeparator());
                        }
                        contextClass = newMethod.getReturnType();
                    }
                }
            }
            if (!(lastNode = suffix.getText().trim()).startsWith(".")) continue;
            lastNode = lastNode.substring(1);
        }
        return null;
    }

    private ClassDescriptor determineLiteralType(SimpleNode node) {
        assert (node.getId() == 66);
        if (node.jjtGetNumChildren() == 1) {
            int childId = node.getChild(0).getId();
            if (childId == 67) {
                return ClassDescriptorHelper.getClassDescriptor(Boolean.TYPE);
            }
            if (childId == 68) {
                return ClassDescriptorHelper.getClassDescriptor(NULL.class);
            }
            throw new RuntimeException("Expected BooleanLiteral or NullLiteral, found " + JavaParserTreeConstants.jjtNodeName[childId]);
        }
        int nodeId = node.firstToken.kind;
        switch (nodeId) {
            case 61: {
                if (node.firstToken.image.toLowerCase().endsWith("l")) {
                    return ClassDescriptorHelper.getClassDescriptor(Long.TYPE);
                }
                return ClassDescriptorHelper.getClassDescriptor(Integer.TYPE);
            }
            case 70: {
                return ClassDescriptorHelper.getClassDescriptor(Character.TYPE);
            }
            case 65: {
                if (node.firstToken.image.toLowerCase().endsWith("f")) {
                    return ClassDescriptorHelper.getClassDescriptor(Float.TYPE);
                }
                return ClassDescriptorHelper.getClassDescriptor(Double.TYPE);
            }
            case 71: {
                return ClassDescriptorHelper.getClassDescriptor(String.class);
            }
        }
        throw new RuntimeException("Expected literal token, found " + JavaParserConstants.tokenImage[nodeId]);
    }

    private ClassDescriptor scanCompoundSymbol(String symbol, ClassDescriptor contextClass, boolean isMethod) {
        Object[] tokens = symbol.split("\\s*\\.\\s*");
        if (log.isDebugEnabled()) {
            log.debug((Object)("for symbol " + symbol + ", contextClass " + contextClass + ", isMethod " + isMethod));
            log.debug((Object)("tokens " + Arrays.toString(tokens)));
        }
        StringBuilder currentSymbol = new StringBuilder();
        StringBuilder tokensSeenSoFar = new StringBuilder();
        boolean recognizeClassNames = true;
        for (int j = 0; j < tokens.length - (isMethod ? 1 : 0); ++j) {
            boolean accepted;
            block20: {
                accepted = false;
                if (tokensSeenSoFar.length() > 0) {
                    tokensSeenSoFar.append('.');
                }
                tokensSeenSoFar.append((String)tokens[j]);
                if (currentSymbol.length() > 0) {
                    currentSymbol.append('.');
                }
                currentSymbol.append((String)tokens[j]);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("try to find type for " + currentSymbol));
                }
                if (currentSymbol.indexOf(".") == -1) {
                    String memberName = currentSymbol.toString();
                    CompiledObject object = this.compiler.getCompiledObject(memberName);
                    if (object != null) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("detected an object " + object));
                        }
                        contextClass = object.getObjectClass();
                        currentSymbol.setLength(0);
                        accepted = true;
                        recognizeClassNames = false;
                    } else {
                        try {
                            FieldDescriptor field = contextClass.getFieldDescriptor(memberName);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Will trackMemberIfPossible from field " + field.getName() + " with objectCode = " + tokensSeenSoFar.toString()));
                            }
                            this.trackMemberIfPossible(tokensSeenSoFar.toString(), contextClass, field.getName(), false);
                            try {
                                contextClass = field.getType();
                            }
                            catch (Exception e) {
                                log.warn((Object)("could not find type for field " + field));
                                throw new NoSuchFieldException(e.getMessage());
                            }
                            currentSymbol.setLength(0);
                            accepted = true;
                            recognizeClassNames = false;
                        }
                        catch (NoSuchFieldException e) {
                            FieldDescriptor newField;
                            if (j != 0 && (j != 1 || !((String)tokens[0]).equals(this.compiler.getRootObject().getId())) || (newField = this.compiler.getScriptField(memberName)) == null) break block20;
                            contextClass = newField.getType();
                            if (this.showLog()) {
                                log.info((Object)("Detect a dependency from a script field '" + newField + "'"));
                                log.info((Object)("Try to add a listenenr [symbol:" + tokensSeenSoFar.toString() + ",objectCode:" + null + "]"));
                            }
                            String eol = JAXXCompiler.getLineSeparator();
                            this.addListener(tokensSeenSoFar.toString(), null, "addPropertyChangeListener(\"" + memberName + "\", this);" + eol, "removePropertyChangeListener(\"" + memberName + "\", this);" + eol);
                            assert (contextClass != null) : "script field '" + memberName + "' is defined, but has type null";
                            currentSymbol.setLength(0);
                            accepted = true;
                            recognizeClassNames = false;
                        }
                    }
                }
            }
            if (currentSymbol.length() > 0 && recognizeClassNames) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try to recognizeClassNames for symbol " + currentSymbol));
                }
                if ((contextClass = TagManager.resolveClass(currentSymbol.toString(), this.compiler)) != null) {
                    currentSymbol.setLength(0);
                    return null;
                }
            }
            if (accepted) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("symbol " + symbol + " was not accepted."));
            }
            return null;
        }
        return contextClass;
    }

    private void trackMemberIfPossible(String objectCode, ClassDescriptor objectClass, String memberName, boolean method) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("for [objectCode:" + objectCode + ", objectClass:" + objectClass + ", memberName:" + memberName + ", isMethod:" + method));
        }
        DefaultObjectHandler handler = TagManager.getTagHandler(objectClass);
        try {
            if (handler.isMemberBound(memberName)) {
                String bindingId = objectCode + "." + memberName + (method ? "()" : "");
                if (this.showLog()) {
                    log.info((Object)("Detect a dependency from a event handler for memberName '" + memberName + "' for class " + objectClass));
                    log.info((Object)("Try to add a listenenr [symbol:" + bindingId + ", objectCode:" + objectCode + "]"));
                }
                this.addListener(bindingId, objectCode, this.getAddMemberListenerCode(handler, objectCode, memberName, "this", this.compiler), this.getRemoveMemberListenerCode(handler, objectCode, memberName, "this", this.compiler));
            }
        }
        catch (UnsupportedAttributeException e) {
            // empty catch block
        }
    }

    private void addListener(String dependencySymbol, String objectCode, String addCode, String removeCode) {
        boolean needTest;
        if (objectCode != null) {
            objectCode = objectCode.trim();
        }
        boolean bl = needTest = objectCode != null && !this.compiler.getRootObject().getId().equals(objectCode);
        if (!needTest) {
            objectCode = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("try to add listener [dependencySymbol:" + dependencySymbol + ", objectCode:" + objectCode + ", addCode:" + addCode + "]"));
        }
        for (DataListener tracker : this.trackers) {
            if (!dependencySymbol.equals(tracker.getSymbol())) continue;
            return;
        }
        DataListener tracker = new DataListener(dependencySymbol, objectCode, addCode, removeCode);
        if (log.isDebugEnabled()) {
            log.debug((Object)("add tracker " + tracker));
        }
        this.trackers.add(tracker);
    }

    public boolean hasMethod(String methodName) {
        for (JavaMethod method : this.methods) {
            if (!methodName.equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    public String getAddMemberListenerCode(DefaultObjectHandler handler, String objectCode, String memberName, String propertyChangeListenerCode, JAXXCompiler compiler) {
        if ("getClass".equals(memberName)) {
            return null;
        }
        DefaultObjectHandler.ProxyEventInfo eventInfo = handler.getEventInfo(memberName);
        if (eventInfo != null) {
            String code;
            StringBuilder result = new StringBuilder();
            String methodName = "$pr" + compiler.getUniqueId(propertyChangeListenerCode.equals("this") ? this.constantId : propertyChangeListenerCode);
            boolean methodExists = this.hasMethod(methodName);
            ClassDescriptor eventClass = DefaultObjectHandler.getEventClass(eventInfo.getListenerClass());
            String type = compiler.getImportedType(JAXXCompiler.getCanonicalName(eventClass));
            if (!methodExists) {
                code = JavaFileGenerator.addDebugLoggerInvocation(compiler, "event");
                code = code + "propertyChange(null);";
                JavaMethod method = JavaElementFactory.newMethod(1, "void", methodName, code, false, JavaElementFactory.newArgument(type, "event"));
                this.methods.add(method);
            }
            code = objectCode + (eventInfo.getModelName() != null ? ".get" + StringUtils.capitalize((String)eventInfo.getModelName()) + "()" : "");
            result.append("$bindingSources.put(\"").append(code).append("\", ").append(code).append(");").append(JAXXCompiler.getLineSeparator());
            ClassDescriptor listenerClass = eventInfo.getListenerClass();
            String listenerType = compiler.getImportedType(listenerClass.getName());
            String jaxxUtilPrefix = compiler.getImportedType(JAXXUtil.class);
            result.append(code);
            result.append('.');
            result.append(eventInfo.getAddMethod());
            result.append("( ").append(jaxxUtilPrefix).append(".getEventListener(");
            result.append(listenerType);
            result.append(".class, ");
            result.append("this");
            result.append(", ");
            result.append(TypeManager.getJavaCode(methodName));
            result.append("));");
            result.append(JAXXCompiler.getLineSeparator());
            if (eventInfo.getModelName() != null) {
                String addCode = this.getAddMemberListenerCode(handler, objectCode, "get" + StringUtils.capitalize((String)eventInfo.getModelName()), jaxxUtilPrefix + ".getDataBindingUpdateListener(" + compiler.getOutputClassName() + ".this" + ", " + this.constantId + ")", compiler);
                result.append(addCode);
            }
            return result.toString();
        }
        String propertyName = null;
        if (memberName.startsWith("get")) {
            propertyName = Introspector.decapitalize(memberName.substring(3));
        } else if (memberName.startsWith("is")) {
            propertyName = Introspector.decapitalize(memberName.substring(2));
        } else {
            try {
                handler.getBeanClass().getFieldDescriptor(memberName);
                propertyName = memberName;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        if (propertyName != null) {
            String prefix = objectCode.trim() + ".";
            if (objectCode.equals(compiler.getRootObject().getJavaCode())) {
                prefix = "";
            }
            return prefix + "addPropertyChangeListener(\"" + propertyName + "\", " + propertyChangeListenerCode + ");\n";
        }
        return null;
    }

    public String getRemoveMemberListenerCode(DefaultObjectHandler handler, String objectCode, String memberName, String propertyChangeListenerCode, JAXXCompiler compiler) {
        if ("getClass".equals(memberName)) {
            return null;
        }
        DefaultObjectHandler.ProxyEventInfo eventInfo = handler.getEventInfo(memberName);
        if (eventInfo != null) {
            StringBuilder result = new StringBuilder();
            String methodName = "$pr" + compiler.getUniqueId(propertyChangeListenerCode.equals("this") ? this.constantId : propertyChangeListenerCode);
            boolean methodExists = this.hasMethod(methodName);
            if (!methodExists) {
                ClassDescriptor eventClass = DefaultObjectHandler.getEventClass(eventInfo.getListenerClass());
                String type = compiler.getImportedType(JAXXCompiler.getCanonicalName(eventClass));
                String code = JavaFileGenerator.addDebugLoggerInvocation(compiler, "event");
                code = code + "propertyChange(null);";
                JavaMethod method = JavaElementFactory.newMethod(1, "void", methodName, code, false, JavaElementFactory.newArgument(type, "event"));
                this.methods.add(method);
            }
            try {
                String modelMemberName = eventInfo.getModelName() != null ? "get" + StringUtils.capitalize((String)eventInfo.getModelName()) : null;
                String modelClassName = modelMemberName != null ? handler.getBeanClass().getMethodDescriptor(modelMemberName, new ClassDescriptor[0]).getReturnType().getName() : JAXXCompiler.getCanonicalName(handler.getBeanClass());
                String modelType = compiler.getImportedType(modelClassName);
                String code = objectCode + (eventInfo.getModelName() != null ? "." + modelMemberName + "()" : "");
                String eol = JAXXCompiler.getLineSeparator();
                String jaxxUtilPrefix = compiler.getImportedType(JAXXUtil.class);
                result.append(modelType).append(" $target = (").append(modelType).append(") $bindingSources.remove(\"").append(code).append("\");").append(eol);
                result.append("if ($target != null) {").append(eol);
                ClassDescriptor listenerClass = eventInfo.getListenerClass();
                String listenerType = compiler.getImportedType(listenerClass.getName());
                result.append("    $target.");
                result.append(eventInfo.getRemoveMethod());
                result.append("( ").append(jaxxUtilPrefix).append(".getEventListener(");
                result.append(listenerType);
                result.append(".class, ");
                result.append("this");
                result.append(", ");
                result.append(TypeManager.getJavaCode(methodName));
                result.append("));");
                result.append(eol);
                result.append("}").append(eol);
                if (eventInfo.getModelName() != null) {
                    result.append(this.getRemoveMemberListenerCode(handler, objectCode, "get" + StringUtils.capitalize((String)eventInfo.getModelName()), jaxxUtilPrefix + ".getDataBindingUpdateListener(" + compiler.getOutputClassName() + ".this, " + this.constantId + ")", compiler));
                }
                return result.toString();
            }
            catch (NoSuchMethodException e) {
                throw new CompilerException("Internal error: " + e);
            }
        }
        String propertyName = null;
        if (memberName.startsWith("get")) {
            propertyName = Introspector.decapitalize(memberName.substring("get".length()));
        } else if (memberName.startsWith("is")) {
            propertyName = Introspector.decapitalize(memberName.substring("is".length()));
        } else {
            try {
                handler.getBeanClass().getFieldDescriptor(memberName);
                propertyName = memberName;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        if (propertyName == null) {
            return null;
        }
        String prefix = objectCode.trim() + ".";
        if (objectCode.equals(compiler.getRootObject().getJavaCode())) {
            prefix = "";
        }
        return prefix + "removePropertyChangeListener(\"" + propertyName + "\", " + propertyChangeListenerCode + ");\n";
    }

    private class NULL {
        private NULL() {
        }
    }
}

