/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: BoxedCompiledObjectDecorator.java 2118 2010-10-26 17:44:57Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.5/jaxx-compiler/src/main/java/jaxx/compiler/decorators/BoxedCompiledObjectDecorator.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.decorators;

import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObject.ChildRef;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.java.JavaFile;
import jaxx.runtime.SwingUtil;

/**
 * A decorator to surround a compiled object (should be a component at least)
 * with a JXLayer.
 *
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role-hint="boxed" role="jaxx.compiler.CompiledObjectDecorator"
 * @since 1.2
 */
public class BoxedCompiledObjectDecorator extends DefaultCompiledObjectDecorator {

    @Override
    public String getName() {
        return "boxed";
    }

    @Override
    public void finalizeCompiler(JAXXCompiler compiler,
                                 CompiledObject root,
                                 CompiledObject object,
                                 JavaFile javaFile,
                                 String packageName,
                                 String className,
                                 String fullClassName) {
        CompiledObject parent = object.getParent();
        if (parent == null) {
            parent = root;
        }
        for (ChildRef child : parent.getChilds()) {
            if (child.getChild() == object) {
                String javaCode = child.getChildJavaCode();
                child.setChildJavaCode(
                        SwingUtil.class.getSimpleName() +
                        ".boxComponentWithJxLayer(" + javaCode + ")");
                break;
            }
        }
        super.finalizeCompiler(compiler,
                               root,
                               object,
                               javaFile,
                               packageName,
                               className,
                               fullClassName
        );
    }
}
