/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: JJTCSSParserState.java 2118 2010-10-26 17:44:57Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.4/jaxx-compiler/src/main/java/jaxx/compiler/css/parser/JJTCSSParserState.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
/* Generated By:JJTree: Do not edit this line. .\JJTCSSParserState.java */


package jaxx.compiler.css.parser;

class JJTCSSParserState {
    private java.util.Stack<Node> nodes;
    private java.util.Stack<Integer> marks;

    private int sp;        // number of nodes on stack
    private int mk;        // current mark
    private boolean node_created;

    JJTCSSParserState() {
        nodes = new java.util.Stack<Node>();
        marks = new java.util.Stack<Integer>();
        sp = 0;
        mk = 0;
    }

    /* Determines whether the current node was actually closed and
 pushed.  This should only be called in the final user action of a
 node scope.  */
    boolean nodeCreated() {
        return node_created;
    }

    /* Call this to reinitialize the node stack.  It is called
automatically by the parser's ReInit() method. */
    void reset() {
        nodes.removeAllElements();
        marks.removeAllElements();
        sp = 0;
        mk = 0;
    }

    /* Returns the root node of the AST.  It only makes sense to call
this after a successful parse. */
    Node rootNode() {
        return nodes.elementAt(0);
    }

    /* Pushes a node on to the stack. */
    void pushNode(Node n) {
        nodes.push(n);
        ++sp;
    }

    /* Returns the node on the top of the stack, and remove it from the
  stack.  */
    Node popNode() {
        if (--sp < mk) {
            mk = marks.pop();
        }
        return nodes.pop();
    }

    /* Returns the node currently on the top of the stack. */
    Node peekNode() {
        return nodes.peek();
    }

    /* Returns the number of children on the stack in the current node
   scope. */
    int nodeArity() {
        return sp - mk;
    }


    void clearNodeScope(Node n) {
        while (sp > mk) {
            popNode();
        }
        mk = marks.pop();
    }


    void openNodeScope(Node n) {
        marks.push(mk);
        mk = sp;
        n.jjtOpen();
    }


    /* A definite node is constructed from a specified number of
children.  That number of nodes are popped from the stack and
made the children of the definite node.  Then the definite node
is pushed on to the stack. */
    void closeNodeScope(Node n, int num) {
        mk = marks.pop();
        while (num-- > 0) {
            Node c = popNode();
            c.jjtSetParent(n);
            n.jjtAddChild(c, num);
        }
        n.jjtClose();
        pushNode(n);
        node_created = true;
    }


    /* A conditional node is constructed if its condition is true.  All
the nodes that have been pushed since the node was opened are
made children of the the conditional node, which is then pushed
on to the stack.  If the condition is false the node is not
constructed and they are left on the stack. */
    void closeNodeScope(Node n, boolean condition) {
        if (condition) {
            int a = nodeArity();
            mk = marks.pop();
            while (a-- > 0) {
                Node c = popNode();
                c.jjtSetParent(n);
                n.jjtAddChild(c, a);
            }
            n.jjtClose();
            pushNode(n);
            node_created = true;
        } else {
            mk = marks.pop();
            node_created = false;
        }
    }
}
