/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.JAXXFactory;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorResolver;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.compiler.reflect.resolvers.ClassDescriptorResolverFromJavaClass;
import jaxx.compiler.reflect.resolvers.ClassDescriptorResolverFromJavaFile;
import jaxx.compiler.reflect.resolvers.ClassDescriptorResolverFromJaxxFile;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassDescriptorHelper {
    private static final Log log = LogFactory.getLog(ClassDescriptorHelper.class);
    private static boolean SHOW_LOADING = log.isDebugEnabled();
    private static Map<String, ClassDescriptor> descriptors = new HashMap<String, ClassDescriptor>();
    private static Map<String, ClassDescriptorResolver> descriptorResolvers;

    protected static Map<String, ClassDescriptorResolver> getDescriptorResolvers() {
        if (descriptorResolvers == null) {
            descriptorResolvers = new TreeMap<String, ClassDescriptorResolver>();
            descriptorResolvers.put(ClassDescriptorResolverFromJaxxFile.class.getSimpleName(), new ClassDescriptorResolverFromJaxxFile());
            descriptorResolvers.put(ClassDescriptorResolverFromJavaFile.class.getSimpleName(), new ClassDescriptorResolverFromJavaFile());
            descriptorResolvers.put(ClassDescriptorResolverFromJavaClass.class.getSimpleName(), new ClassDescriptorResolverFromJavaClass());
        }
        return descriptorResolvers;
    }

    private ClassDescriptorHelper() {
    }

    public static ClassDescriptor getClassDescriptor(String className) throws ClassNotFoundException {
        ClassDescriptor descriptor = ClassDescriptorHelper.getClassDescriptor(className, Thread.currentThread().getContextClassLoader());
        return descriptor;
    }

    public static ClassDescriptor getClassDescriptor(Class<?> javaClass) {
        try {
            return ClassDescriptorHelper.getClassDescriptor(javaClass.getName(), javaClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getURL(ClassLoader classLoader, String className, String clasifier) {
        String relativePath = className.replaceAll("\\.", "/");
        String path = relativePath + "." + clasifier;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Path to search : " + path));
        }
        URL url = classLoader.getResource(path);
        return url;
    }

    public static ClassDescriptor getClassDescriptor(String className, ClassLoader classLoader) throws ClassNotFoundException {
        JAXXCompilerFile file;
        ClassDescriptor result;
        if (classLoader == null) {
            classLoader = ClassDescriptorHelper.class.getClassLoader();
        }
        if ((result = descriptors.get(className)) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved " + result + " from cache."));
            }
            return result;
        }
        JAXXEngine engine = JAXXFactory.isEngineRegistred() ? JAXXFactory.getEngine() : null;
        String relativePathPattern = ".*";
        if (engine != null && (file = engine.getJAXXCompilerFile(className)) != null) {
            if (SHOW_LOADING) {
                log.info((Object)("from JAXXFile " + file.getJaxxFile()));
            }
            result = ClassDescriptorHelper.getClassDescriptor0(ClassDescriptorResolverFromJaxxFile.class, className, file.getJAXXFileURL(), classLoader);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + className + "] loaded"));
            }
            return result;
        }
        long javaLastModified = -1L;
        URL javaFile = ClassDescriptorHelper.getURL(classLoader, className, "java");
        if (javaFile != null && javaFile.toString().startsWith("file:") && javaFile.toString().matches(relativePathPattern)) {
            javaLastModified = JAXXCompiler.URLtoFile(javaFile).lastModified();
            if (log.isTraceEnabled()) {
                log.trace((Object)("[" + className + "] javaFile lastModified " + javaLastModified));
            }
        }
        long classLastModified = -1L;
        URL classFile = ClassDescriptorHelper.getURL(classLoader, className, "class");
        if (classFile != null && classFile.toString().startsWith("file:") && classFile.toString().matches(relativePathPattern)) {
            classLastModified = JAXXCompiler.URLtoFile(classFile).lastModified();
            if (log.isTraceEnabled()) {
                log.trace((Object)("[" + className + "] class lastModified " + classLastModified));
            }
        }
        if (javaLastModified != -1L && javaLastModified > classLastModified) {
            if (SHOW_LOADING) {
                log.info((Object)("from JavaFile " + javaFile));
            }
            result = ClassDescriptorHelper.getClassDescriptor0(ClassDescriptorResolverFromJavaFile.class, className, javaFile, classLoader);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + className + "] loaded"));
            }
            return result;
        }
        if (SHOW_LOADING) {
            log.info((Object)("from class " + className));
        }
        result = ClassDescriptorHelper.getClassDescriptor0(ClassDescriptorResolverFromJavaClass.class, className, classFile, classLoader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + className + "] loaded"));
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("Can not find descriptor for " + className);
    }

    protected static ClassDescriptor getClassDescriptor0(Class<? extends ClassDescriptorResolver> resolverType, String className, URL source, ClassLoader classLoader) throws ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading class descriptor for [" + className + "] with " + resolverType.getSimpleName()));
        }
        Map<String, ClassDescriptorResolver> resolvers = ClassDescriptorHelper.getDescriptorResolvers();
        ClassDescriptorResolver resolver = resolvers.get(resolverType.getSimpleName());
        resolver.setClassLoader(classLoader);
        ClassDescriptor result = resolver.resolvDescriptor(className, source);
        if (result != null) {
            descriptors.put(className, result);
        }
        return result;
    }

    public static Class<?> getPrimitiveBoxedClass(String className) {
        if (className.equals("boolean")) {
            return Boolean.class;
        }
        if (className.equals("byte")) {
            return Byte.class;
        }
        if (className.equals("short")) {
            return Short.class;
        }
        if (className.equals("int")) {
            return Integer.class;
        }
        if (className.equals("long")) {
            return Long.class;
        }
        if (className.equals("float")) {
            return Float.class;
        }
        if (className.equals("double")) {
            return Double.class;
        }
        if (className.equals("char")) {
            return Character.class;
        }
        if (className.equals("void")) {
            return Void.class;
        }
        return null;
    }

    public static Class<?> getPrimitiveClass(String className) throws ClassNotFoundException {
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("void")) {
            return Void.TYPE;
        }
        int arrayCount = 0;
        while (className.endsWith("[]")) {
            ++arrayCount;
            className = className.substring(0, className.length() - 2);
        }
        if (arrayCount > 0) {
            Class<?> klass = ClassDescriptorHelper.getPrimitiveClass(className);
            if (klass == null) {
                return null;
            }
            klass = ClassDescriptorHelper.getPrimitiveBoxedClass(className);
            className = klass.getName();
            className = "L" + className + ";";
            while (arrayCount > 0) {
                className = "[" + className;
                --arrayCount;
            }
            return Class.forName(className);
        }
        return null;
    }

    public static Class<?> getClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> klass = ClassDescriptorHelper.getPrimitiveClass(className);
        if (klass != null) {
            return klass;
        }
        int arrayCount = 0;
        while (className.endsWith("[]")) {
            ++arrayCount;
            className = className.substring(0, className.length() - 2);
        }
        if (arrayCount > 0) {
            className = "L" + className + ";";
            while (arrayCount > 0) {
                className = "[" + className;
                --arrayCount;
            }
        }
        try {
            return classLoader != null ? Class.forName(className, true, classLoader) : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            int dotIndex = className.lastIndexOf(".");
            if (dotIndex > -1) {
                String parentFQN = className.substring(0, dotIndex);
                String simpleName = className.substring(dotIndex + 1);
                try {
                    Class<?> parentClass = classLoader != null ? Class.forName(parentFQN, true, classLoader) : Class.forName(parentFQN);
                    for (Class<?> innerClass : parentClass.getClasses()) {
                        if (!simpleName.equals(innerClass.getSimpleName())) continue;
                        return innerClass;
                    }
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    public static void checkSupportClass(Class<?> handlerClass, ClassDescriptor beanClass, Class<?> ... tagClasses) {
        for (Class<?> tagClass : tagClasses) {
            if (!ClassDescriptorHelper.getClassDescriptor(tagClass).isAssignableFrom(beanClass)) continue;
            return;
        }
        throw new IllegalArgumentException(handlerClass.getName() + " does not support the class " + beanClass.getName());
    }

    public static void reset() {
        descriptors.clear();
    }

    public static MethodDescriptor createMethodDescriptor(Method javaMethod, ClassLoader classLoader) {
        String methodName = javaMethod.getName();
        int modifiers = javaMethod.getModifiers();
        String returnType = javaMethod.getReturnType().getName();
        Class<?>[] javaParameters = javaMethod.getParameterTypes();
        String[] parameters = new String[javaParameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = javaParameters[i].getName();
        }
        return new MethodDescriptor(methodName, modifiers, returnType, parameters, classLoader);
    }

    public static FieldDescriptor createFieldDescriptor(Field javaField, ClassLoader classLoader) {
        String fieldName = javaField.getName();
        int modifiers = javaField.getModifiers();
        String type = javaField.getType().getName();
        return new FieldDescriptor(fieldName, modifiers, type, classLoader);
    }

    public static JAXXObjectDescriptor getJAXXObjectDescriptor(Class<?> jaxxClass) {
        if (!JAXXObject.class.isAssignableFrom(jaxxClass) || JAXXObject.class.equals(jaxxClass)) {
            return null;
        }
        try {
            Method getJAXXObjectDescriptor = jaxxClass.getMethod("$getJAXXObjectDescriptor", new Class[0]);
            return (JAXXObjectDescriptor)getJAXXObjectDescriptor.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CompilerException("Expected JAXXObject " + jaxxClass.getName() + " to have a static method named $getJAXXObjectDescriptor");
        }
        catch (IllegalAccessException e) {
            throw new CompilerException("Expected JAXXObject " + jaxxClass.getName() + "'s $getJAXXObjectDescriptor method to be public");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

