/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.swing;

import javax.swing.JSplitPane;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.DefaultComponentHandler;

public class JSplitPaneHandler
extends DefaultComponentHandler {
    public static final String ATTRIBUTE_ORIENTATION = "orientation";
    public static final String ORIENTATION_VALUE_HORIZONTAL = "horizontal";
    public static final String ORIENTATION_VALUE_VERTICAL = "vertical";
    public static final String ORIENTATION_VALUE_VERTICAL_SPLIT = "vertical_split";
    public static final String ORIENTATION_VALUE_HORIZONTAL_SPLIT = "horizontal_split";

    public JSplitPaneHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(this.getClass(), beanClass, JSplitPane.class);
    }

    @Override
    protected int constantValue(String key, String value) {
        if (key.equals(ATTRIBUTE_ORIENTATION)) {
            if ((value = value.trim().toLowerCase()).equals(ORIENTATION_VALUE_HORIZONTAL) || value.equals(ORIENTATION_VALUE_HORIZONTAL_SPLIT)) {
                return 1;
            }
            if (value.equals(ORIENTATION_VALUE_VERTICAL) || value.equals(ORIENTATION_VALUE_VERTICAL_SPLIT)) {
                return 0;
            }
            throw new IllegalArgumentException("orientation must be 'horizontal' or 'vertical', found '" + value + "'");
        }
        return super.constantValue(key, value);
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledObject(id, this.getBeanClass(), compiler){
            private int count;

            @Override
            public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
                if (constraints != null) {
                    compiler.reportError("JSplitPane does not accept constraints");
                }
                if (this.count == 0) {
                    super.addChild(child, "JSplitPane.LEFT", compiler);
                } else if (this.count == 1) {
                    super.addChild(child, "JSplitPane.RIGHT", compiler);
                } else {
                    compiler.reportError("JSplitPane is limited to two children");
                }
                ++this.count;
            }
        };
    }
}

