/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tasks;

import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.tasks.JAXXEngineTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenerateTask
extends JAXXEngineTask {
    private static final Log log = LogFactory.getLog(GenerateTask.class);
    private static final long serialVersionUID = -1L;
    public static final String TASK_NAME = "Generate";

    public GenerateTask() {
        super(TASK_NAME);
    }

    @Override
    public boolean perform(JAXXEngine engine) throws Exception {
        boolean success = true;
        boolean verbose = engine.isVerbose();
        JavaFileGenerator generator = new JavaFileGenerator(JAXXCompiler.getLineSeparator(), verbose);
        for (JAXXCompilerFile jaxxFile : engine.getCompilingFiles()) {
            if (verbose) {
                log.info((Object)(this.getName() + " for " + jaxxFile.getClassName()));
            }
            JAXXCompiler compiler = this.getSafeCompiler(jaxxFile);
            this.addStartProfileTime(engine, compiler);
            compiler.generate(generator);
            this.addEndProfileTime(engine, compiler);
            if (!compiler.isFailed()) continue;
            success = false;
        }
        return success;
    }
}

