/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.reflect.resolvers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.reflect.ClassDescriptorResolver;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.runtime.JAXXObjectDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassDescriptorResolverFromJavaClass
extends ClassDescriptorResolver {
    private static final Log log = LogFactory.getLog(ClassDescriptorResolverFromJavaClass.class);

    @Override
    public ClassDescriptor resolvDescriptor(String className, URL source) throws ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("for source " + className));
        }
        Class<?> javaClass = ClassDescriptorHelper.getClass(className, this.getClassLoader());
        String name = javaClass.getName();
        Package p = javaClass.getPackage();
        String packageName = p != null ? p.getName() : null;
        Class<?> superclass = javaClass.getSuperclass();
        String superclassName = superclass != null ? superclass.getName() : null;
        Class<?>[] interfaces = javaClass.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = interfaces[i].getName();
        }
        boolean isInterface = javaClass.isInterface();
        boolean isArray = javaClass.isArray();
        String componentTypeName = isArray ? javaClass.getComponentType().getName() : null;
        ClassLoader classLoader = javaClass.getClassLoader();
        Method[] javaMethods = javaClass.getMethods();
        MethodDescriptor[] methods = new MethodDescriptor[javaMethods.length];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = ClassDescriptorHelper.createMethodDescriptor(javaMethods[i], javaClass.getClassLoader());
        }
        Field[] javaFields = javaClass.getFields();
        FieldDescriptor[] fields = new FieldDescriptor[javaFields.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = ClassDescriptorHelper.createFieldDescriptor(javaFields[i], javaClass.getClassLoader());
        }
        JAXXObjectDescriptor jaxxObjectDescriptor = ClassDescriptorHelper.getJAXXObjectDescriptor(javaClass);
        return new JavaClassClassDescriptor(javaClass, name, packageName, superclassName, interfaceNames, isInterface, isArray, componentTypeName, jaxxObjectDescriptor, classLoader, methods, fields);
    }

    private static class JavaClassClassDescriptor
    extends ClassDescriptor {
        private final Class<?> javaClass;

        public JavaClassClassDescriptor(Class<?> javaClass, String name, String packageName, String superclassName, String[] interfaceNames, boolean anInterface, boolean array, String componentTypeName, JAXXObjectDescriptor jaxxObjectDescriptor, ClassLoader classLoader, MethodDescriptor[] methods, FieldDescriptor[] fields) {
            super(name, packageName, superclassName, interfaceNames, anInterface, array, componentTypeName, jaxxObjectDescriptor, classLoader, methods, fields);
            this.javaClass = javaClass;
        }

        @Override
        public FieldDescriptor getDeclaredFieldDescriptor(String name) throws NoSuchFieldException {
            return ClassDescriptorHelper.createFieldDescriptor(this.javaClass.getDeclaredField(name), this.javaClass.getClassLoader());
        }

        @Override
        public MethodDescriptor getDeclaredMethodDescriptor(String name, ClassDescriptor ... parameterTypes) throws NoSuchMethodException {
            try {
                Class[] parameterTypeClasses = new Class[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameterTypeClasses[i] = Class.forName(parameterTypes[i].getName());
                }
                return ClassDescriptorHelper.createMethodDescriptor(this.javaClass.getDeclaredMethod(name, parameterTypeClasses), this.javaClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

