/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.CompilerException;
import jaxx.compiler.DefaultCompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFile;
import jaxx.compiler.JAXXProfile;
import jaxx.compiler.SymbolTable;
import jaxx.compiler.tasks.CompileFirstPassTask;
import jaxx.compiler.tasks.CompileSecondPassTask;
import jaxx.compiler.tasks.FinalizeTask;
import jaxx.compiler.tasks.GenerateTask;
import jaxx.compiler.tasks.InitTask;
import jaxx.compiler.tasks.JAXXEngineTask;
import jaxx.compiler.tasks.ProfileTask;
import jaxx.compiler.tasks.StyleSheetTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

public class JAXXEngine {
    private static final Log log = LogFactory.getLog(JAXXEngine.class);
    protected final CompilerConfiguration configuration;
    protected final JAXXCompilerFile[] incomingFiles;
    protected final List<JAXXCompilerFile> compilingFiles;
    protected final List<String> warnings;
    protected final List<String> errors;
    protected JAXXEngineTask[] tasks;
    protected JAXXEngineTask currentTask;
    protected JAXXProfile profiler;

    protected JAXXEngine(CompilerConfiguration configuration, File base, String ... relativePaths) {
        if (configuration == null) {
            configuration = new DefaultCompilerConfiguration();
        }
        this.configuration = configuration;
        this.warnings = new ArrayList<String>();
        this.errors = new ArrayList<String>();
        this.compilingFiles = new ArrayList<JAXXCompilerFile>();
        for (String relativePath : relativePaths) {
            JAXXCompilerFile compilerFile = new JAXXCompilerFile(base, new File(base, relativePath));
            this.addFileToCompile(compilerFile);
        }
        this.incomingFiles = this.getCompilingFiles();
    }

    public JAXXEngineTask[] getTasks() {
        if (this.tasks == null) {
            ArrayList<JAXXEngineTask> tasks = new ArrayList<JAXXEngineTask>();
            tasks.add(new InitTask());
            tasks.add(new CompileFirstPassTask());
            tasks.add(new CompileSecondPassTask());
            tasks.add(new StyleSheetTask());
            tasks.add(new FinalizeTask());
            tasks.add(new GenerateTask());
            if (this.getConfiguration().isProfile()) {
                tasks.add(new ProfileTask());
            }
            this.tasks = tasks.toArray(new JAXXEngineTask[tasks.size()]);
        }
        return this.tasks;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public JAXXProfile getProfiler() {
        if (this.profiler == null && this.getConfiguration().isProfile()) {
            this.profiler = new JAXXProfile();
        }
        return this.profiler;
    }

    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    public JAXXCompilerFile[] getIncomingFiles() {
        return this.incomingFiles;
    }

    public JAXXCompilerFile[] getCompilingFiles() {
        return this.compilingFiles.toArray(new JAXXCompilerFile[this.compilingFiles.size()]);
    }

    public boolean containsJaxxFileClassName(String className) {
        for (JAXXCompilerFile file : this.getCompilingFiles()) {
            if (!className.equals(file.getClassName())) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstCompilePassTask() {
        return this.currentTask != null && "CompileFirstPass".equals(this.currentTask.getName());
    }

    protected void reset() {
        for (JAXXCompilerFile compilerFile : this.compilingFiles) {
            compilerFile.clear();
        }
        this.compilingFiles.clear();
        if (this.profiler != null) {
            this.profiler.clear();
            this.profiler = null;
        }
        this.clearReports();
    }

    public void clearReports() {
        this.getWarnings().clear();
        this.getErrors().clear();
    }

    public String getVersion() {
        return "2.0.2";
    }

    public JAXXCompilerFile getJAXXCompilerFile(String className) {
        for (JAXXCompilerFile compilingFile : this.compilingFiles) {
            if (!className.equals(compilingFile.getClassName())) continue;
            return compilingFile;
        }
        return null;
    }

    public JAXXCompiler getJAXXCompiler(String className) {
        JAXXCompilerFile compilerFile = this.getJAXXCompilerFile(className);
        if (compilerFile == null) {
            return null;
        }
        return compilerFile.getCompiler();
    }

    public SymbolTable getSymbolTable(String className) {
        JAXXCompiler compiler = this.getJAXXCompiler(className);
        if (compiler == null) {
            return null;
        }
        return compiler.getSymbolTable();
    }

    public CompiledObjectDecorator getDecorator(String name) throws IllegalArgumentException {
        Map<String, CompiledObjectDecorator> decorators = this.getConfiguration().getDecorators();
        CompiledObjectDecorator decorator = decorators.get(name);
        if (decorator == null) {
            throw new IllegalArgumentException("could not find decorator with key " + name + " (known decorators : " + decorators.keySet() + ")");
        }
        return decorator;
    }

    public CompiledObjectDecorator getDecorator(Class<?> type) {
        Map<String, CompiledObjectDecorator> decorators = this.getConfiguration().getDecorators();
        for (CompiledObjectDecorator decorator : decorators.values()) {
            if (!decorator.getClass().equals(type)) continue;
            return decorator;
        }
        return null;
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        try {
            boolean success = true;
            for (JAXXEngineTask task : this.getTasks()) {
                if (!success) break;
                this.currentTask = task;
                long t0 = System.nanoTime();
                if (this.isVerbose()) {
                    log.info((Object)("Start task '" + task.getName() + "' on " + this.compilingFiles.size() + " file(s)"));
                }
                success = task.perform(this);
                if (!this.isVerbose()) continue;
                log.info((Object)("task '" + task.getName() + "' done in " + StringUtil.convertTime((long)(System.nanoTime() - t0))));
            }
            int n = success ? this.compilingFiles.size() : -1;
            return n;
        }
        catch (CompilerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            int n = -1;
            return n;
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            int n = -1;
            return n;
        }
        finally {
            if (this.configuration.isResetAfterCompile() && this.errors.isEmpty()) {
                this.reset();
            }
        }
    }

    public void addFileToCompile(JAXXCompilerFile file) {
        if (this.isVerbose()) {
            log.info((Object)("register jaxx file " + file.getJaxxFile()));
        }
        this.compilingFiles.add(file);
    }

    public void addFileToCompile(File jaxxFile, String jaxxClassName) {
        if (this.isVerbose()) {
            log.info((Object)("file = " + jaxxFile + ", fqn = " + jaxxClassName));
        }
        JAXXCompilerFile file = new JAXXCompilerFile(jaxxFile, jaxxClassName);
        this.addFileToCompile(file);
    }

    public JAXXCompiler newCompiler(JAXXCompilerFile jaxxFile) throws Exception {
        Class<? extends JAXXCompiler> compilerClass = this.getConfiguration().getCompilerClass();
        if (compilerClass == null) {
            throw new NullPointerException("Configuration compilerClass is null");
        }
        Constructor<? extends JAXXCompiler> cons = compilerClass.getConstructor(JAXXEngine.class, JAXXCompilerFile.class, List.class);
        JAXXCompiler jaxxCompiler = cons.newInstance(this, jaxxFile, Arrays.asList("java.awt.*", "java.awt.event.*", "java.io.*", "java.lang.*", "java.util.*", "javax.swing.*", "javax.swing.border.*", "javax.swing.event.*", "jaxx.runtime.*", "jaxx.runtime.swing.*", "static org.nuiton.i18n.I18n._", "static jaxx.runtime.SwingUtil.createImageIcon"));
        jaxxFile.setCompiler(jaxxCompiler);
        return jaxxCompiler;
    }

    public boolean isVerbose() {
        return this.getConfiguration().isVerbose();
    }

    public void addProfileTime(JAXXCompiler compiler, String key) {
        JAXXProfile profiler = this.getProfiler();
        if (profiler != null) {
            profiler.addTime(compiler, key);
        }
    }
}

