package jaxx.compiler.binding;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * Created: 5 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 1679 $
 *          <p/>
 *          Mise a jour: $Date: 2009-12-08 18:21:03 +0100 (mar., 08 déc. 2009) $ par :
 *          $Author: tchemit $
 */
public class DataListener {

    /**
     * Unique id of the data listener (should be something like objectId.propertyName
     */
    protected final String symbol;
    /**
     * the nullity test to do before to add or remove the listener
     */
    protected final String objectCode;
    /**
     * code of the add listener
     */
    protected final String addListenerCode;
    /**
     * code of the remove listener
     */
    protected final String removeListenerCode;

    public DataListener(String symbol, String objectCode, String addListenerCode, String removeListenerCode) {
        this.symbol = symbol;
        this.objectCode = objectCode;
        this.addListenerCode = addListenerCode;
        this.removeListenerCode = removeListenerCode;
    }

    public String getSymbol() {
        return symbol;
    }

    public String getObjectCode() {
        return objectCode;
    }

    public String getAddListenerCode() {
        return addListenerCode;
    }

    public String getRemoveListenerCode() {
        return removeListenerCode;
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE);
        b.append("symbol", symbol);
        b.append("objectCode", objectCode);
        b.append("addListenerCode", addListenerCode.trim());
        b.append("removeListenerCode", removeListenerCode.trim());
        return b.toString();
    }
}
