/*
 * Decompiled with CFR 0.152.
 */
package jaxx.tools.jaxxcapture.handlers;

import java.awt.Container;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Stack;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JavaFile;
import jaxx.tools.jaxxcapture.CapturedObject;
import jaxx.tools.jaxxcapture.ContextNode;
import jaxx.tools.jaxxcapture.JAXXCapture;
import jaxx.tools.jaxxcapture.LiteralNode;
import jaxx.tools.jaxxcapture.MethodNode;
import jaxx.tools.jaxxcapture.PropertyNode;
import jaxx.tools.jaxxcapture.ValueNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectHandler {
    private static int count;

    protected CapturedObject createCapturedObject(String className, JAXXCapture capture) {
        return new CapturedObject(this, className, capture);
    }

    protected boolean processChildren(Element tag, Stack<ContextNode> context, JAXXCapture capture) {
        boolean result = false;
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element innerTag = (Element)child;
            if (innerTag.getTagName().equals("void")) {
                result = true;
            }
            this.evaluate(innerTag, context, capture);
        }
        return result;
    }

    protected void evaluateProperty(Element tag, Stack<ContextNode> context, JAXXCapture capture) {
        CapturedObject contextObject = null;
        for (int i = context.size() - 1; i >= 0; --i) {
            if (!(context.get(i) instanceof CapturedObject)) continue;
            contextObject = (CapturedObject)context.get(i);
            break;
        }
        assert (contextObject != null);
        String property = tag.getAttribute("property");
        if (!property.equals("actionCommand")) {
            ContextNode current = context.peek();
            PropertyNode newContext = new PropertyNode(property);
            context.push(newContext);
            boolean voidChildren = this.processChildren(tag, context, capture);
            ContextNode[] arguments = newContext.getArguments();
            if (arguments.length == 1) {
                if (current instanceof CapturedObject && arguments[0] instanceof ValueNode) {
                    ((CapturedObject)current).setProperty(property, ObjectHandler.dataBindingEncode(String.valueOf(((ValueNode)arguments[0]).getValue())));
                } else if (current instanceof CapturedObject && arguments[0] instanceof CapturedObject && ((CapturedObject)arguments[0]).isInlineable()) {
                    ((CapturedObject)current).setProperty(property, "{" + capture.getJavaCode(arguments[0]) + "}");
                } else {
                    contextObject.setInlineable(false);
                    contextObject.appendScriptCode(capture.getJavaCode(context));
                }
            } else if (!voidChildren) {
                contextObject.setInlineable(false);
                contextObject.appendScriptCode(capture.getJavaCode(context));
            }
            assert (context.peek() == newContext);
            context.pop();
        }
    }

    protected void evaluateAdd(CapturedObject contextObject, CapturedObject child, ContextNode constraints) {
        contextObject.addChild(child, constraints);
    }

    protected void evaluateMethod(Element tag, Stack<ContextNode> context, JAXXCapture capture) {
        CapturedObject contextObject = null;
        for (int i = context.size() - 1; i >= 0; --i) {
            if (!(context.get(i) instanceof CapturedObject)) continue;
            contextObject = (CapturedObject)context.get(i);
            break;
        }
        assert (contextObject != null);
        try {
            Class<?> contextClass;
            String methodName = tag.getAttribute("method");
            MethodNode newContext = new MethodNode(methodName);
            context.push(newContext);
            boolean voidChildren = this.processChildren(tag, context, capture);
            boolean add = false;
            ContextNode[] arguments = newContext.getArguments();
            if (methodName.equals("add") && arguments.length >= 1 && arguments[0] instanceof CapturedObject && Container.class.isAssignableFrom(contextClass = Class.forName(contextObject.getClassName(), true, capture.getClassLoader()))) {
                add = true;
                this.evaluateAdd(contextObject, (CapturedObject)arguments[0], null);
            }
            if (!voidChildren && !add) {
                contextObject.appendScriptCode(capture.getJavaCode(context));
            }
            assert (context.peek() == newContext);
            context.pop();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected void evaluate(Element tag, Stack<ContextNode> context, JAXXCapture capture) {
        String tagName = tag.getTagName();
        if (tagName.equals("object")) {
            String fieldName = tag.getAttribute("field");
            ContextNode currentNode = context.peek();
            if (fieldName.length() > 0) {
                try {
                    String className = tag.getAttribute("class");
                    Field field = Class.forName(className, true, capture.getClassLoader()).getField(fieldName);
                    Object value = field.get(null);
                    currentNode.addArgument(new LiteralNode(className + "." + fieldName, value));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                currentNode.addArgument(capture.processObject(tag, context));
            }
        } else if (tagName.equals("void")) {
            String property = tag.getAttribute("property");
            if (property.length() > 0) {
                this.evaluateProperty(tag, context, capture);
            } else {
                this.evaluateMethod(tag, context, capture);
            }
        } else if (tagName.equals("string")) {
            context.peek().addArgument(new ValueNode(JAXXCapture.getText(tag)));
        } else if (tagName.equals("boolean")) {
            context.peek().addArgument(new ValueNode(Boolean.valueOf(JAXXCapture.getText(tag))));
        } else if (tagName.equals("char")) {
            context.peek().addArgument(new ValueNode(Character.valueOf(JAXXCapture.getText(tag).charAt(0))));
        } else if (tagName.equals("short")) {
            context.peek().addArgument(new ValueNode(Short.valueOf(JAXXCapture.getText(tag))));
        } else if (tagName.equals("int")) {
            context.peek().addArgument(new ValueNode(Integer.valueOf(JAXXCapture.getText(tag))));
        } else if (tagName.equals("long")) {
            context.peek().addArgument(new ValueNode(Long.valueOf(JAXXCapture.getText(tag))));
        } else if (tagName.equals("float")) {
            context.peek().addArgument(new ValueNode(Float.valueOf(JAXXCapture.getText(tag))));
        } else if (tagName.equals("double")) {
            context.peek().addArgument(new ValueNode(Double.valueOf(JAXXCapture.getText(tag))));
        } else if (tagName.equals("null")) {
            context.peek().addArgument(new ValueNode(null));
        } else {
            System.err.println("unsupported tag: " + tag.getTagName());
        }
    }

    private static String dataBindingEncode(String value) {
        return value.replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}");
    }

    public CapturedObject processObject(Element objectTag, Stack<ContextNode> context, JAXXCapture capture) {
        String className = objectTag.getAttribute("class");
        if (className.length() > 0) {
            Element element;
            Node child;
            int i;
            CapturedObject capturedObject = this.createCapturedObject(className, capture);
            context.push(capturedObject);
            NodeList children = objectTag.getChildNodes();
            String id = objectTag.getAttribute("id");
            if (id.length() == 0 || capture.getCapturedObjects().containsKey(id)) {
                id = "Auto" + ++count;
            }
            assert (!capture.getCapturedObjects().containsKey(id));
            capture.getCapturedObjects().put(id, capturedObject);
            capturedObject.setProperty("id", id);
            for (i = 0; i < children.getLength(); ++i) {
                child = children.item(i);
                if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals("void") || !element.getAttribute("property").equals("name")) continue;
                this.evaluate(element, context, capture);
                String name = capturedObject.getProperty("name");
                if (name == null || capture.getCapturedObjects().containsKey(name)) continue;
                capture.getCapturedObjects().put(name, capturedObject);
                capturedObject.setProperty("id", name);
                capturedObject.getProperties().remove("name");
            }
            for (i = 0; i < children.getLength(); ++i) {
                child = children.item(i);
                if (child.getNodeType() != 1 || (element = (Element)child).getTagName().equals("void") && element.getAttribute("property").equals("name")) continue;
                this.evaluate(element, context, capture);
            }
            assert (context.peek() == capturedObject);
            context.pop();
            return capturedObject;
        }
        CapturedObject result = capture.getCapturedObjects().get(objectTag.getAttribute("idref"));
        if (result == null) {
            throw new RuntimeException("Internal error: could not find tag with id " + objectTag.getAttribute("idref"));
        }
        result.setInlineable(false);
        return result;
    }

    private static String xmlEncode(String src) {
        return src.replaceAll("'", "&amp;").replaceAll("<", "&lt;");
    }

    public String getXML(CapturedObject object, JAXXCapture capture) {
        String script;
        StringBuffer result = new StringBuffer();
        result.append('<');
        String className = object.getClassName();
        if (className.startsWith("javax.swing.")) {
            className = className.substring("javax.swing.".length());
        }
        result.append(className);
        Map<String, String> properties = object.getProperties();
        for (Map.Entry<String, String> e : properties.entrySet()) {
            result.append(' ');
            result.append(e.getKey());
            result.append("='");
            result.append(ObjectHandler.xmlEncode(e.getValue()));
            result.append('\'');
        }
        ContextNode[] arguments = object.getArguments();
        if (arguments != null && arguments.length > 0) {
            result.append(" constructorParams='");
            for (int j = 0; j < arguments.length; ++j) {
                if (j != 0) {
                    result.append(", ");
                }
                result.append(capture.getJavaCode(arguments[j]));
            }
            result.append('\'');
        }
        boolean tagClosed = false;
        String children = this.getChildXML(object, capture);
        String lineSeparator = JAXXCompiler.getLineSeparator();
        if (children != null && children.length() > 0) {
            if (!tagClosed) {
                tagClosed = true;
                result.append('>');
                result.append(lineSeparator);
            }
            result.append(children);
        }
        if ((script = object.getScriptCode()) != null && script.length() > 0) {
            if (!tagClosed) {
                tagClosed = true;
                result.append('>');
                result.append(lineSeparator);
            }
            result.append("  <script>");
            result.append(lineSeparator);
            result.append(JavaFile.indent(script, 4, false, lineSeparator));
            result.append(lineSeparator);
            result.append("  </script>");
            result.append(lineSeparator);
        }
        if (tagClosed) {
            result.append("</");
            result.append(className);
            result.append('>');
        } else {
            result.append("/>");
        }
        return result.toString();
    }

    protected String getChildXML(CapturedObject object, JAXXCapture capture) {
        StringBuffer result = new StringBuffer();
        CapturedObject[] children = object.getChildren();
        String lineSeparator = JAXXCompiler.getLineSeparator();
        for (CapturedObject aChildren : children) {
            if (aChildren.isInlineable()) continue;
            result.append(JavaFile.indent(aChildren.getXML(capture), 2, false, lineSeparator));
            result.append(lineSeparator);
        }
        return result.toString();
    }
}

