/*
 * Decompiled with CFR 0.152.
 */
package jaxx.tags.validator;

import java.io.IOException;
import jaxx.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.tags.TagHandler;
import jaxx.tags.validator.BeanValidatorHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class FieldValidatorHandler
implements TagHandler {
    public static final String TAG = "field";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String COMPONENT_ATTRIBUTE = "component";
    private static Log log = LogFactory.getLog(FieldValidatorHandler.class);

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (compiler.getOptions().isVerbose()) {
            log.info((Object)tag);
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        if (compiler.getOptions().isVerbose()) {
            log.info((Object)tag);
        }
        if (!ClassDescriptorLoader.getClassDescriptor(SwingValidator.class).isAssignableFrom(compiler.getOpenComponent().getObjectClass())) {
            compiler.reportError("field tag may only appear within BeanValidator tag but was " + tag);
            return;
        }
        BeanValidatorHandler.CompiledBeanValidator info = (BeanValidatorHandler.CompiledBeanValidator)compiler.getOpenComponent();
        String name = tag.getAttribute(NAME_ATTRIBUTE);
        String component = tag.getAttribute(COMPONENT_ATTRIBUTE);
        if (name == null || name.trim().isEmpty()) {
            compiler.reportError("field tag requires a name attribute");
            return;
        }
        name = name.trim();
        if (component == null || component.trim().isEmpty()) {
            if (!compiler.checkReference(tag, name, false, name)) {
                compiler.reportError("field tag requires a component attribute, try to use the name attribute [" + name + "] for the component, but no such component found");
                return;
            }
            component = name;
        }
        component = component.trim();
        if (info.getFields().containsValue(component)) {
            compiler.reportError("field tag found a attribute component [" + component + "] already used in this validator");
            return;
        }
        if (compiler.checkReference(tag, component, true, COMPONENT_ATTRIBUTE)) {
            info.registerField(name, component, compiler);
        }
    }
}

