/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import jaxx.CompilerException;
import jaxx.compiler.CompilerOptions;
import jaxx.compiler.Generator;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXProfile;
import jaxx.compiler.SymbolTable;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.spi.Initializer;
import jaxx.tags.DefaultObjectHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXXCompilerLaunchor {
    protected static final Log log = LogFactory.getLog(JAXXCompilerLaunchor.class);
    protected static JAXXCompilerLaunchor singleton;
    protected CompilerOptions options;
    protected final File[] files;
    protected final String[] classNames;
    protected List<File> jaxxFiles = new ArrayList<File>();
    protected List<String> jaxxFileClassNames = new ArrayList<String>();
    protected Map<String, JAXXCompiler> compilers = new HashMap<String, JAXXCompiler>();
    protected Map<File, SymbolTable> symbolTables = new HashMap<File, SymbolTable>();
    protected LifeCycle currentPass;
    protected int errorCount;
    protected int warningCount;
    protected int compilerCount;
    protected JAXXProfile profiler;

    public static synchronized JAXXCompilerLaunchor newLaunchor() {
        return JAXXCompilerLaunchor.newLaunchor((File[])null, null, null);
    }

    public static synchronized JAXXCompilerLaunchor newLaunchor(File base, String[] relativePaths, CompilerOptions options) {
        File[] files = new File[relativePaths.length];
        String[] classNames = new String[relativePaths.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(base, relativePaths[i]);
            classNames[i] = relativePaths[i].substring(0, relativePaths[i].lastIndexOf("."));
            classNames[i] = classNames[i].replace(File.separatorChar, '.');
            classNames[i] = classNames[i].replace('/', '.');
            classNames[i] = classNames[i].replace('\\', '.');
            classNames[i] = classNames[i].replace(':', '.');
        }
        return JAXXCompilerLaunchor.newLaunchor(files, classNames, options);
    }

    public static synchronized JAXXCompilerLaunchor newLaunchor(File[] files, String[] classNames, CompilerOptions options) {
        if (singleton != null) {
            singleton.reset();
        }
        singleton = new JAXXCompilerLaunchor(files, classNames, options);
        return singleton;
    }

    public static JAXXCompilerLaunchor get() throws NullPointerException {
        if (singleton == null) {
            throw new NullPointerException("no launchor was registred via newLaunchor method");
        }
        return singleton;
    }

    public static boolean isRegistred() {
        return singleton != null;
    }

    public static void loadLibraries(boolean verbose) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (verbose) {
            log.info((Object)("with cl " + classloader));
        }
        ServiceLoader<Initializer> loader = ServiceLoader.load(Initializer.class, classloader);
        for (Initializer initializer : loader) {
            if (verbose) {
                log.info((Object)("load initializer " + initializer));
            }
            initializer.initialize();
        }
    }

    protected JAXXCompilerLaunchor(File[] files, String[] classNames, CompilerOptions options) {
        this.options = options == null ? new CompilerOptions() : options;
        this.files = files;
        this.classNames = classNames;
        if (this.options.isVerbose()) {
            log.info((Object)("files : " + Arrays.toString(files)));
        }
        if (this.options.isProfile()) {
            this.profiler = new JAXXProfile();
        }
    }

    public void init() {
    }

    protected void reset() {
        this.warningCount = 0;
        this.errorCount = 0;
        this.jaxxFiles.clear();
        this.jaxxFileClassNames.clear();
        this.symbolTables.clear();
        this.compilers.clear();
        if (this.profiler != null) {
            this.profiler.clear();
        }
    }

    public String getVersion() {
        return "1.0.4";
    }

    public static JAXXCompiler createDummyCompiler() {
        return JAXXCompilerLaunchor.createDummyCompiler(JAXXCompiler.class.getClassLoader());
    }

    public static JAXXCompiler createDummyCompiler(ClassLoader classLoader) {
        return new JAXXCompiler(classLoader, new DefaultObjectHandler(ClassDescriptorLoader.getClassDescriptor(Object.class)), new String[0]){};
    }

    public JAXXCompiler getJAXXCompiler(String className) {
        return this.compilers != null ? this.compilers.get(className) : null;
    }

    public SymbolTable getSymbolTable(String className) {
        JAXXCompiler compiler = this.getJAXXCompiler(className);
        if (compiler == null) {
            return null;
        }
        return compiler.getSymbolTable();
    }

    public String getLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean compile() {
        boolean bl;
        this.compilerCount = 0;
        this.jaxxFiles.addAll(Arrays.asList(this.files));
        this.jaxxFileClassNames.addAll(Arrays.asList(this.classNames));
        try {
            JAXXCompiler compiler;
            boolean compiled;
            boolean success = true;
            if (!this.nextStep(LifeCycle.compile_first_pass, success)) {
                boolean bl2 = false;
                return bl2;
            }
            do {
                compiled = false;
                assert (this.jaxxFiles.size() == this.jaxxFileClassNames.size());
                Iterator<File> filesIterator = new ArrayList<File>(this.jaxxFiles).iterator();
                Iterator<String> classNamesIterator = new ArrayList<String>(this.jaxxFileClassNames).iterator();
                while (filesIterator.hasNext()) {
                    File file = filesIterator.next();
                    String className = classNamesIterator.next();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("compile first pass for " + className));
                    }
                    if (this.symbolTables.get(file) != null) continue;
                    compiled = true;
                    if (this.compilers.containsKey(className)) {
                        throw new CompilerException("Internal error: " + className + " is already being compiled, attempting to compile it again");
                    }
                    File destDir = this.options.getTargetDirectory();
                    if (destDir != null) {
                        int dotPos = className.lastIndexOf(".");
                        if (dotPos != -1) {
                            destDir = new File(destDir, className.substring(0, dotPos).replace('.', File.separatorChar));
                        }
                        if (!destDir.exists() && !destDir.mkdirs()) {
                            log.warn((Object)("could not create directory " + destDir));
                            continue;
                        }
                    }
                    JAXXCompiler compiler2 = this.newCompiler(file.getParentFile(), file, className);
                    JAXXCompilerLaunchor.addProfileTime(compiler2, this.currentPass.name() + "_start");
                    this.compilers.put(className, compiler2);
                    compiler2.compileFirstPass();
                    JAXXCompilerLaunchor.addProfileTime(compiler2, this.currentPass.name() + "_end");
                    assert (!this.symbolTables.values().contains(compiler2.getSymbolTable())) : "symbolTable is already registered";
                    this.symbolTables.put(file, compiler2.getSymbolTable());
                    if (!compiler2.isFailed()) continue;
                    success = false;
                }
            } while (compiled);
            if (!this.nextStep(LifeCycle.compile_second_pass, success)) {
                boolean filesIterator = false;
                return filesIterator;
            }
            assert (this.jaxxFiles.size() == this.jaxxFileClassNames.size());
            ArrayList<File> jaxxFilesClone = new ArrayList<File>(this.jaxxFiles);
            for (String className : this.jaxxFileClassNames) {
                compiler = this.getCompiler(className, "Internal error: could not find compiler for " + className + " during second pass");
                JAXXCompilerLaunchor.addProfileTime(compiler, this.currentPass.name() + "_start");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("runInitializers for " + className));
                }
                if (!compiler.isFailed()) {
                    compiler.runInitializers();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("compile second pass for " + className));
                }
                compiler.compileSecondPass();
                JAXXCompilerLaunchor.addProfileTime(compiler, this.currentPass.name() + "_end");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("done with result [" + !compiler.isFailed() + "] for " + className));
                }
                if (!compiler.isFailed()) continue;
                success = false;
            }
            if (!((Object)jaxxFilesClone).equals(this.jaxxFiles)) {
                throw new AssertionError((Object)("Internal error: compilation set altered during pass 2 (was " + jaxxFilesClone + ", modified to " + this.jaxxFiles + ")"));
            }
            if (!this.nextStep(LifeCycle.stylesheet_pass, success)) {
                boolean i$ = false;
                return i$;
            }
            assert (this.jaxxFiles.size() == this.jaxxFileClassNames.size());
            for (String className : this.jaxxFileClassNames) {
                compiler = this.getCompiler(className, "Internal error: could not find compiler for " + className + " during stylesheet application");
                JAXXCompilerLaunchor.addProfileTime(compiler, this.currentPass.name() + "_start");
                compiler.applyStylesheets();
                JAXXCompilerLaunchor.addProfileTime(compiler, this.currentPass.name() + "_end");
                if (!compiler.isFailed()) continue;
                success = false;
            }
            if (!this.nextStep(LifeCycle.generate_pass, success)) {
                boolean i$ = false;
                return i$;
            }
            assert (this.jaxxFiles.size() == this.jaxxFileClassNames.size());
            ArrayList<Generator> generators = new ArrayList<Generator>();
            for (Generator generator : ServiceLoader.load(Generator.class)) {
                generators.add(generator);
            }
            for (String className : this.jaxxFileClassNames) {
                JAXXCompiler compiler3 = this.getCompiler(className, "Internal error: could not find compiler for " + className + " during code generation");
                JAXXCompilerLaunchor.addProfileTime(compiler3, this.currentPass.name() + "_start");
                compiler3.generateCode(generators);
                JAXXCompilerLaunchor.addProfileTime(compiler3, this.currentPass.name() + "_end");
                if (!compiler3.isFailed()) continue;
                success = false;
            }
            if (this.options.isProfile()) {
                if (!this.nextStep(LifeCycle.profile_pass, success)) {
                    boolean i$ = false;
                    return i$;
                }
                StringBuilder buffer = this.profiler.computeProfileReport();
                log.info((Object)buffer.toString());
            }
            boolean bl3 = this.report(success);
            return bl3;
        }
        catch (CompilerException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            bl = false;
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            bl = false;
            return bl;
        }
        finally {
            this.compilerCount = this.compilers.size();
            if (this.options.isResetAfterCompile() && this.errorCount == 0) {
                this.reset();
            }
        }
    }

    public int getCompilerCount() {
        return this.compilerCount;
    }

    protected JAXXCompiler getCompiler(String className, String message) {
        JAXXCompiler compiler = this.compilers.get(className);
        if (compiler == null) {
            throw new CompilerException(message);
        }
        return compiler;
    }

    protected boolean nextStep(LifeCycle nextCycle, boolean success) {
        if (!success) {
            return this.report(false);
        }
        this.currentPass = nextCycle;
        return true;
    }

    protected boolean report(boolean success) {
        if (this.warningCount == 1) {
            System.err.println("1 warning");
        } else if (this.warningCount > 0) {
            System.err.println(this.warningCount + " warnings");
        }
        if (this.errorCount == 1) {
            System.err.println("1 error");
        } else if (this.errorCount > 0) {
            System.err.println(this.errorCount + " errors");
        }
        return success;
    }

    protected JAXXCompiler newCompiler(File parentFile, File file, String className) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        Constructor<? extends JAXXCompiler> cons = this.options.getCompilerClass().getConstructor(File.class, File.class, String.class, CompilerOptions.class);
        return cons.newInstance(parentFile, file, className, this.options);
    }

    public static void addProfileTime(JAXXCompiler compiler, String key) {
        JAXXProfile p = JAXXCompilerLaunchor.get().profiler;
        if (p != null) {
            p.addTime(compiler, key);
        }
    }

    protected static void showUsage() {
        System.out.println("Usage: jaxxc <options> <source files>");
        System.out.println();
        System.out.println("Source files must end in extension .jaxx");
        System.out.println("Use JAXX_OPTS environment variable to pass arguments to Java runtime");
        System.out.println();
        System.out.println("Supported options include:");
        System.out.println("  -classpath <paths>  paths to search for user classes");
        System.out.println("  -cp <paths>         same as -classpath");
        System.out.println("  -d <directory>      target directory for generated class files");
        System.out.println("  -java or -j         produce .java files, but do not compile them");
        System.out.println("  -keep or -k         preserve generated .java files after compilation");
        System.out.println("  -optimize or -o     optimize during compilation");
        System.out.println("  -version            display version information");
        System.out.println();
        System.out.println("See http://www.jaxxframework.org/ for full documentation.");
    }

    protected static enum LifeCycle {
        init,
        compile_first_pass,
        compile_second_pass,
        stylesheet_pass,
        generate_pass,
        profile_pass;

    }
}

