/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler;

import jaxx.CompilerException;
import jaxx.compiler.DataSource;
import jaxx.compiler.JAXXCompiler;
import jaxx.types.TypeManager;

public class DataBinding {
    private String id;
    private DataSource dataSource;
    private String dest;
    private String assignment;
    private JAXXCompiler compiler;

    public DataBinding(String source, String dest, String assignment, JAXXCompiler compiler) {
        this.id = dest;
        this.dataSource = new DataSource(this.id, source, compiler);
        this.dest = dest;
        this.assignment = assignment;
        this.compiler = compiler;
    }

    public String getId() {
        return this.id;
    }

    public boolean compile(boolean quickNoDependencies) throws CompilerException {
        boolean result = this.dataSource.compile("new jaxx.runtime.DataBindingListener(" + this.compiler.getRootObject().getJavaCode() + ", " + TypeManager.getJavaCode(this.id) + ")");
        if (!result && quickNoDependencies) {
            if (!this.dest.endsWith(".layout")) {
                this.compiler.appendInitDataBindings(this.assignment + JAXXCompiler.getLineSeparator());
            }
            return false;
        }
        if (this.compiler.haveProcessDataBinding()) {
            this.compiler.appendProcessDataBinding(" else ");
        } else {
            this.compiler.appendProcessDataBinding("    ");
        }
        this.compiler.appendProcessDataBinding("if (" + TypeManager.getJavaCode(this.id) + ".equals($dest)) {" + JAXXCompiler.getLineSeparator());
        String objectCode = this.dataSource.getObjectCode();
        if (objectCode != null) {
            this.compiler.appendProcessDataBinding("    if (" + objectCode + " != null) {" + JAXXCompiler.getLineSeparator());
            this.compiler.appendProcessDataBinding("    ");
        }
        this.compiler.appendProcessDataBinding("    " + this.assignment.trim());
        if (objectCode != null) {
            this.compiler.appendProcessDataBinding(JAXXCompiler.getLineSeparator() + "    }");
        }
        this.compiler.appendProcessDataBinding(JAXXCompiler.getLineSeparator() + "    }");
        return true;
    }
}

