/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.swing;

import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.DefaultComponentHandler;
import org.w3c.dom.Element;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JWindow;
import java.io.IOException;
import java.util.Map;

public class JWindowHandler extends DefaultComponentHandler {

    public JWindowHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(getClass(), beanClass, JWindow.class, JFrame.class, JDialog.class);
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledObject(id, getBeanClass(), compiler) {
            @Override
            public void addChild(CompiledObject child, String constraints, JAXXCompiler compiler) throws CompilerException {
                if (ClassDescriptorLoader.getClassDescriptor(JMenuBar.class).isAssignableFrom(child.getObjectClass())) {
                    appendAdditionCode(getId() + ".setJMenuBar(" + child.getId() + ");");
                } else {
                    super.addChild(child, constraints, compiler);
                }
            }
        };
    }

    @Override
    protected void openComponent(CompiledObject object, Element tag, JAXXCompiler compiler) throws CompilerException {
        if (compiler.getOpenComponent() != null) {
            compiler.openInvisibleComponent(object);
        } else {
            super.openComponent(object, tag, compiler);
        }
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        super.compileSecondPass(tag, compiler);
        CompiledObject object = objectMap.get(tag);
        Map properties = object.getProperties();
        if (!properties.containsKey("width") && !properties.containsKey("height")) {
            compiler.appendLateInitializer(object.getId() + ".pack();\n");
        }
    }
}