/*
 * Decompiled with CFR 0.152.
 */
package jaxx.tags.swing;

import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.JAXXComboBox;
import jaxx.tags.DefaultComponentHandler;
import jaxx.tags.swing.CompiledItemContainer;
import jaxx.types.TypeManager;
import org.w3c.dom.Element;

public class JComboBoxHandler
extends DefaultComponentHandler {
    public JComboBoxHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(this.getClass(), beanClass, JAXXComboBox.class);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        this.addProxyEventInfo("getSelectedIndex", ItemListener.class);
        this.addProxyEventInfo("getSelectedItem", ItemListener.class);
    }

    @Override
    protected CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledItemContainer(id, this.getBeanClass(), compiler);
    }

    @Override
    public void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        super.compileChildrenSecondPass(tag, compiler);
        CompiledItemContainer list = (CompiledItemContainer)compiler.getOpenComponent();
        List<Item> items = list.getItems();
        if (items != null && !items.isEmpty()) {
            String listName = list.getId() + "$items";
            list.appendAdditionCode("java.util.List<jaxx.runtime.swing.Item> " + listName + " = new java.util.ArrayList<jaxx.runtime.swing.Item>();");
            for (Item item : items) {
                String id = item.getId();
                CompiledObject compiledItem = new CompiledObject(id, ClassDescriptorLoader.getClassDescriptor(Item.class), compiler);
                compiledItem.setConstructorParams(TypeManager.getJavaCode(id) + ", " + TypeManager.getJavaCode(item.getLabel()) + ", " + TypeManager.getJavaCode(item.getValue()) + ", " + item.isSelected());
                compiler.registerCompiledObject(compiledItem);
                list.appendAdditionCode(listName + ".add(" + id + ");");
            }
            list.appendAdditionCode(list.getId() + ".setItems(" + listName + ");");
        }
    }
}

