/*
 * Decompiled with CFR 0.152.
 */
package jaxx.tags;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import jaxx.CompilerException;
import jaxx.UnsupportedAttributeException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JavaArgument;
import jaxx.compiler.JavaMethod;
import jaxx.css.Stylesheet;
import jaxx.css.StylesheetHelper;
import jaxx.introspection.JAXXBeanInfo;
import jaxx.introspection.JAXXEventSetDescriptor;
import jaxx.introspection.JAXXIntrospector;
import jaxx.introspection.JAXXPropertyDescriptor;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.reflect.FieldDescriptor;
import jaxx.reflect.MethodDescriptor;
import jaxx.runtime.ComponentDescriptor;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.tags.TagHandler;
import jaxx.tags.TagManager;
import jaxx.types.TypeManager;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DefaultObjectHandler
implements TagHandler {
    private ClassDescriptor beanClass;
    protected JAXXBeanInfo jaxxBeanInfo;
    private Map<String, JAXXPropertyDescriptor> properties;
    private Map<String, JAXXEventSetDescriptor> events;
    private Map<String, ProxyEventInfo> eventInfos;
    protected static Map<Element, CompiledObject> objectMap = new WeakHashMap<Element, CompiledObject>();

    public DefaultObjectHandler(ClassDescriptor beanClass) {
        this.beanClass = beanClass;
    }

    protected void init() throws IntrospectionException {
        if (this.jaxxBeanInfo == null) {
            this.jaxxBeanInfo = DefaultObjectHandler.getJAXXBeanInfo(this.beanClass);
            JAXXPropertyDescriptor[] propertiesArray = this.jaxxBeanInfo.getJAXXPropertyDescriptors();
            this.properties = new HashMap<String, JAXXPropertyDescriptor>();
            for (int i = propertiesArray.length - 1; i >= 0; --i) {
                this.properties.put(propertiesArray[i].getName(), propertiesArray[i]);
            }
            JAXXEventSetDescriptor[] eventsArray = this.jaxxBeanInfo.getJAXXEventSetDescriptors();
            this.events = new HashMap<String, JAXXEventSetDescriptor>();
            for (int i = eventsArray.length - 1; i >= 0; --i) {
                MethodDescriptor[] methods;
                for (MethodDescriptor method : methods = eventsArray[i].getListenerMethods()) {
                    this.events.put(method.getName(), eventsArray[i]);
                }
            }
            this.configureProxyEventInfo();
        }
    }

    public ClassDescriptor getBeanClass() {
        return this.beanClass;
    }

    public JAXXBeanInfo getJAXXBeanInfo() {
        try {
            this.init();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        return this.jaxxBeanInfo;
    }

    public static JAXXBeanInfo getJAXXBeanInfo(ClassDescriptor beanClass) throws IntrospectionException {
        return JAXXIntrospector.getJAXXBeanInfo(beanClass);
    }

    public ClassDescriptor getPropertyType(CompiledObject object, String propertyName, JAXXCompiler compiler) {
        try {
            this.init();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        JAXXPropertyDescriptor property = this.properties.get(propertyName);
        if (property != null) {
            return property.getPropertyType();
        }
        throw new UnsupportedAttributeException("property '" + propertyName + "' not found in " + object);
    }

    public boolean isMemberBound(String name) throws UnsupportedAttributeException {
        JAXXPropertyDescriptor property;
        try {
            this.init();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        if (this.eventInfos != null && this.eventInfos.containsKey(name)) {
            return true;
        }
        if (name.equals("getClass")) {
            return false;
        }
        String propertyName = null;
        if (name.startsWith("get")) {
            propertyName = Introspector.decapitalize(name.substring("get".length()));
        } else if (name.startsWith("is")) {
            propertyName = Introspector.decapitalize(name.substring("is".length()));
        }
        JAXXPropertyDescriptor jAXXPropertyDescriptor = property = propertyName != null ? this.properties.get(propertyName) : null;
        if (property != null) {
            return property.isBound();
        }
        try {
            FieldDescriptor field = this.getBeanClass().getFieldDescriptor(name);
            return Modifier.isFinal(field.getModifiers());
        }
        catch (NoSuchFieldException e) {
            throw new UnsupportedAttributeException("cannot find property '" + name + "' of " + this.getBeanClass());
        }
    }

    private static ClassDescriptor getEventClass(ClassDescriptor listenerClass) {
        return listenerClass.getMethodDescriptors()[0].getParameterTypes()[0];
    }

    public String[] getMemberDependencies(String memberName) {
        String[] stringArray;
        ProxyEventInfo eventInfo;
        ProxyEventInfo proxyEventInfo = eventInfo = this.eventInfos != null ? this.eventInfos.get(memberName) : null;
        if (eventInfo == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = eventInfo.modelName;
        }
        return stringArray;
    }

    public String getAddMemberListenerCode(String objectCode, String dataBinding, String memberName, String propertyChangeListenerCode, JAXXCompiler compiler) {
        ProxyEventInfo eventInfo;
        if ("getClass".equals(memberName)) {
            return null;
        }
        ProxyEventInfo proxyEventInfo = eventInfo = this.eventInfos != null ? this.eventInfos.get(memberName) : null;
        if (eventInfo != null) {
            StringBuffer result = new StringBuffer();
            String methodName = "$pr" + compiler.getUniqueId(propertyChangeListenerCode);
            boolean methodExists = compiler.hasMethod(methodName);
            ClassDescriptor eventClass = DefaultObjectHandler.getEventClass(eventInfo.listenerClass);
            if (!methodExists) {
                compiler.addMethodToJavaFile(new JavaMethod(1, "void", methodName, new JavaArgument[]{new JavaArgument(JAXXCompiler.getCanonicalName(eventClass), "event")}, null, propertyChangeListenerCode + ".propertyChange(null);"));
            }
            String code = objectCode + (eventInfo.modelName != null ? ".get" + StringUtils.capitalize((String)eventInfo.modelName) + "()" : "");
            result.append("$bindingSources.put(\"").append(code).append("\", ").append(code).append(");").append(JAXXCompiler.getLineSeparator());
            result.append(code).append('.').append(eventInfo.addMethod).append("((").append(JAXXCompiler.getCanonicalName(eventInfo.listenerClass)).append(") jaxx.runtime.Util.getEventListener(").append(JAXXCompiler.getCanonicalName(eventInfo.listenerClass)).append(".class, ").append(compiler.getRootObject().getJavaCode()).append(", ").append(TypeManager.getJavaCode(methodName)).append("));\n");
            if (eventInfo.modelName != null) {
                result.append(this.getAddMemberListenerCode(objectCode, dataBinding, "get" + StringUtils.capitalize((String)eventInfo.modelName), "jaxx.runtime.Util.getDataBindingUpdateListener(this , \"" + dataBinding + "\")", compiler));
            }
            return result.toString();
        }
        String propertyName = null;
        if (memberName.startsWith("get")) {
            propertyName = Introspector.decapitalize(memberName.substring("get".length()));
        } else if (memberName.startsWith("is")) {
            propertyName = Introspector.decapitalize(memberName.substring("is".length()));
        } else {
            try {
                this.getBeanClass().getFieldDescriptor(memberName);
                propertyName = memberName;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        if (propertyName != null) {
            try {
                this.getBeanClass().getMethodDescriptor("addPropertyChangeListener", ClassDescriptorLoader.getClassDescriptor(String.class), ClassDescriptorLoader.getClassDescriptor(PropertyChangeListener.class));
                return objectCode + ".addPropertyChangeListener(\"" + propertyName + "\", " + propertyChangeListenerCode + ");\n";
            }
            catch (NoSuchMethodException e) {
                return objectCode + ".addPropertyChangeListener(" + propertyChangeListenerCode + ");\n";
            }
        }
        return null;
    }

    public String getRemoveMemberListenerCode(String objectCode, String dataBinding, String memberName, String propertyChangeListenerCode, JAXXCompiler compiler) {
        ProxyEventInfo eventInfo;
        if ("getClass".equals(memberName)) {
            return null;
        }
        ProxyEventInfo proxyEventInfo = eventInfo = this.eventInfos != null ? this.eventInfos.get(memberName) : null;
        if (eventInfo != null) {
            StringBuffer result = new StringBuffer();
            String methodName = "$pr" + compiler.getUniqueId(propertyChangeListenerCode);
            boolean methodExists = compiler.hasMethod(methodName);
            if (!methodExists) {
                ClassDescriptor eventClass = DefaultObjectHandler.getEventClass(eventInfo.listenerClass);
                compiler.addMethodToJavaFile(new JavaMethod(1, "void", methodName, new JavaArgument[]{new JavaArgument(JAXXCompiler.getCanonicalName(eventClass), "event")}, null, propertyChangeListenerCode + ".propertyChange(null);"));
            }
            try {
                String modelMemberName = eventInfo.modelName != null ? "get" + StringUtils.capitalize((String)eventInfo.modelName) : null;
                String modelClassName = modelMemberName != null ? this.getBeanClass().getMethodDescriptor(modelMemberName, new ClassDescriptor[0]).getReturnType().getName() : JAXXCompiler.getCanonicalName(this.getBeanClass());
                String code = objectCode + (eventInfo.modelName != null ? "." + modelMemberName + "()" : "");
                result.append("((").append(modelClassName).append(") $bindingSources.remove(\"").append(code).append("\")).").append(eventInfo.removeMethod).append("((").append(JAXXCompiler.getCanonicalName(eventInfo.listenerClass)).append(") jaxx.runtime.Util.getEventListener(").append(JAXXCompiler.getCanonicalName(eventInfo.listenerClass)).append(".class, ").append(compiler.getRootObject().getJavaCode()).append(", ").append(TypeManager.getJavaCode(methodName)).append("));\n");
                if (eventInfo.modelName != null) {
                    result.append(this.getRemoveMemberListenerCode(objectCode, dataBinding, "get" + StringUtils.capitalize((String)eventInfo.modelName), "jaxx.runtime.Util.getDataBindingUpdateListener(this, \"" + dataBinding + "\")", compiler));
                }
                return result.toString();
            }
            catch (NoSuchMethodException e) {
                throw new CompilerException("Internal error: " + e);
            }
        }
        String propertyName = null;
        if (memberName.startsWith("get")) {
            propertyName = Introspector.decapitalize(memberName.substring("get".length()));
        } else if (memberName.startsWith("is")) {
            propertyName = Introspector.decapitalize(memberName.substring("is".length()));
        } else {
            try {
                this.getBeanClass().getFieldDescriptor(memberName);
                propertyName = memberName;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        if (propertyName != null) {
            try {
                this.getBeanClass().getMethodDescriptor("removePropertyChangeListener", ClassDescriptorLoader.getClassDescriptor(String.class), ClassDescriptorLoader.getClassDescriptor(PropertyChangeListener.class));
                return objectCode + ".removePropertyChangeListener(\"" + propertyName + "\", " + propertyChangeListenerCode + ");\n";
            }
            catch (NoSuchMethodException e) {
                return objectCode + ".removePropertyChangeListener(" + propertyChangeListenerCode + ");\n";
            }
        }
        return null;
    }

    protected void configureProxyEventInfo() {
    }

    public void addProxyEventInfo(String memberName, Class listenerClass) {
        this.addProxyEventInfo(memberName, listenerClass, null);
    }

    public void addProxyEventInfo(String memberName, Class listenerClass, String modelName) {
        String listenerName = listenerClass.getName();
        listenerName = listenerName.substring(listenerName.lastIndexOf(".") + 1);
        this.addProxyEventInfo(memberName, listenerClass, modelName, "add" + listenerName, "remove" + listenerName);
    }

    public void addProxyEventInfo(String memberName, Class listenerClass, String modelName, String addMethod, String removeMethod) {
        try {
            this.addProxyEventInfo(memberName, ClassDescriptorLoader.getClassDescriptor(listenerClass.getName()), modelName, addMethod, removeMethod);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void addProxyEventInfo(String memberName, ClassDescriptor listenerClass, String modelName, String addMethod, String removeMethod) {
        ProxyEventInfo info = new ProxyEventInfo();
        info.memberName = memberName;
        info.listenerClass = listenerClass;
        info.modelName = modelName;
        info.addMethod = addMethod;
        info.removeMethod = removeMethod;
        if (this.eventInfos == null) {
            this.eventInfos = new HashMap<String, ProxyEventInfo>();
        }
        this.eventInfos.put(memberName, info);
    }

    @Override
    public void compileFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        this.scanAttributesForDependencies(tag, compiler);
        this.compileChildrenFirstPass(tag, compiler);
    }

    @Override
    public void compileSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        try {
            this.init();
        }
        catch (IntrospectionException e) {
            throw new CompilerException(e);
        }
        CompiledObject object = objectMap.get(tag);
        if (object == null) {
            throw new IllegalStateException("unable to find CompiledObject associated with tag <" + tag.getTagName() + ">;  should have been registered before second pass");
        }
        compiler.checkOverride(object);
        String constructorParams = tag.getAttribute("constructorParams");
        if (constructorParams != null && constructorParams.length() > 0) {
            object.setConstructorParams(compiler.getScriptManager().trimScript(constructorParams));
        }
        this.setDefaults(object, tag, compiler);
        this.setAttributes(object, tag, compiler);
        if (object.getGenericTypesLength() > 0 && object != compiler.getRootObject() && !object.isJavaBean()) {
            compiler.reportWarning("'genericType' attribute can only be found on root, or a javaBean object tag but was found on tag " + tag);
            object.setGenericTypes(null);
            return;
        }
        this.compileChildrenSecondPass(tag, compiler);
    }

    public void registerCompiledObject(Element tag, JAXXCompiler compiler) {
        String id = tag.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = compiler.getAutoId(this.getBeanClass());
        }
        CompiledObject object = this.createCompiledObject(id, compiler);
        objectMap.put(tag, object);
        String styleClass = tag.getAttribute("styleClass").trim();
        if (styleClass.length() > 0) {
            object.setStyleClass(styleClass);
        }
        compiler.registerCompiledObject(object);
    }

    protected CompiledObject createCompiledObject(String id, JAXXCompiler compiler) {
        return new CompiledObject(id, this.getBeanClass(), compiler);
    }

    protected void setDefaults(CompiledObject object, Element tag, JAXXCompiler compiler) {
    }

    public boolean isPropertyInherited(String property) throws UnsupportedAttributeException {
        return false;
    }

    public boolean isEventHandlerName(String name) {
        return name.length() > 2 && name.startsWith("on") && Character.isUpperCase(name.charAt(2));
    }

    protected void scanAttributesForDependencies(Element tag, JAXXCompiler compiler) {
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            attributes.add((Attr)children.item(i));
        }
        Collections.sort(attributes, this.getAttributeComparator());
        for (Attr attribute : attributes) {
            String name = attribute.getName();
            String value = attribute.getValue();
            if (name.equals("javaBean")) continue;
            if (name.equals("constraints") || this.isEventHandlerName(name)) {
                compiler.preprocessScript(value);
                continue;
            }
            if (name.equals("constructorParams")) {
                for (String param : value.split("\\s*,\\s*")) {
                    compiler.preprocessScript(param);
                }
                continue;
            }
            if (!value.startsWith("{") || !value.endsWith("}")) continue;
            compiler.preprocessScript(value.substring(1, value.length() - 1));
        }
    }

    public void setAttributes(CompiledObject object, Element tag, JAXXCompiler compiler) {
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        NamedNodeMap children = tag.getAttributes();
        for (int i = 0; i < children.getLength(); ++i) {
            attributes.add((Attr)children.item(i));
        }
        Collections.sort(attributes, this.getAttributeComparator());
        for (Attr attribute : attributes) {
            String name = attribute.getName();
            String value = attribute.getValue().trim();
            if (name.equals("id") || name.equals("constraints") || name.equals("constructorParams") || name.equals("styleClass") || name.startsWith("xmlns") || "http://www.jaxxframework.org/internal".equals(attribute.getNamespaceURI())) continue;
            if (name.equals("javaBean")) {
                object.setJavaBean(true);
                if (value.isEmpty()) continue;
                object.setJavaBeanInitCode(value);
                continue;
            }
            if (name.equals("implements")) {
                if (object != compiler.getRootObject()) {
                    compiler.reportError("'implements' attribute can only be found on root tag but was found on tag " + tag);
                    return;
                }
                String[] interfaces = value.split(",");
                compiler.setExtraInterfaces(interfaces);
                continue;
            }
            if (name.equals("abstract")) {
                if (object != compiler.getRootObject()) {
                    compiler.reportError("'abstract' attribute can only be found on root tag but was found on tag " + tag);
                    return;
                }
                compiler.setAbstractClass(true);
                continue;
            }
            if (name.equals("genericType")) {
                if (object == compiler.getRootObject()) {
                    compiler.setGenericType(value);
                    continue;
                }
                object.setGenericTypes(value.split(","));
                continue;
            }
            if (name.equals("superGenericType")) {
                if (object != compiler.getRootObject()) {
                    compiler.reportError("'superGenericType' attribute can only be found on root tag but was found on tag " + tag);
                    return;
                }
                compiler.setSuperGenericType(value);
                continue;
            }
            if (name.equals("decorator")) {
                if (value.isEmpty()) continue;
                CompiledObjectDecorator decorator = CompiledObjectDecorator.getDecorator(value);
                object.setDecorator(decorator);
                continue;
            }
            if (this.isEventHandlerName(name)) {
                if (!value.endsWith(";")) {
                    value = value + ";";
                }
                this.addEventHandler(object, Introspector.decapitalize(name.substring(2)), value, compiler);
                continue;
            }
            this.setAttribute(object, name, value, true, compiler);
        }
    }

    protected Comparator<Attr> getAttributeComparator() {
        return new Comparator<Attr>(){

            @Override
            public int compare(Attr a, Attr b) {
                int aOrder = DefaultObjectHandler.this.getAttributeOrdering(a);
                int bOrder = DefaultObjectHandler.this.getAttributeOrdering(b);
                return aOrder - bOrder;
            }
        };
    }

    protected int getAttributeOrdering(Attr attr) {
        if (attr.getName().equals("displayedMnemonicIndex") || attr.getName().equals("displayedMnemonic") || attr.getName().equals("mnemonic")) {
            return 1;
        }
        return 0;
    }

    public String getApplyPropertyOrDataBindingCode(CompiledObject object, String propertyName, String stringValue, JAXXCompiler compiler) {
        ClassDescriptor type = this.getPropertyType(object, propertyName, compiler);
        String binding = compiler.processDataBindings(stringValue, type);
        if (binding != null) {
            return "";
        }
        try {
            Class<?> typeClass = type != null ? ClassDescriptorLoader.getClass(type.getName(), type.getClassLoader()) : null;
            Object value = this.convertFromString(propertyName, stringValue, typeClass);
            return this.getSetPropertyCode(object.getJavaCode(), propertyName, TypeManager.getJavaCode(value), compiler);
        }
        catch (NumberFormatException e) {
            compiler.reportError("could not convert literal string '" + stringValue + "' to type " + type.getName());
        }
        catch (IllegalArgumentException e) {
            compiler.reportError("could not convert literal string '" + stringValue + "' to type " + type.getName());
        }
        catch (ClassNotFoundException e) {
            compiler.reportError("could not find class " + type.getName());
        }
        return "";
    }

    public void setAttribute(CompiledObject object, String propertyName, String stringValue, boolean inline, JAXXCompiler compiler) {
        try {
            if (ClassDescriptorLoader.getClassDescriptor(JAXXObject.class).isAssignableFrom(object.getObjectClass())) {
                JAXXObjectDescriptor jaxxObjectDescriptor = object.getObjectClass().getJAXXObjectDescriptor();
                ComponentDescriptor root = jaxxObjectDescriptor.getComponentDescriptors()[0];
                object.appendInitializationCode(object.getJavaCode() + ".removeDataBinding(" + TypeManager.getJavaCode(root.getId() + "." + propertyName) + ");" + JAXXCompiler.getLineSeparator());
            }
            object.addProperty(propertyName, stringValue);
            ClassDescriptor type = this.getPropertyType(object, propertyName, compiler);
            String binding = compiler.processDataBindings(stringValue, type);
            if (binding != null) {
                ClassDescriptor propertyType;
                if (inline) {
                    compiler.addInlineStyle(object, propertyName, true);
                }
                if ((propertyType = this.getPropertyType(object, propertyName, compiler)) == null || propertyType == ClassDescriptorLoader.getClassDescriptor(Boolean.class) || propertyType == ClassDescriptorLoader.getClassDescriptor(Byte.class) || propertyType == ClassDescriptorLoader.getClassDescriptor(Short.class) || propertyType == ClassDescriptorLoader.getClassDescriptor(Integer.class) || propertyType == ClassDescriptorLoader.getClassDescriptor(Float.class) || propertyType == ClassDescriptorLoader.getClassDescriptor(Double.class) || propertyType != ClassDescriptorLoader.getClassDescriptor(Character.class)) {
                    // empty if block
                }
                if (propertyName.equals("layout")) {
                    object.appendInitializationCode(this.getSetPropertyCode(object.getJavaCode(), propertyName, binding, compiler));
                }
                object.registerDataBinding(binding, propertyName, this.getSetPropertyCode(object.getJavaCode(), propertyName, binding, compiler), compiler);
            } else {
                if (inline) {
                    compiler.addInlineStyle(object, propertyName, false);
                }
                try {
                    Class<?> typeClass = type != null ? ClassDescriptorLoader.getClass(type.getName(), type.getClassLoader()) : null;
                    Object value = this.convertFromString(propertyName, stringValue, typeClass);
                    this.setProperty(object, propertyName, value, compiler);
                }
                catch (NumberFormatException e) {
                    compiler.reportError("could not convert literal string '" + stringValue + "' to type " + type.getName());
                }
                catch (IllegalArgumentException e) {
                    compiler.reportError("could not convert literal string '" + stringValue + "' to type " + type.getName());
                }
                catch (ClassNotFoundException e) {
                    compiler.reportError("could not find class " + type.getName());
                }
            }
        }
        catch (UnsupportedAttributeException e) {
            compiler.reportError("class " + object.getObjectClass().getName() + " does not support attribute '" + propertyName + "'");
        }
    }

    public void applyStylesheets(CompiledObject object, JAXXCompiler compiler) {
        this.applyStylesheets(object, compiler, null);
    }

    private void applyStylesheets(CompiledObject object, JAXXCompiler compiler, Stylesheet overrides) {
        this.applyStylesheets(object, compiler, overrides, true);
    }

    private void applyStylesheets(CompiledObject object, JAXXCompiler compiler, Stylesheet overrides, boolean recurse) {
        try {
            Stylesheet stylesheet = compiler.getStylesheet();
            ClassDescriptor objectClass = object.getObjectClass();
            if (recurse && ClassDescriptorLoader.getClassDescriptor(JAXXObject.class).isAssignableFrom(objectClass)) {
                ComponentDescriptor[] descriptors;
                JAXXObjectDescriptor jaxxObjectDescriptor = objectClass.getJAXXObjectDescriptor();
                for (ComponentDescriptor descriptor : descriptors = jaxxObjectDescriptor.getComponentDescriptors()) {
                    ClassDescriptor classDescriptor = ClassDescriptorLoader.getClassDescriptor(descriptor.getJavaClassName());
                    boolean isRoot = classDescriptor != objectClass;
                    String id = isRoot ? object.getId() + ' ' + descriptor.getId() : "( " + object.getId() + " ) " + descriptor.getId();
                    CompiledObject child = new CompiledObject(id, "((" + JAXXCompiler.getCanonicalName(classDescriptor) + ") " + object.getJavaCode() + ".getObjectById(" + TypeManager.getJavaCode(descriptor.getId()) + "))", classDescriptor, compiler, true);
                    CompiledObject currentObject = child;
                    for (ComponentDescriptor parentDescriptor = descriptor.getParent(); parentDescriptor != null; parentDescriptor = parentDescriptor.getParent()) {
                        CompiledObject parent = new CompiledObject("internal", ClassDescriptorLoader.getClassDescriptor(parentDescriptor.getJavaClassName()), compiler);
                        currentObject.setParent(parent);
                        currentObject = parent;
                    }
                    currentObject.setParent(object);
                    String styleClass = object.getStyleClass();
                    if (styleClass == null) {
                        styleClass = descriptor.getStyleClass();
                    }
                    child.setStyleClass(styleClass);
                    Stylesheet mergedStylesheet = overrides;
                    Stylesheet childOverrides = jaxxObjectDescriptor.getStylesheet();
                    if (childOverrides != null) {
                        if (mergedStylesheet == null) {
                            mergedStylesheet = childOverrides;
                        } else {
                            mergedStylesheet.add(childOverrides.getRules());
                        }
                    }
                    TagManager.getTagHandler(objectClass).applyStylesheets(child, compiler, mergedStylesheet, isRoot);
                    object.appendInitializationCode(child.getInitializationCode(compiler));
                }
            } else if (stylesheet != null) {
                StylesheetHelper.applyTo(object, compiler, stylesheet, overrides);
            }
        }
        catch (ClassNotFoundException e) {
            throw new CompilerException(e);
        }
        catch (IllegalArgumentException e) {
            compiler.reportError(e.getMessage());
        }
    }

    public void addEventHandler(CompiledObject object, String name, String value, JAXXCompiler compiler) {
        JAXXEventSetDescriptor JAXXEventSetDescriptor2 = this.events.get(name);
        if (JAXXEventSetDescriptor2 != null) {
            MethodDescriptor[] listenerMethods = JAXXEventSetDescriptor2.getListenerMethods();
            MethodDescriptor listenerMethod = null;
            for (MethodDescriptor listenerMethod1 : listenerMethods) {
                if (!listenerMethod1.getName().equals(name)) continue;
                listenerMethod = listenerMethod1;
                break;
            }
            if (listenerMethod == null) {
                throw new RuntimeException("expected to find method '" + name + "' in JAXXEventSetDescriptor.getListenerMethods()");
            }
            try {
                value = compiler.preprocessScript(value);
                object.addEventHandler(name, JAXXEventSetDescriptor2.getAddListenerMethod(), listenerMethod, value, compiler);
            }
            catch (CompilerException e) {
                compiler.reportError("While parsing event handler for '" + name + "': " + e.getMessage());
            }
        } else {
            compiler.reportError("could not find event '" + name + "' for object " + object);
        }
    }

    public String getGetPropertyCode(String javaCode, String name, JAXXCompiler compiler) {
        try {
            this.init();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        JAXXPropertyDescriptor property = this.properties.get(name);
        if (property != null) {
            if (property.getReadMethodDescriptor() != null) {
                return javaCode + '.' + property.getReadMethodDescriptor().getName() + "()";
            }
            throw new UnsupportedAttributeException("property '" + name + "' of " + this.getBeanClass().getName() + " has no read method");
        }
        throw new UnsupportedAttributeException("property '" + name + "' could not be found in class " + this.getBeanClass().getName());
    }

    public String getSetPropertyCode(String javaCode, String name, String valueCode, JAXXCompiler compiler) {
        JAXXPropertyDescriptor property = this.properties.get(name);
        if (property != null) {
            if (property.getWriteMethodDescriptor() != null) {
                return javaCode + '.' + property.getWriteMethodDescriptor().getName() + '(' + valueCode + ");";
            }
            throw new UnsupportedAttributeException("property '" + name + "' of " + this.getBeanClass().getName() + " is read-only");
        }
        throw new UnsupportedAttributeException("property '" + name + "' could not be found in class " + this.getBeanClass().getName());
    }

    public void setProperty(CompiledObject object, String name, Object value, JAXXCompiler compiler) {
        object.appendInitializationCode(this.getSetPropertyCode(object.getJavaCodeForProperty(name), name, TypeManager.getJavaCode(value), compiler));
    }

    protected int constantValue(String key, String value) {
        JAXXBeanInfo JAXXBeanInfo2 = this.getJAXXBeanInfo();
        JAXXPropertyDescriptor[] props = JAXXBeanInfo2.getJAXXPropertyDescriptors();
        String lowercaseValue = value.toLowerCase();
        for (JAXXPropertyDescriptor property : props) {
            Object[] values;
            if (!property.getName().equals(key) || (values = (Object[])property.getValue("enumerationValues")) == null) continue;
            for (int j = 0; j < values.length - 2; j += 3) {
                if (!((String)values[j]).toLowerCase().equals(lowercaseValue)) continue;
                return (Integer)values[j + 1];
            }
            StringBuffer message = new StringBuffer("value of '" + key + "' must be one of: [");
            for (int j = 0; j < values.length - 2; j += 3) {
                if (j != 0) {
                    message.append(", ");
                }
                message.append(((String)values[j]).toLowerCase());
            }
            message.append("] (found '").append(value).append("')");
            throw new IllegalArgumentException(message.toString());
        }
        throw new NumberFormatException(value);
    }

    protected Object convertFromString(String key, String value, Class type) {
        if (type == null || type == Object.class) {
            return value;
        }
        try {
            return TypeManager.convertFromString(value, type);
        }
        catch (NumberFormatException e) {
            if (type == Integer.TYPE || type == Integer.class) {
                return this.constantValue(key, value);
            }
            throw e;
        }
    }

    protected void compileChildrenFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType != 1) continue;
            Element child = (Element)node;
            this.compileChildTagFirstPass(child, compiler);
        }
    }

    protected void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String text;
            Node node = children.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element child = (Element)node;
                this.compileChildTagSecondPass(child, compiler);
                continue;
            }
            if (nodeType != 3 && nodeType != 4 || (text = ((Text)node).getData().trim()).length() <= 0) continue;
            compiler.reportError("tag '" + tag.getLocalName() + "' may not contain text ('" + ((Text)node).getData().trim() + "')");
        }
    }

    protected void compileChildTagFirstPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileFirstPass(tag);
    }

    protected void compileChildTagSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        compiler.compileSecondPass(tag);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getBeanClass().getName() + "]";
    }

    private class ProxyEventInfo {
        String memberName;
        ClassDescriptor listenerClass;
        String modelName;
        String addMethod;
        String removeMethod;

        private ProxyEventInfo() {
        }
    }
}

