/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.compiler;

import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.MethodDescriptor;

public class EventHandler {
    private String eventId;
    private String objectCode;
    private ClassDescriptor listenerClass;
    private MethodDescriptor addMethod;
    private MethodDescriptor listenerMethod;
    private String javaCode;

    public EventHandler(String eventId, String objectCode, MethodDescriptor addMethod, ClassDescriptor listenerClass, MethodDescriptor listenerMethod, String javaCode) {
        this.eventId = eventId;
        this.objectCode = objectCode;
        this.addMethod = addMethod;
        this.listenerClass = listenerClass;
        this.listenerMethod = listenerMethod;
        this.javaCode = javaCode;
    }


    public String getEventId() {
        return eventId;
    }


    public String getObjectCode() {
        return objectCode;
    }


    public MethodDescriptor getAddMethod() {
        return addMethod;
    }


    public ClassDescriptor getListenerClass() {
        return listenerClass;
    }


    public MethodDescriptor getListenerMethod() {
        return listenerMethod;
    }


    public String getJavaCode() {
        return javaCode;
    }


    public String toString() {
        return "EventHandler[" + eventId + ", " + listenerClass.getName() + ", " + objectCode + ", " + javaCode + "]";
    }
}