package org.nuiton.jaxx.application.listener;

/*
 * #%L
 * JAXX :: Application API
 * $Id: PropagatePropertyChangeListener.java 2779 2014-01-31 10:50:51Z tchemit $
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Code Lutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.jdesktop.beans.AbstractBean;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * To listen a bean and propagate some of properties.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.8
 */
public class PropagatePropertyChangeListener implements PropertyChangeListener {

    public static interface PropagatePropertyChange {
        void firePropertyChanged(String propertyName,
                                 Object oldValue,
                                 Object newValue);
    }

    public static void listenAndPropagate(AbstractBean producer,
                                          PropagatePropertyChange consumer,
                                          String propertyNameToListen,
                                          String propertyNameToForward) {
        PropagatePropertyChangeListener listener =
                new PropagatePropertyChangeListener(propertyNameToForward,
                                                    consumer);
        producer.addPropertyChangeListener(propertyNameToListen, listener);
    }

    public static void listenAndPropagateAll(AbstractBean producer,
                                             PropagatePropertyChange consumer) {
        PropagatePropertyChangeListener listener =
                new PropagatePropertyChangeListener(null, consumer);
        producer.addPropertyChangeListener(listener);
    }

    private String propertyName;

    private PropagatePropertyChange editor;

    public PropagatePropertyChangeListener(String propertyName,
                                           PropagatePropertyChange editor) {
        this.propertyName = propertyName;
        this.editor = editor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = propertyName == null ? evt.getPropertyName() : propertyName;
        editor.firePropertyChanged(name,
                                   evt.getOldValue(),
                                   evt.getNewValue());
    }
}
