/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.i18n.I18nUtil;
import org.nuiton.i18n.plugin.bundle.BundleValidation;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.Plugin;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginWithEncoding;

public abstract class AbstractI18nMojo
extends AbstractPlugin
implements PluginWithEncoding {
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="i18n.bundles", defaultValue="fr_FR,en_GB", required=true)
    protected String bundles;
    @Parameter(property="i18n.encoding", defaultValue="${project.build.sourceEncoding}", required=true)
    protected String encoding;
    @Parameter(property="i18n.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="i18n.silent", defaultValue="false")
    protected boolean silent;
    protected Locale[] locales;

    protected boolean checkPackaging() {
        boolean result = !this.acceptPackaging(new Plugin.Packaging[]{Plugin.Packaging.pom});
        return result;
    }

    public void init() throws Exception {
        if (this.verbose) {
            this.silent = false;
            this.getLog().info((CharSequence)"config - verbose mode is on");
        }
        this.locales = I18nUtil.parseLocales((String)this.bundles);
        if (this.locales == null || this.locales.length == 0) {
            throw new IllegalStateException("You need at least one locale, please fill the 'bundles' property.");
        }
    }

    protected void checkBundle(Locale locale, Properties propertiesOut, boolean showEmpty, BundleValidation bundleValidation) {
        SortedSet emptyEntries = PluginHelper.getEmptyKeys((Map)propertiesOut);
        if (!emptyEntries.isEmpty()) {
            if (bundleValidation != null) {
                Map<Locale, SortedSet<String>> unsafeHolder = bundleValidation.getKeysMissingValues();
                SortedSet<String> empties = unsafeHolder.get(locale);
                if (empties == null) {
                    empties = new TreeSet<String>();
                    unsafeHolder.put(locale, empties);
                }
                empties.addAll(emptyEntries);
            }
            StringBuilder buffer = new StringBuilder();
            int size = emptyEntries.size();
            buffer.append("bundle ");
            buffer.append(locale);
            buffer.append(" contains ");
            buffer.append(size);
            buffer.append("/");
            buffer.append(propertiesOut.size());
            buffer.append(" empty entries!");
            if (showEmpty) {
                int index = 0;
                for (String key : emptyEntries) {
                    buffer.append("\n  - ");
                    buffer.append(index++);
                    buffer.append("/");
                    buffer.append(size);
                    buffer.append(" : ");
                    buffer.append(key);
                }
            } else {
                buffer.append(" (use -Di18n.showEmpty to see these entries)");
            }
            this.getLog().warn((CharSequence)buffer.toString());
        } else if (!this.silent && this.verbose) {
            this.getLog().info((CharSequence)("bundle " + locale + " is valid (no empty entries)."));
        }
    }

    public File getBackupFile(File file) {
        return new File(file.getAbsolutePath() + "~");
    }

    protected void backupFile(File f) throws IOException {
        File dst = this.getBackupFile(f);
        this.copyFile(f, dst);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void failsIfWarning(boolean failsIfWarning, BundleValidation bundleValidation) throws MojoFailureException {
        if (!failsIfWarning) {
            return;
        }
        if (bundleValidation != null && bundleValidation.isFail()) {
            throw new MojoFailureException("Bundles for locale(s) " + bundleValidation.getKeysMissingValues().keySet() + " are not complete. Use the -Di18n.showEmpty to see missing translations.");
        }
    }
}

