/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="check-auto-container", defaultPhase=LifecyclePhase.VALIDATE, requiresProject=true, requiresOnline=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class CheckAutoContainerPlugin
extends AbstractPlugin {
    @Parameter
    protected Map<String, String> repositories;
    @Parameter(property="addMavenCentral", defaultValue="false")
    protected boolean addMavenCentral;
    @Parameter(property="helper.failIfNotSafe", defaultValue="false")
    protected boolean failIfNotSafe;
    @Parameter(property="helper.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="helper.runOnce", defaultValue="true")
    protected boolean runOnce;
    @Parameter(property="helper.runOnlyOnRoot", defaultValue="true")
    protected boolean runOnlyOnRoot;
    @Parameter(property="helper.skipCheckAutocontainer", defaultValue="false")
    protected boolean skipCheckAutocontainer;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="reactorProjects", readonly=true)
    protected List<?> reactorProjects;
    @Parameter(property="settings.activeProxy", required=true, readonly=true)
    protected Proxy proxy;
    @Component
    protected ArtifactRepositoryFactory artifactRepositoryFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    private List<ArtifactRepository> safeRepositories;
    private List<Artifact> artifacts;
    private static Map<String, List<String>> resolved;
    public static final String MAVEN_CENTRAL_ID = "maven-central";
    public static final String MAVEN_CENTRAL_URL = "https://repo1.maven.org/maven2/";

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void init() throws Exception {
        if (this.isGoalSkip()) {
            return;
        }
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setVerbose(true);
        }
        this.safeRepositories = this.createSafeRepositories();
        this.artifacts = this.prepareArtifacts();
        if (this.isVerbose()) {
            log.info((CharSequence)(this.artifacts.size() + " detected dependencies : "));
            for (Artifact artifact : this.artifacts) {
                log.info((CharSequence)(" - " + artifact));
            }
        }
    }

    protected boolean checkSkip() {
        if (this.isGoalSkip()) {
            this.getLog().info((CharSequence)"Skipping goal (skipCheckAutocontainer flag is on).");
            return false;
        }
        StringBuilder buffer = new StringBuilder("check-auto-container##");
        Artifact artifact = this.project.getArtifact();
        buffer.append(artifact.getGroupId()).append(":");
        buffer.append(artifact.getArtifactId()).append(":");
        buffer.append(artifact.getVersion()).append("##");
        String key = buffer.toString();
        boolean shouldInvoke = this.needInvoke(this.runOnce, this.runOnlyOnRoot, key);
        if (!shouldInvoke) {
            this.getLog().info((CharSequence)"Skipping goal (runOnce flag is on and goal was already executed).");
            return false;
        }
        if (this.artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Skipping goal (Project has no dependecy).");
            return false;
        }
        if (this.repositories.isEmpty()) {
            this.getLog().info((CharSequence)"Skipping goal (No repository defined).");
            return false;
        }
        return super.checkSkip();
    }

    protected void doAction() throws Exception {
        Log log = this.getLog();
        log.info((CharSequence)(this.artifacts.size() + " dependencies to check."));
        for (ArtifactRepository repository : this.safeRepositories) {
            if (this.artifacts.isEmpty()) continue;
            long t0 = System.nanoTime();
            String url = repository.getUrl();
            List<String> ids = this.getRepositoryCache(url);
            if (this.verbose) {
                log.info((CharSequence)("Use repository " + url));
            }
            List<Artifact> found = this.checkDependency(repository, ids);
            long delay = System.nanoTime() - t0;
            String message = found.isEmpty() ? "No artifact resolved by the repository " + url : String.format("%1$4s artifact(s) resolved by repository %2$s in %3$s", found.size(), url, PluginHelper.convertTime((long)delay));
            log.info((CharSequence)message);
            this.artifacts.removeAll(found);
        }
        boolean safe = this.artifacts.isEmpty();
        if (safe) {
            log.info((CharSequence)"All dependencies are safe.");
            return;
        }
        log.warn((CharSequence)("There is " + this.artifacts.size() + " unsafe dependencie(s) :"));
        for (Artifact artifact : this.artifacts) {
            log.warn((CharSequence)(" - " + artifact));
        }
        if (this.failIfNotSafe) {
            throw new MojoFailureException("There is still some unsafe dependencies.");
        }
    }

    protected List<ArtifactRepository> createSafeRepositories() {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        DefaultRepositoryLayout repositoryLayout = new DefaultRepositoryLayout();
        if (this.repositories == null) {
            this.repositories = new TreeMap<String, String>();
        }
        ArrayList<String> ids = new ArrayList<String>(this.repositories.keySet());
        if (this.addMavenCentral) {
            ids.add(0, MAVEN_CENTRAL_ID);
            this.repositories.put(MAVEN_CENTRAL_ID, MAVEN_CENTRAL_URL);
        }
        for (String id : ids) {
            String url = this.repositories.get(id).trim();
            ArtifactRepository repo = this.artifactRepositoryFactory.createDeploymentArtifactRepository(String.valueOf(id), url, (ArtifactRepositoryLayout)repositoryLayout, true);
            this.getLog().info((CharSequence)("Will use repository " + repo.getUrl()));
            if (this.verbose) {
                this.getLog().info((CharSequence)repo.toString());
            }
            result.add(repo);
        }
        return result;
    }

    protected List<Artifact> prepareArtifacts() {
        Artifact artifact;
        Artifact a;
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        ArrayList<String> siblings = new ArrayList<String>();
        if (this.reactorProjects != null) {
            for (Object o : this.reactorProjects) {
                MavenProject m = (MavenProject)o;
                siblings.add(this.getArtifactId(m.getArtifact()));
            }
        }
        for (Object o : this.project.getArtifacts()) {
            a = (Artifact)o;
            artifact = this.acceptArtifact(a, siblings);
            if (artifact == null) continue;
            result.add(a);
        }
        for (Object o : this.project.getPluginArtifacts()) {
            a = (Artifact)o;
            artifact = this.acceptArtifact(a, siblings);
            if (artifact == null) continue;
            result.add(a);
        }
        return result;
    }

    protected Artifact acceptArtifact(Artifact a, List<String> siblings) {
        String id = this.getArtifactId(a);
        if (siblings.contains(id)) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("Skip sibling dependency : " + id));
            }
            return null;
        }
        if (a.isSnapshot()) {
            this.getLog().warn((CharSequence)("Skip SNAPSHOT dependency : " + id));
            return null;
        }
        Artifact artifact = ArtifactUtils.copyArtifact((Artifact)a);
        artifact.setResolved(false);
        return artifact;
    }

    private List<Artifact> checkDependency(ArtifactRepository repo, List<String> ids) throws Exception {
        Log log = this.getLog();
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : this.artifacts) {
            boolean found;
            String id;
            boolean inCache;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)(" - check artifact : " + artifact));
            }
            if (inCache = ids.contains(id = this.getArtifactId(artifact))) {
                found = true;
            } else {
                ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                request.setForceUpdate(true);
                request.setRemoteRepositories(Collections.singletonList(repo));
                if (this.proxy != null) {
                    request.setProxies(Collections.singletonList(this.proxy));
                }
                request.setArtifact(artifact);
                ArtifactResolutionResult resolutionResult = this.artifactResolver.resolve(request);
                found = resolutionResult.isSuccess();
            }
            if (found) {
                if (this.verbose) {
                    log.info((CharSequence)(" - [ resolved ] " + artifact + (inCache ? " (from cache)" : "")));
                }
                result.add(artifact);
                ids.add(id);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((CharSequence)(" - [unresolved] " + artifact));
        }
        return result;
    }

    protected String getArtifactId(Artifact artifact) {
        String id = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        return id;
    }

    protected List<String> getRepositoryCache(String url) {
        List<String> ids;
        if (resolved == null) {
            resolved = new TreeMap<String, List<String>>();
        }
        if ((ids = resolved.get(url)) == null) {
            ids = new ArrayList<String>();
            resolved.put(url, ids);
        }
        return ids;
    }

    protected ProxyInfo getProxyInfo() {
        ProxyInfo proxyInfo = null;
        if (this.proxy != null && !StringUtils.isEmpty((String)this.proxy.getHost())) {
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(this.proxy.getHost());
            proxyInfo.setType(this.proxy.getProtocol());
            proxyInfo.setPort(this.proxy.getPort());
            proxyInfo.setNonProxyHosts(this.proxy.getNonProxyHosts());
            proxyInfo.setUserName(this.proxy.getUsername());
            proxyInfo.setPassword(this.proxy.getPassword());
        }
        return proxyInfo;
    }

    protected boolean isGoalSkip() {
        return this.skipCheckAutocontainer;
    }
}

