/**
 * *##% guix-compiler-gwt
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.nuiton.guix;

//~--- non-JDK imports --------------------------------------------------------

import org.nuiton.guix.tags.gwt.PanelHandler;
import org.nuiton.guix.tags.gwt.ApplicationHandler;
import org.nuiton.guix.tags.gwt.CellHandler;
import org.nuiton.guix.tags.gwt.RowHandler;
import org.nuiton.guix.tags.gwt.TableHandler;
import org.nuiton.guix.tags.TagManager;
import org.nuiton.guix.tags.gwt.ButtonHandler;
import org.nuiton.guix.tags.gwt.CheckBoxHandler;
import org.nuiton.guix.tags.gwt.ComboBoxHandler;
import org.nuiton.guix.tags.gwt.DialogBoxHandler;
import org.nuiton.guix.tags.gwt.HorizontalSplitPanelHandler;
import org.nuiton.guix.tags.gwt.LabelHandler;
import org.nuiton.guix.tags.gwt.ListHandler;
import org.nuiton.guix.tags.gwt.MenuBarHandler;
import org.nuiton.guix.tags.gwt.MenuHandler;
import org.nuiton.guix.tags.gwt.MenuItemHandler;
import org.nuiton.guix.tags.gwt.PasswordFieldHandler;
import org.nuiton.guix.tags.gwt.ProgressBarHandler;
import org.nuiton.guix.tags.gwt.RadioButtonHandler;
import org.nuiton.guix.tags.gwt.ScrollPanelHandler;
import org.nuiton.guix.tags.gwt.TabHandler;
import org.nuiton.guix.tags.gwt.TabPanelHandler;
import org.nuiton.guix.tags.gwt.TextAreaHandler;
import org.nuiton.guix.tags.gwt.TextFieldHandler;
import org.nuiton.guix.tags.gwt.ToggleButtonHandler;
import org.nuiton.guix.tags.gwt.TreeHandler;
import org.nuiton.guix.tags.gwt.TreeNodeHandler;
import org.nuiton.guix.tags.gwt.VerticalSplitPanelHandler;

/**
 * Initialize the application
 *
 * @author kmorin
 */
public class GwtGuixInitializer {
    public static void initialize() {
       TagManager.registerGuixClassHandler("Application", ApplicationHandler.class);
       TagManager.registerGuixClassHandler("Table", TableHandler.class);
       TagManager.registerGuixClassHandler("Row", RowHandler.class);
       TagManager.registerGuixClassHandler("Cell", CellHandler.class);
       TagManager.registerGuixClassHandler("Panel", PanelHandler.class);
       TagManager.registerGuixClassHandler("DialogBox", DialogBoxHandler.class);    
       TagManager.registerGuixClassHandler("ScrollPanel", ScrollPanelHandler.class);
       TagManager.registerGuixClassHandler("HorizontalSplitPanel", HorizontalSplitPanelHandler.class);
       TagManager.registerGuixClassHandler("VerticalSplitPanel", VerticalSplitPanelHandler.class);
       TagManager.registerGuixClassHandler("Button", ButtonHandler.class);
       TagManager.registerGuixClassHandler("TextField", TextFieldHandler.class);
       TagManager.registerGuixClassHandler("TextArea", TextAreaHandler.class);
       TagManager.registerGuixClassHandler("Label", LabelHandler.class);
       TagManager.registerGuixClassHandler("ToggleButton", ToggleButtonHandler.class);
       TagManager.registerGuixClassHandler("CheckBox", CheckBoxHandler.class);
       TagManager.registerGuixClassHandler("ComboBox", ComboBoxHandler.class);
       TagManager.registerGuixClassHandler("PasswordField", PasswordFieldHandler.class);
       TagManager.registerGuixClassHandler("ProgressBar", ProgressBarHandler.class);
       TagManager.registerGuixClassHandler("RadioButton", RadioButtonHandler.class);
       TagManager.registerGuixClassHandler("TabPanel", TabPanelHandler.class);
       TagManager.registerGuixClassHandler("Tab", TabHandler.class);
       TagManager.registerGuixClassHandler("Tree", TreeHandler.class);
       TagManager.registerGuixClassHandler("TreeNode", TreeNodeHandler.class);
       TagManager.registerGuixClassHandler("List", ListHandler.class);
       TagManager.registerGuixClassHandler("MenuBar", MenuBarHandler.class);
       TagManager.registerGuixClassHandler("Menu", MenuHandler.class);
       TagManager.registerGuixClassHandler("MenuItem", MenuItemHandler.class);
    }
}

