package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.extension.tagvalue.matcher.EqualsTagValueNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.provider.DefaultTagValueMetadatasProvider;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelPackage;

import java.util.Set;

import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

/**
 * Defines all tag values managed by Java templates.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @plexus.component role="org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider" role-hint="simpleJavaBean"
 * @since 2.5.6
 */
public class SimpleJavaBeanTransformerTagValues extends DefaultTagValueMetadatasProvider {
    @Override
    public String getDescription() {
        return t("eugene.simpleBeanTransformer.tagvalues");
    }

    public enum Store implements TagValueMetadata {

        /**
         * To generate an interface of each simple bean.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #isSimpleBeanSkipGenerateInterface(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.6.2
         */
        simpleBeanGenerateInterface(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanGenerateInterface"), boolean.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To generate a factory of generated simple beans.
         *
         * You must use it on the complete model.
         *
         * @see #isSimpleBeanSkipGenerateFactory(ObjectModel)
         * @since 2.6.2
         */
        simpleBeanGenerateFactory(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanGenerateFactory"), boolean.class, null, ObjectModel.class),

        /**
         * To generate a factory of generated simple beans.
         *
         * You must use it on the complete model.
         *
         * @see #isSimpleBeanSkipGenerateDefaults(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.7.2
         */
        simpleBeanGenerateDefaults(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanGenerateDefaults"), boolean.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * Tag value to use a super class for generated bean.
         *
         * If the bean needs Property change support (says you use the tag-value {@link EugeneJavaTagValues.Store#generatePropertyChangeSupport},
         * then your class must provide evrything for it.
         *
         * More over, if you use some collections in your bean you must also define
         * two method named {@code getChild(Collection list, int index)} and
         * {@code getChild(List list, int index)}
         *
         * See new code to know minimum stuff to add in your class for this purpose.
         * <pre>
         * public abstract class AbstractBean implements Serializable {
         *
         *     private static final long serialVersionUID = 1L;
         *
         *     protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
         *
         *     public void addPropertyChangeListener(PropertyChangeListener listener) {
         *         pcs.addPropertyChangeListener(listener);
         *     }
         *
         *     public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
         *         pcs.addPropertyChangeListener(propertyName, listener);
         *     }
         *
         *     public void removePropertyChangeListener(PropertyChangeListener listener) {
         *         pcs.removePropertyChangeListener(listener);
         *     }
         *
         *     public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
         *         pcs.removePropertyChangeListener(propertyName, listener);
         *     }
         *
         *     protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
         *         pcs.firePropertyChange(propertyName, oldValue, newValue);
         *     }
         *
         *     protected void firePropertyChange(String propertyName, Object newValue) {
         *         firePropertyChange(propertyName, null, newValue);
         *     }
         *
         *     protected &lt;T&gt; T getChild(Collection&lt;T&gt; list, int index) {
         *         return CollectionUtil.getOrNull(list, index);
         *     }
         *
         *     protected &lt;T&gt; T getChild(List&lt;T&gt; list, int index) {
         *         return CollectionUtil.getOrNull(list, index);
         *     }
         * }
         * </pre>
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.5.6
         */
        simpleBeanSuperClass(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanSuperClass"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a prefix on the name of each generated bean class.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanClassNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.6.2
         */
        simpleBeanClassNamePrefix(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanClassNamePrefix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a prefix on the name of each generated bean class.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanClassNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.6.2
         */
        simpleBeanClassNameSuffix(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanClassNameSuffix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * Tag value to use a super interface for generated interfaces on simple bean.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanInterfaceSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.6.2
         */
        simpleBeanInterfaceSuperClass(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanInterfaceSuperClass"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a prefix on the name of each generated interface of a simple bean.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanInterfaceNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.6.2
         */
        simpleBeanInterfaceNamePrefix(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanInterfaceNamePrefix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a prefix on the name of each generated interface of a simple bean.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanInterfaceNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.6.2
         */
        simpleBeanInterfaceNameSuffix(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanInterfaceNameSuffix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * Tag value to use a super super-class for generated defaults class of a
         * simple bean.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanDefaultsSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.7.2
         */
        simpleBeanDefaultsSuperClass(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanDefaultsSuperClass"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a prefix on the name of each generated bean class.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanDefaultsClassNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.7.2
         */
        simpleBeanDefaultsClassNamePrefix(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanDefaultsClassNamePrefix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a suffix on the name of each generated bean class.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanDefaultsClassNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 2.6.2
         */
        simpleBeanDefaultsClassNameSuffix(n("eugene.simpleBeanTransformer.tagvalue.simpleBeanDefaultsClassNameSuffix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),;

        private final Set<Class<?>> targets;
        private final Class<?> type;
        private final String i18nDescriptionKey;
        private final String defaultValue;

        Store(String i18nDescriptionKey, Class<?> type, String defaultValue, Class<?>... targets) {
            this.targets = ImmutableSet.copyOf(targets);
            this.type = type;
            this.i18nDescriptionKey = i18nDescriptionKey;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return name();
        }

        @Override
        public Set<Class<?>> getTargets() {
            return targets;
        }

        @Override
        public Class<?> getType() {
            return type;
        }

        @Override
        public Class<EqualsTagValueNameMatcher> getMatcherClass() {
            return EqualsTagValueNameMatcher.class;
        }

        @Override
        public String getDescription() {
            return t(i18nDescriptionKey);
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

    }

    public SimpleJavaBeanTransformerTagValues() {
        super((TagValueMetadata[]) Store.values());
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanSuperClass} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanSuperClass
     * @since 2.6.2
     */
    public String getSimpleBeanSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanSuperClass, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanInterfaceSuperClass} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanInterfaceSuperClass
     * @since 2.6.2
     */
    public String getSimpleBeanInterfaceSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanInterfaceSuperClass, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanClassNamePrefix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanClassNamePrefix
     * @since 2.6.2
     */
    public String getSimpleBeanClassNamePrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanClassNamePrefix, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanClassNameSuffix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanClassNameSuffix
     * @since 2.6.2
     */
    public String getSimpleBeanClassNameSuffixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanClassNameSuffix, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanInterfaceNamePrefix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanInterfaceNamePrefix
     * @since 2.6.2
     */
    public String getSimpleBeanInterfaceNamePrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanInterfaceNamePrefix, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanInterfaceNameSuffix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanInterfaceNameSuffix
     * @since 2.6.2
     */
    public String getSimpleBeanInterfaceNameSuffixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanInterfaceNameSuffix, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanDefaultsSuperClass} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanDefaultsSuperClass
     * @since 2.7.2
     */
    public String getSimpleBeanDefaultsSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanDefaultsSuperClass, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanDefaultsClassNamePrefix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanDefaultsClassNamePrefix
     * @since 2.7.2
     */
    public String getSimpleBeanDefaultsClassNamePrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanDefaultsClassNamePrefix, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanDefaultsClassNameSuffix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * <strong>If not filled, then use default {@code s} value.</strong>
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanDefaultsClassNameSuffix
     * @since 2.6.2
     */
    public String getSimpleBeanDefaultsClassNameSuffixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValueUtil.findTagValue(Store.simpleBeanDefaultsClassNameSuffix, classifier, aPackage, model);
        if (StringUtils.isBlank(value)) {
            value = "s";
        }
        return value;
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanGenerateInterface} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanGenerateInterface
     * @since 2.3
     */
    public boolean isSimpleBeanSkipGenerateInterface(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue(Store.simpleBeanGenerateInterface, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanGenerateFactory} tag value on the given model or classifier.
     *
     * @param model model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanGenerateFactory
     * @since 2.7.2
     */
    public boolean isSimpleBeanSkipGenerateFactory(ObjectModel model) {
        return TagValueUtil.findBooleanTagValue(Store.simpleBeanGenerateFactory, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanGenerateDefaults} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanGenerateDefaults
     * @since 2.7.2
     */
    public boolean isSimpleBeanSkipGenerateDefaults(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue(Store.simpleBeanGenerateDefaults, classifier, aPackage, model);
    }

}
