/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.hopscotch.IntArrayBasedKeyTable;
import org.neo4j.collection.primitive.hopscotch.Table;

public class IntKeyLongValueTable
extends IntArrayBasedKeyTable<long[]> {
    public static final long NULL = -1L;

    public IntKeyLongValueTable(int capacity) {
        super(capacity, 4, 32, new long[]{-1L});
    }

    @Override
    public long key(int index) {
        return this.table[this.address(index)];
    }

    @Override
    protected void internalPut(int actualIndex, long key, long[] valueHolder) {
        this.table[actualIndex] = (int)key;
        this.putLong(actualIndex + 1, valueHolder[0]);
    }

    @Override
    public long[] value(int index) {
        ((long[])this.singleValue)[0] = this.getLong(this.address(index) + 1);
        return (long[])this.singleValue;
    }

    @Override
    public long[] putValue(int index, long[] value) {
        ((long[])this.singleValue)[0] = this.putLong(this.address(index) + 1, value[0]);
        return (long[])this.singleValue;
    }

    @Override
    protected Table<long[]> newInstance(int newCapacity) {
        return new IntKeyLongValueTable(newCapacity);
    }
}

