/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMuleMessageFactory;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.ReleasingInputStream;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.IOUtils;
import org.mule.util.PropertiesUtils;

public class HttpMuleMessageFactory
extends AbstractMuleMessageFactory {
    private static Log log = LogFactory.getLog(HttpMuleMessageFactory.class);
    private static final String DEFAULT_ENCODING = "UTF-8";
    private boolean enableCookies = false;
    private String cookieSpec;
    private MessageExchangePattern exchangePattern = MessageExchangePattern.REQUEST_RESPONSE;

    public HttpMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{HttpRequest.class, HttpMethod.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        if (transportMessage instanceof HttpRequest) {
            return this.extractPayloadFromHttpRequest((HttpRequest)transportMessage);
        }
        if (transportMessage instanceof HttpMethod) {
            return this.extractPayloadFromHttpMethod((HttpMethod)transportMessage);
        }
        throw new MessageTypeNotSupportedException(transportMessage, ((Object)((Object)this)).getClass());
    }

    protected Object extractPayloadFromHttpRequest(HttpRequest httpRequest) throws IOException {
        Object body = httpRequest.getBody();
        if (body == null) {
            body = httpRequest.getRequestLine().getUri();
        } else if (!this.exchangePattern.hasResponse()) {
            log.debug((Object)"Reading HTTP POST InputStream into byte[] for asynchronous messaging.");
            body = IOUtils.toByteArray((InputStream)((InputStream)body));
        }
        return body;
    }

    protected Object extractPayloadFromHttpMethod(HttpMethod httpMethod) throws IOException {
        InputStream body = httpMethod.getResponseBodyAsStream();
        if (body != null) {
            return new ReleasingInputStream(body, httpMethod);
        }
        return "";
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        Map<String, Object> headers;
        String uri;
        HttpVersion httpVersion;
        String method;
        String statusCode = null;
        HashMap<String, HashMap<String, Object>> httpHeaders = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Map<String, Object>> queryParameters = new HashMap<String, Map<String, Object>>();
        if (transportMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)transportMessage;
            method = httpRequest.getRequestLine().getMethod();
            httpVersion = httpRequest.getRequestLine().getHttpVersion();
            uri = httpRequest.getRequestLine().getUri();
            headers = this.convertHeadersToMap(httpRequest.getHeaders(), uri);
            this.convertMultiPartHeaders(headers);
        } else if (transportMessage instanceof HttpMethod) {
            HttpMethod httpMethod = (HttpMethod)transportMessage;
            method = httpMethod.getName();
            httpVersion = HttpVersion.parse((String)httpMethod.getStatusLine().getHttpVersion());
            uri = httpMethod.getURI().toString();
            statusCode = String.valueOf(httpMethod.getStatusCode());
            headers = this.convertHeadersToMap(httpMethod.getResponseHeaders(), uri);
        } else {
            throw new MessageTypeNotSupportedException(transportMessage, ((Object)((Object)this)).getClass());
        }
        this.rewriteConnectionAndKeepAliveHeaders(headers);
        headers = this.processIncomingHeaders(headers);
        httpHeaders.put("http.headers", new HashMap<String, Object>(headers));
        String encoding = this.getEncoding(headers);
        queryParameters.put("http.query.params", this.processQueryParams(uri, encoding));
        this.addUriParamsAsHeaders(headers, uri);
        headers.put("http.method", method);
        headers.put("http.request", uri);
        headers.put("http.version", httpVersion.toString());
        if (this.enableCookies) {
            headers.put("cookieSpec", this.cookieSpec);
        }
        if (statusCode != null) {
            headers.put("http.status", statusCode);
        }
        message.addInboundProperties(headers);
        message.addInboundProperties(httpHeaders);
        message.addInboundProperties(queryParameters);
        this.initEncoding((MuleMessage)message, encoding);
    }

    protected Map<String, Object> processIncomingHeaders(Map<String, Object> headers) throws Exception {
        HashMap<String, Object> outHeaders = new HashMap<String, Object>();
        for (Map.Entry<String, Object> header : headers.entrySet()) {
            String headerName = header.getKey();
            if (headerName.startsWith("X-MULE")) {
                headerName = headerName.substring(2);
            }
            outHeaders.put(headerName, header.getValue());
        }
        return outHeaders;
    }

    Map<String, Object> convertHeadersToMap(Header[] headersArray, String uri) throws URISyntaxException {
        CaseInsensitiveHashMap headersMap = new CaseInsensitiveHashMap();
        for (int i = 0; i < headersArray.length; ++i) {
            Header header = headersArray[i];
            if ("cookies".equals(header.getName()) || "Cookie".equals(header.getName())) {
                this.putCookieHeaderInMapAsAServer((Map<String, Object>)headersMap, header, uri);
                continue;
            }
            if ("Set-Cookie".equals(header.getName())) {
                this.putCookieHeaderInMapAsAClient((Map<String, Object>)headersMap, header, uri);
                continue;
            }
            if (headersMap.containsKey(header.getName())) {
                if (headersMap.get(header.getName()) instanceof String) {
                    headersMap.put(header.getName(), headersMap.get(header.getName()) + "," + header.getValue());
                    continue;
                }
                headersMap.put(header.getName(), header.getValue());
                continue;
            }
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }

    private void putCookieHeaderInMapAsAClient(Map<String, Object> headersMap, Header header, String uri) throws URISyntaxException {
        try {
            Cookie[] newCookies = CookieHelper.parseCookiesAsAClient(header.getValue(), this.cookieSpec, new URI(uri));
            Object preExistentCookies = headersMap.get("Set-Cookie");
            Object mergedCookie = CookieHelper.putAndMergeCookie(preExistentCookies, newCookies);
            headersMap.put("Set-Cookie", mergedCookie);
        }
        catch (MalformedCookieException e) {
            log.warn((Object)("Received an invalid cookie: " + header), (Throwable)e);
        }
    }

    private void putCookieHeaderInMapAsAServer(Map<String, Object> headersMap, Header header, String uri) throws URISyntaxException {
        Cookie[] newCookies;
        if (this.enableCookies && (newCookies = CookieHelper.parseCookiesAsAServer(header.getValue(), new URI(uri))).length > 0) {
            Object oldCookies = headersMap.get("cookies");
            Object mergedCookies = CookieHelper.putAndMergeCookie(oldCookies, newCookies);
            headersMap.put("cookies", mergedCookies);
        }
    }

    private String getEncoding(Map<String, Object> headers) {
        NameValuePair param;
        Header contentTypeHeader;
        HeaderElement[] values;
        String encoding = DEFAULT_ENCODING;
        Object contentType = headers.get("Content-Type");
        if (contentType != null && (values = (contentTypeHeader = new Header("Content-Type", contentType.toString())).getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            encoding = param.getValue();
        }
        return encoding;
    }

    private void initEncoding(MuleMessage message, String encoding) {
        message.setEncoding(encoding);
    }

    private void rewriteConnectionAndKeepAliveHeaders(Map<String, Object> headers) {
        String connection;
        String headerValue = !this.isHttp11(headers) ? ((connection = (String)headers.get("Connection")) != null && connection.equalsIgnoreCase("close") ? Boolean.FALSE.toString() : Boolean.TRUE.toString()) : (headers.get("Connection") != null ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        headers.put("Connection", headerValue);
        headers.put("Keep-Alive", headerValue);
    }

    private boolean isHttp11(Map<String, Object> headers) {
        String httpVersion = (String)headers.get("http.version");
        return !"HTTP/1.0".equalsIgnoreCase(httpVersion);
    }

    protected void addUriParamsAsHeaders(Map headers, String uri) {
        int i = uri.indexOf("?");
        String queryString = "";
        if (i > -1) {
            queryString = uri.substring(i + 1);
            headers.putAll(PropertiesUtils.getPropertiesFromQueryString((String)queryString));
        }
        headers.put("http.query.string", queryString);
    }

    protected Map<String, Object> processQueryParams(String uri, String encoding) throws UnsupportedEncodingException {
        HashMap<String, Object> httpParams = new HashMap<String, Object>();
        int i = uri.indexOf("?");
        if (i > -1) {
            String queryString = uri.substring(i + 1);
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int idx = token.indexOf(61);
                if (idx < 0) {
                    this.addQueryParamToMap(httpParams, this.unescape(token, encoding), null);
                    continue;
                }
                if (idx <= 0) continue;
                this.addQueryParamToMap(httpParams, this.unescape(token.substring(0, idx), encoding), this.unescape(token.substring(idx + 1), encoding));
            }
        }
        return httpParams;
    }

    private void addQueryParamToMap(Map<String, Object> httpParams, String key, String value) {
        Object existingValue = httpParams.get(key);
        if (existingValue == null) {
            httpParams.put(key, value);
        } else if (existingValue instanceof List) {
            List list = (List)existingValue;
            list.add(value);
        } else if (existingValue instanceof String) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)existingValue);
            list.add(value);
            httpParams.put(key, list);
        }
    }

    private String unescape(String escapedValue, String encoding) throws UnsupportedEncodingException {
        if (escapedValue != null) {
            return URLDecoder.decode(escapedValue, encoding);
        }
        return escapedValue;
    }

    protected void convertMultiPartHeaders(Map<String, Object> headers) {
    }

    public void setEnableCookies(boolean enableCookies) {
        this.enableCookies = enableCookies;
    }

    public void setCookieSpec(String cookieSpec) {
        this.cookieSpec = cookieSpec;
    }

    public void setExchangePattern(MessageExchangePattern mep) {
        this.exchangePattern = mep;
    }
}

