/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import com.sun.mail.imap.IMAPMessage;
import java.net.URLDecoder;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.email.AbstractRetrieveMailConnector;

public class RetrieveMessageRequester
extends AbstractMessageRequester {
    private Folder folder;
    private Folder moveToFolder;

    public RetrieveMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
    }

    private AbstractRetrieveMailConnector castConnector() {
        return (AbstractRetrieveMailConnector)this.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.folder == null || !this.folder.isOpen()) {
            Store store = this.castConnector().getSessionDetails(this.endpoint).newStore();
            EndpointURI uri = this.endpoint.getEndpointURI();
            String encoding = this.endpoint.getEncoding();
            String user = uri.getUser() != null ? URLDecoder.decode(uri.getUser(), encoding) : null;
            String pass = uri.getPassword() != null ? URLDecoder.decode(uri.getPassword(), encoding) : null;
            store.connect(uri.getHost(), uri.getPort(), user, pass);
            this.folder = store.getFolder(this.castConnector().getMailboxFolder());
            this.ensureFolderIsOpen(this.folder);
            if (this.castConnector().getMoveToFolder() != null) {
                this.moveToFolder = store.getFolder(this.castConnector().getMoveToFolder());
                this.ensureFolderIsOpen(this.moveToFolder);
            }
        }
    }

    protected void ensureFolderIsOpen(Folder fldr) {
        if (!fldr.isOpen()) {
            try {
                fldr.open(2);
            }
            catch (MessagingException e) {
                this.logger.warn((Object)("Failed to open folder: " + fldr.getFullName() + " This is not an exception since some server implementations do not require the folder to be open"), (Throwable)e);
            }
        }
    }

    protected void doDisconnect() throws Exception {
        block8: {
            try {
                block9: {
                    if (this.folder == null) break block8;
                    try {
                        this.folder.expunge();
                    }
                    catch (MessagingException e) {
                        if (!this.logger.isDebugEnabled()) break block9;
                        this.logger.debug((Object)("ignoring exception on expunge: " + e.getMessage()));
                    }
                }
                if (this.folder.isOpen()) {
                    this.folder.close(true);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to close inbox: " + e.getMessage()), (Throwable)e);
            }
        }
        try {
            if (this.moveToFolder != null && this.moveToFolder.isOpen()) {
                this.moveToFolder.close(false);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to close moveToFolder: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        throw new UnsupportedOperationException("Cannot dispatch from a POP3/IMAP connection");
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        throw new UnsupportedOperationException("Cannot send from a POP3/IMAP connection");
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        long t0 = System.currentTimeMillis();
        if (timeout < 0L) {
            timeout = Long.MAX_VALUE;
        }
        while (true) {
            long sleep;
            if (this.hasMessages()) {
                int count = this.getMessageCount();
                if (count > 0) {
                    Message message = this.getNextMessage();
                    if (message != null) {
                        this.flagMessage(message);
                        if (this.moveToFolder != null) {
                            Message newMessage = message;
                            if (message instanceof IMAPMessage) {
                                newMessage = new MimeMessage((MimeMessage)((IMAPMessage)message));
                            }
                            this.folder.copyMessages(new Message[]{message}, this.moveToFolder);
                            message = newMessage;
                        }
                        return this.createMuleMessage(message, this.endpoint.getEncoding());
                    }
                } else if (count == -1) {
                    throw new MessagingException("Cannot monitor folder: " + this.folder.getFullName() + " as folder is closed");
                }
            }
            if ((sleep = Math.min(this.castConnector().getCheckFrequency(), timeout - (System.currentTimeMillis() - t0))) <= 0L) break;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No results, sleeping for " + sleep));
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                this.logger.warn((Object)("Thread interrupted while requesting email on: " + this.endpoint.getEndpointURI().toString()));
                return null;
            }
        }
        this.logger.debug((Object)"Timeout");
        return null;
    }

    protected void flagMessage(Message message) throws MessagingException {
        if (this.castConnector().isDeleteReadMessages()) {
            message.setFlag(Flags.Flag.DELETED, true);
        } else {
            message.setFlag(Flags.Flag.SEEN, true);
        }
    }

    protected Message getNextMessage() throws MessagingException {
        Message message;
        if (this.getMessageCount() > 0 && !(message = this.folder.getMessage(1)).isExpunged()) {
            return message;
        }
        return null;
    }

    protected int getMessageCount() throws MessagingException {
        return this.folder.getMessageCount();
    }

    protected boolean hasMessages() throws MessagingException {
        return this.getMessageCount() > 0;
    }

    protected void doDispose() {
        if (null != this.folder && this.folder.isOpen()) {
            try {
                this.folder.close(true);
            }
            catch (Exception e) {
                this.logger.debug((Object)("ignoring exception: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

