/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.email.AbstractRetrieveMailConnector;

public class RetrieveMessageRequester
extends AbstractMessageRequester {
    private Folder folder;

    public RetrieveMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
    }

    private AbstractRetrieveMailConnector castConnector() {
        return (AbstractRetrieveMailConnector)this.getConnector();
    }

    protected void doConnect() throws Exception {
        if (this.folder == null || !this.folder.isOpen()) {
            Store store = this.castConnector().getSessionDetails(this.endpoint).newStore();
            EndpointURI uri = this.endpoint.getEndpointURI();
            store.connect(uri.getHost(), uri.getPort(), uri.getUser(), uri.getPassword());
            this.folder = store.getFolder(this.castConnector().getMailboxFolder());
            if (!this.folder.isOpen()) {
                try {
                    this.folder.open(2);
                }
                catch (MessagingException e) {
                    this.logger.warn((Object)("Failed to open folder: " + this.folder.getFullName()), (Throwable)e);
                }
            }
        }
    }

    protected void doDisconnect() throws Exception {
        block5: {
            try {
                block6: {
                    if (this.folder == null) break block5;
                    try {
                        this.folder.expunge();
                    }
                    catch (MessagingException e) {
                        if (!this.logger.isDebugEnabled()) break block6;
                        this.logger.debug((Object)("ignoring exception on expunge: " + e.getMessage()));
                    }
                }
                if (this.folder.isOpen()) {
                    this.folder.close(true);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to close inbox: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        throw new UnsupportedOperationException("Cannot dispatch from a Pop3 connection");
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        throw new UnsupportedOperationException("Cannot send from a Pop3 connection");
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        long t0 = System.currentTimeMillis();
        if (timeout < 0L) {
            timeout = Long.MAX_VALUE;
        }
        while (true) {
            long sleep;
            if (RetrieveMessageRequester.hasMessages(this.folder)) {
                int count = RetrieveMessageRequester.getMessageCount(this.folder);
                if (count > 0) {
                    Message message = RetrieveMessageRequester.getNextMessage(this.folder);
                    this.flagMessage(this.folder, message);
                    return new DefaultMuleMessage((Object)this.castConnector().getMessageAdapter(message));
                }
                if (count == -1) {
                    throw new MessagingException("Cannot monitor folder: " + this.folder.getFullName() + " as folder is closed");
                }
            }
            if ((sleep = Math.min(this.castConnector().getCheckFrequency(), timeout - (System.currentTimeMillis() - t0))) <= 0L) break;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No results, sleeping for " + sleep));
            }
            Thread.sleep(sleep);
        }
        this.logger.debug((Object)"Timeout");
        return null;
    }

    protected void flagMessage(Folder folder, Message message) throws MessagingException {
        message.setFlag(Flags.Flag.DELETED, true);
    }

    protected static Message getNextMessage(Folder folder) throws MessagingException {
        return folder.getMessage(1);
    }

    protected static int getMessageCount(Folder folder) throws MessagingException {
        return folder.getMessageCount();
    }

    protected static boolean hasMessages(Folder folder) throws MessagingException {
        return RetrieveMessageRequester.getMessageCount(folder) > 0;
    }

    protected void doDispose() {
        if (null != this.folder && this.folder.isOpen()) {
            try {
                this.folder.close(true);
            }
            catch (Exception e) {
                this.logger.debug((Object)("ignoring exception: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

