/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.eclipse.jetty.util.IO;
import org.mortbay.jetty.plugin.PluginLog;
import org.mortbay.jetty.plugin.Starter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyRunForkedMojo
extends AbstractMojo {
    public String PORT_SYSPROPERTY = "jetty.port";
    protected boolean useProvidedScope;
    private MavenProject project;
    private boolean useTestScope;
    private String webXml;
    protected File target;
    protected File tmpDirectory;
    private File classesDirectory;
    private File testClassesDirectory;
    private File webAppSourceDirectory;
    private String jettyXml;
    private String contextPath;
    private String contextXml;
    private boolean skip;
    protected int stopPort;
    protected String stopKey;
    private String jvmArgs;
    private List pluginArtifacts;
    private PluginDescriptor plugin;
    private Process forkedProcess;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Configuring Jetty for project: " + this.project.getName()));
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Jetty start: jetty.skip==true");
            return;
        }
        PluginLog.setLog(this.getLog());
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        this.startJettyRunner();
    }

    public List<String> getProvidedJars() throws MojoExecutionException {
        if (this.useProvidedScope) {
            ArrayList<String> provided = new ArrayList<String>();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!"provided".equals(artifact.getScope()) || this.isPluginArtifact(artifact)) continue;
                provided.add(artifact.getFile().getAbsolutePath());
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Adding provided artifact: " + artifact));
            }
            return provided;
        }
        return null;
    }

    public File prepareConfiguration() throws MojoExecutionException {
        try {
            File propsFile = new File(this.target, "fork.props");
            if (propsFile.exists()) {
                propsFile.delete();
            }
            propsFile.createNewFile();
            Properties props = new Properties();
            if (this.webXml != null) {
                props.put("web.xml", this.webXml);
            }
            if (this.contextPath != null) {
                props.put("context.path", this.contextPath);
            }
            if (this.tmpDirectory != null) {
                if (!this.tmpDirectory.exists()) {
                    this.tmpDirectory.mkdirs();
                }
                props.put("tmp.dir", this.tmpDirectory.getAbsolutePath());
            }
            if (this.webAppSourceDirectory != null) {
                props.put("base.dir", this.webAppSourceDirectory.getAbsolutePath());
            }
            List<File> classDirs = this.getClassesDirs();
            StringBuffer strbuff = new StringBuffer();
            for (int i = 0; i < classDirs.size(); ++i) {
                File f = classDirs.get(i);
                strbuff.append(f.getAbsolutePath());
                if (i >= classDirs.size() - 1) continue;
                strbuff.append(",");
            }
            if (this.classesDirectory != null) {
                props.put("classes.dir", this.classesDirectory.getAbsolutePath());
            }
            if (this.useTestScope && this.testClassesDirectory != null) {
                props.put("testClasses.dir", this.testClassesDirectory.getAbsolutePath());
            }
            List<File> deps = this.getDependencyFiles();
            strbuff.setLength(0);
            for (int i = 0; i < deps.size(); ++i) {
                File d = deps.get(i);
                strbuff.append(d.getAbsolutePath());
                if (i >= deps.size() - 1) continue;
                strbuff.append(",");
            }
            props.put("lib.jars", strbuff.toString());
            List<File> overlays = this.getOverlays();
            strbuff.setLength(0);
            for (int i = 0; i < overlays.size(); ++i) {
                File f = overlays.get(i);
                strbuff.append(f.getAbsolutePath());
                if (i >= overlays.size() - 1) continue;
                strbuff.append(",");
            }
            props.put("overlay.files", strbuff.toString());
            props.store(new BufferedOutputStream(new FileOutputStream(propsFile)), "properties for forked webapp");
            return propsFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Prepare webapp configuration", e);
        }
    }

    private List<File> getClassesDirs() {
        ArrayList<File> classesDirs = new ArrayList<File>();
        if (this.useTestScope && this.testClassesDirectory != null) {
            classesDirs.add(this.testClassesDirectory);
        }
        if (this.classesDirectory != null) {
            classesDirs.add(this.classesDirectory);
        }
        return classesDirs;
    }

    private List<File> getOverlays() throws MalformedURLException, IOException {
        ArrayList<File> overlays = new ArrayList<File>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!artifact.getType().equals("war")) continue;
            overlays.add(artifact.getFile());
        }
        return overlays;
    }

    private List<File> getDependencyFiles() {
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (("provided".equals(artifact.getScope()) || "test".equals(artifact.getScope())) && (!this.useTestScope || !"test".equals(artifact.getScope()))) continue;
            dependencyFiles.add(artifact.getFile());
            this.getLog().debug((CharSequence)("Adding artifact " + artifact.getFile().getName() + " for WEB-INF/lib "));
        }
        return dependencyFiles;
    }

    public boolean isPluginArtifact(Artifact artifact) {
        if (this.pluginArtifacts == null || this.pluginArtifacts.isEmpty()) {
            return false;
        }
        boolean isPluginArtifact = false;
        Iterator iter = this.pluginArtifacts.iterator();
        while (iter.hasNext() && !isPluginArtifact) {
            Artifact pluginArtifact = (Artifact)iter.next();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Checking " + pluginArtifact));
            }
            if (!pluginArtifact.getGroupId().equals(artifact.getGroupId()) || !pluginArtifact.getArtifactId().equals(artifact.getArtifactId())) continue;
            isPluginArtifact = true;
        }
        return isPluginArtifact;
    }

    private Set<Artifact> getExtraJars() throws Exception {
        HashSet<Artifact> extraJars = new HashSet<Artifact>();
        List l = this.pluginArtifacts;
        Object pluginArtifact = null;
        if (l != null) {
            Iterator itor = l.iterator();
            while (itor.hasNext() && pluginArtifact == null) {
                Artifact a = (Artifact)itor.next();
                if (!a.getArtifactId().equals(this.plugin.getArtifactId())) continue;
                extraJars.add(a);
            }
        }
        return extraJars;
    }

    public void startJettyRunner() throws MojoExecutionException {
        try {
            String classPath;
            File props = this.prepareConfiguration();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getJavaBin());
            if (this.jvmArgs != null) {
                String[] args = this.jvmArgs.split(" ");
                for (int i = 0; args != null && i < args.length; ++i) {
                    if (args[i] == null || "".equals(args[i])) continue;
                    cmd.add(args[i].trim());
                }
            }
            if ((classPath = this.getClassPath()) != null && classPath.length() > 0) {
                cmd.add("-cp");
                cmd.add(classPath);
            }
            cmd.add(Starter.class.getCanonicalName());
            if (this.stopPort > 0 && this.stopKey != null) {
                cmd.add("--stop-port");
                cmd.add(Integer.toString(this.stopPort));
                cmd.add("--stop-key");
                cmd.add(this.stopKey);
            }
            if (this.jettyXml != null) {
                cmd.add("--jetty-xml");
                cmd.add(this.jettyXml);
            }
            if (this.contextXml != null) {
                cmd.add("--context-xml");
                cmd.add(this.contextXml);
            }
            cmd.add("--props");
            cmd.add(props.getAbsolutePath());
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.directory(this.project.getBasedir());
            if (PluginLog.getLog().isDebugEnabled()) {
                PluginLog.getLog().debug((CharSequence)Arrays.toString(cmd.toArray()));
            }
            this.forkedProcess = builder.start();
            this.startPump("STDOUT", this.forkedProcess.getInputStream());
            this.startPump("STDERR", this.forkedProcess.getErrorStream());
            int exitcode = this.forkedProcess.waitFor();
            PluginLog.getLog().info((CharSequence)("Forked execution exit: " + exitcode));
        }
        catch (InterruptedException ex) {
            if (this.forkedProcess != null) {
                this.forkedProcess.destroy();
            }
            throw new MojoExecutionException("Failed to start Jetty within time limit");
        }
        catch (Exception ex) {
            if (this.forkedProcess != null) {
                this.forkedProcess.destroy();
            }
            throw new MojoExecutionException("Failed to create Jetty process", ex);
        }
    }

    public String getClassPath() throws Exception {
        StringBuilder classPath = new StringBuilder();
        for (Object obj : this.pluginArtifacts) {
            Artifact artifact = (Artifact)obj;
            if (!"jar".equals(artifact.getType())) continue;
            if (classPath.length() > 0) {
                classPath.append(File.pathSeparator);
            }
            classPath.append(artifact.getFile().getAbsolutePath());
        }
        Set<Artifact> extraJars = this.getExtraJars();
        for (Artifact a : extraJars) {
            classPath.append(File.pathSeparator);
            classPath.append(a.getFile().getAbsolutePath());
        }
        List<String> providedJars = this.getProvidedJars();
        if (providedJars != null && !providedJars.isEmpty()) {
            for (String jar : providedJars) {
                classPath.append(File.pathSeparator);
                classPath.append(jar);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Adding provided jar: " + jar));
            }
        }
        return classPath.toString();
    }

    private String getJavaBin() {
        String[] javaexes = new String[]{"java", "java.exe"};
        File javaHomeDir = new File(System.getProperty("java.home"));
        for (String javaexe : javaexes) {
            File javabin = new File(javaHomeDir, JettyRunForkedMojo.fileSeparators("bin/" + javaexe));
            if (!javabin.exists() || !javabin.isFile()) continue;
            return javabin.getAbsolutePath();
        }
        return "java";
    }

    public static String fileSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String pathSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == ',' || c == ':') {
                ret.append(File.pathSeparatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private void startPump(String mode, InputStream inputStream) {
        ConsoleStreamer pump = new ConsoleStreamer(mode, inputStream);
        Thread thread = new Thread((Runnable)pump, "ConsoleStreamer/" + mode);
        thread.start();
    }

    private static class ConsoleStreamer
    implements Runnable {
        private String mode;
        private BufferedReader reader;

        public ConsoleStreamer(String mode, InputStream is) {
            this.mode = mode;
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    System.out.println("[" + this.mode + "] " + line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IO.close((Reader)this.reader);
            }
        }
    }

    public class ShutdownThread
    extends Thread {
        public ShutdownThread() {
            super("RunForkedShutdown");
        }

        public void run() {
            if (JettyRunForkedMojo.this.forkedProcess != null) {
                JettyRunForkedMojo.this.forkedProcess.destroy();
            }
        }
    }
}

