/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.vault;

import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RangeOptions;
import com.mongodb.client.model.vault.TextOptions;
import com.mongodb.internal.crypt.capi.MongoExplicitEncryptOptions;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;

public final class EncryptOptionsHelper {
    public static MongoExplicitEncryptOptions asMongoExplicitEncryptOptions(EncryptOptions options) {
        TextOptions textOptions;
        RangeOptions rangeOptions;
        MongoExplicitEncryptOptions.Builder encryptOptionsBuilder = MongoExplicitEncryptOptions.builder().algorithm(options.getAlgorithm());
        if (options.getKeyId() != null) {
            encryptOptionsBuilder.keyId(options.getKeyId());
        }
        if (options.getKeyAltName() != null) {
            encryptOptionsBuilder.keyAltName(options.getKeyAltName());
        }
        if (options.getContentionFactor() != null) {
            encryptOptionsBuilder.contentionFactor(options.getContentionFactor());
        }
        if (options.getQueryType() != null) {
            encryptOptionsBuilder.queryType(options.getQueryType());
        }
        if ((rangeOptions = options.getRangeOptions()) != null) {
            Integer precision;
            Integer trimFactor;
            Long sparsity;
            BsonValue max;
            BsonDocument rangeOptionsBsonDocument = new BsonDocument();
            BsonValue min = rangeOptions.getMin();
            if (min != null) {
                rangeOptionsBsonDocument.put("min", min);
            }
            if ((max = rangeOptions.getMax()) != null) {
                rangeOptionsBsonDocument.put("max", max);
            }
            if ((sparsity = rangeOptions.getSparsity()) != null) {
                rangeOptionsBsonDocument.put("sparsity", (BsonValue)new BsonInt64(sparsity.longValue()));
            }
            if ((trimFactor = rangeOptions.getTrimFactor()) != null) {
                rangeOptionsBsonDocument.put("trimFactor", (BsonValue)new BsonInt32(trimFactor.intValue()));
            }
            if ((precision = rangeOptions.getPrecision()) != null) {
                rangeOptionsBsonDocument.put("precision", (BsonValue)new BsonInt32(precision.intValue()));
            }
            encryptOptionsBuilder.rangeOptions(rangeOptionsBsonDocument);
        }
        if ((textOptions = options.getTextOptions()) != null) {
            BsonDocument suffixOptions;
            BsonDocument prefixOptions;
            BsonDocument textOptionsDocument = new BsonDocument();
            textOptionsDocument.put("caseSensitive", (BsonValue)BsonBoolean.valueOf((boolean)textOptions.getCaseSensitive()));
            textOptionsDocument.put("diacriticSensitive", (BsonValue)BsonBoolean.valueOf((boolean)textOptions.getDiacriticSensitive()));
            BsonDocument substringOptions = textOptions.getSubstringOptions();
            if (substringOptions != null) {
                textOptionsDocument.put("substring", (BsonValue)substringOptions);
            }
            if ((prefixOptions = textOptions.getPrefixOptions()) != null) {
                textOptionsDocument.put("prefix", (BsonValue)prefixOptions);
            }
            if ((suffixOptions = textOptions.getSuffixOptions()) != null) {
                textOptionsDocument.put("suffix", (BsonValue)suffixOptions);
            }
            encryptOptionsBuilder.textOptions(textOptionsDocument);
        }
        return encryptOptionsBuilder.build();
    }

    private EncryptOptionsHelper() {
    }
}

