/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.putty;

import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.crypto.cipher.AES;
import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.cipher.CBCMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.putty.DEREncoder;
import org.kohsuke.putty.KeyReader;

public class PuTTYKey {
    private static final String PUTTY_SIGNATURE = "PuTTY-User-Key-File-";
    private final byte[] privateKey;
    private final byte[] publicKey;
    private final Map<String, String> headers = new HashMap<String, String>();

    public PuTTYKey(File ppkFile, String passphrase) throws IOException {
        this(new FileReader(ppkFile), passphrase);
    }

    public PuTTYKey(InputStream in, String passphrase) throws IOException {
        this(new InputStreamReader(in), passphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PuTTYKey(Reader in, String passphrase) throws IOException {
        BufferedReader r = new BufferedReader(in);
        HashMap<String, String> payload = new HashMap<String, String>();
        try {
            String line;
            String headerName = null;
            while ((line = r.readLine()) != null) {
                int idx = line.indexOf(": ");
                if (idx > 0) {
                    headerName = line.substring(0, idx);
                    this.headers.put(headerName, line.substring(idx + 2));
                    continue;
                }
                String s = (String)payload.get(headerName);
                s = s == null ? line : s + line;
                payload.put(headerName, s);
            }
        }
        finally {
            r.close();
        }
        boolean encrypted = "aes256-cbc".equals(this.headers.get("Encryption"));
        this.publicKey = PuTTYKey.decodeBase64((String)payload.get("Public-Lines"));
        byte[] privateLines = PuTTYKey.decodeBase64((String)payload.get("Private-Lines"));
        if (encrypted) {
            AES aes = new AES();
            byte[] key = this.toKey(passphrase);
            aes.init(false, key);
            CBCMode cbc = new CBCMode((BlockCipher)aes, new byte[16], false);
            byte[] out = new byte[privateLines.length];
            for (int i = 0; i < privateLines.length / cbc.getBlockSize(); ++i) {
                cbc.transformBlock(privateLines, i * cbc.getBlockSize(), out, i * cbc.getBlockSize());
            }
            privateLines = out;
        }
        this.privateKey = privateLines;
    }

    public String getAlgorithm() {
        return this.headers.get("PuTTY-User-Key-File-2");
    }

    private byte[] toKey(String passphrase) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(new byte[]{0, 0, 0, 0});
            digest.update(passphrase.getBytes());
            byte[] key1 = digest.digest();
            digest.update(new byte[]{0, 0, 0, 1});
            digest.update(passphrase.getBytes());
            byte[] key2 = digest.digest();
            byte[] r = new byte[32];
            System.arraycopy(key1, 0, r, 0, 20);
            System.arraycopy(key2, 0, r, 20, 12);
            return r;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static byte[] decodeBase64(String s) throws IOException {
        return Base64.decode((char[])s.toCharArray());
    }

    public String toOpenSSH() throws IOException {
        if (this.getAlgorithm().equals("ssh-rsa")) {
            KeyReader r = new KeyReader(this.publicKey);
            r.skip();
            BigInteger e = r.readInt();
            BigInteger n = r.readInt();
            r = new KeyReader(this.privateKey);
            BigInteger d = r.readInt();
            BigInteger p = r.readInt();
            BigInteger q = r.readInt();
            BigInteger iqmp = r.readInt();
            BigInteger dmp1 = d.mod(p.subtract(BigInteger.ONE));
            BigInteger dmq1 = d.mod(q.subtract(BigInteger.ONE));
            DEREncoder payload = new DEREncoder().writeSequence(new DEREncoder().write(BigInteger.ZERO, n, e, d, p, q, dmp1, dmq1, iqmp).toByteArray());
            StringBuilder buf = new StringBuilder();
            buf.append("-----BEGIN RSA PRIVATE KEY-----\n");
            buf.append(payload.toBase64());
            buf.append("-----END RSA PRIVATE KEY-----\n");
            return buf.toString();
        }
        if (this.getAlgorithm().equals("ssh-dss")) {
            KeyReader r = new KeyReader(this.publicKey);
            r.skip();
            BigInteger p = r.readInt();
            BigInteger q = r.readInt();
            BigInteger g = r.readInt();
            BigInteger y = r.readInt();
            r = new KeyReader(this.privateKey);
            BigInteger x = r.readInt();
            DEREncoder payload = new DEREncoder().writeSequence(new DEREncoder().write(BigInteger.ZERO, p, q, g, y, x).toByteArray());
            StringBuilder buf = new StringBuilder();
            buf.append("-----BEGIN DSA PRIVATE KEY-----\n");
            buf.append(payload.toBase64());
            buf.append("-----END DSA PRIVATE KEY-----\n");
            return buf.toString();
        }
        throw new IllegalArgumentException("Unrecognized key type: " + this.getAlgorithm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toOpenSSH(File f) throws IOException {
        FileWriter w = new FileWriter(f);
        try {
            w.write(this.toOpenSSH());
        }
        finally {
            w.close();
        }
    }

    public static boolean isPuTTYKeyFile(File ppkFile) throws IOException {
        return PuTTYKey.isPuTTYKeyFile(new FileReader(ppkFile));
    }

    public static boolean isPuTTYKeyFile(InputStream in) throws IOException {
        return PuTTYKey.isPuTTYKeyFile(new InputStreamReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPuTTYKeyFile(Reader _reader) throws IOException {
        BufferedReader r = new BufferedReader(_reader);
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (!line.startsWith(PUTTY_SIGNATURE)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            r.close();
        }
    }
}

