/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization.integration.elytron;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.keycloak.adapters.authorization.TokenPrincipal;
import org.keycloak.adapters.authorization.spi.HttpRequest;

public class ServletHttpRequest
implements HttpRequest {
    private final HttpServletRequest request;
    private final TokenPrincipal tokenPrincipal;
    private InputStream inputStream;

    public ServletHttpRequest(HttpServletRequest request, TokenPrincipal tokenPrincipal) {
        this.request = request;
        this.tokenPrincipal = tokenPrincipal;
    }

    @Override
    public String getRelativePath() {
        String contextPath;
        String uri = this.request.getRequestURI();
        String servletPath = uri.substring(uri.indexOf(contextPath = this.request.getContextPath()) + contextPath.length());
        if ("".equals(servletPath)) {
            servletPath = "/";
        }
        return servletPath;
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getURI() {
        return this.request.getRequestURI();
    }

    @Override
    public List<String> getHeaders(String name) {
        return Collections.list(this.request.getHeaders(name));
    }

    @Override
    public String getFirstParam(String name) {
        Map parameters = this.request.getParameterMap();
        String[] values = (String[])parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    @Override
    public String getCookieValue(String name) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = this.request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public InputStream getInputStream(boolean buffered) {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (buffered) {
            try {
                this.inputStream = new BufferedInputStream((InputStream)this.request.getInputStream());
                return this.inputStream;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TokenPrincipal getPrincipal() {
        return this.tokenPrincipal;
    }
}

