/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

@Deprecated
public class JavaClass
extends JavaObject {
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public JavaClass(Ruby runtime2, Class<?> klass) {
        this(runtime2, runtime2.getJavaSupport().getJavaClassClass(), klass);
    }

    JavaClass(Ruby runtime2, RubyClass javaClassProxy, Class<?> klass) {
        super(runtime2, javaClassProxy, klass);
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JavaClass && this.getValue() == ((JavaClass)other).getValue();
    }

    @Override
    public final int hashCode() {
        return this.getValue().hashCode();
    }

    public final RubyModule getProxyModule() {
        return Java.getProxyClass(this.getRuntime(), this.javaClass());
    }

    public final RubyClass getProxyClass() {
        return (RubyClass)this.getProxyModule();
    }

    @Deprecated
    public static JavaClass get(Ruby runtime2, Class<?> klass) {
        return runtime2.getJavaSupport().getJavaClassFromCache(klass);
    }

    @Deprecated
    public static RubyArray getRubyArray(Ruby runtime2, Class<?>[] classes) {
        return JavaClass.toRubyArray(runtime2, classes);
    }

    @Deprecated
    public static RubyArray toRubyArray(Ruby runtime2, Class<?>[] classes) {
        IRubyObject[] javaClasses = new IRubyObject[classes.length];
        int i2 = classes.length;
        while (--i2 >= 0) {
            javaClasses[i2] = JavaClass.get(runtime2, classes[i2]);
        }
        return RubyArray.newArrayMayCopy(runtime2, javaClasses);
    }

    public final Class javaClass() {
        return (Class)this.getValue();
    }

    @Deprecated
    public static Class<?> getJavaClass(ThreadContext context, RubyModule proxy2) {
        return JavaClass.getJavaClassIfProxy(context, proxy2);
    }

    @Deprecated
    public static Class<?> getJavaClassIfProxy(ThreadContext context, RubyModule type2) {
        return JavaUtil.getJavaClass(type2, null);
    }

    public static boolean isProxyType(ThreadContext context, RubyModule proxy2) {
        return JavaClass.getJavaClassIfProxy(context, proxy2) != null;
    }

    @Deprecated
    public static IRubyObject java_class(ThreadContext context, RubyModule type2) {
        IRubyObject java_class2 = type2.getInstanceVariable("@java_class");
        if (java_class2 == null) {
            if (type2.respondsTo("java_class")) {
                java_class2 = Helpers.invoke(context, type2, "java_class");
            } else {
                java_class2 = JavaProxy.getJavaClass(type2);
                if (java_class2 == null) {
                    java_class2 = context.nil;
                }
            }
        }
        return java_class2;
    }

    @Deprecated
    public static JavaClass resolveType(ThreadContext context, IRubyObject type2) {
        RubyModule proxyClass = Java.resolveType(context.runtime, type2);
        return proxyClass == null ? null : JavaClass.get(context.runtime, JavaClass.getJavaClass(context, proxyClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static JavaClass forNameVerbose(Ruby runtime2, String className) {
        Class klass = null;
        Class<JavaClass> clazz = JavaClass.class;
        synchronized (JavaClass.class) {
            if (klass == null) {
                klass = runtime2.getJavaSupport().loadJavaClassVerbose(className);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return JavaClass.get(runtime2, klass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static JavaClass forNameQuiet(Ruby runtime2, String className) {
        Class<JavaClass> clazz = JavaClass.class;
        synchronized (JavaClass.class) {
            Class klass = runtime2.getJavaSupport().loadJavaClassQuiet(className);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return JavaClass.get(runtime2, klass);
        }
    }

    @Deprecated
    @JRubyMethod(name={"for_name"}, required=1, meta=true)
    public static JavaClass for_name(IRubyObject recv2, IRubyObject name2) {
        return JavaClass.for_name(recv2, name2.asJavaString());
    }

    static JavaClass for_name(IRubyObject recv2, String name2) {
        return JavaClass.forNameVerbose(recv2.getRuntime(), name2);
    }

    @Override
    public RubyString inspect() {
        return this.getRuntime().newString("class " + this.javaClass().getName());
    }

    public static String getSimpleName(Class<?> clazz) {
        if (clazz.isArray()) {
            return JavaClass.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        int len = className.length();
        int i2 = className.lastIndexOf(36);
        if (i2 != -1) {
            while (++i2 < len && Character.isDigit(className.charAt(i2))) {
            }
            return className.substring(i2);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public static JavaCallable getMatchingCallable(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        if (methodName.length() == 6 && "<init>".equals(methodName)) {
            return JavaConstructor.getMatchingConstructor(runtime2, javaClass, argumentTypes);
        }
        return JavaMethod.getMatchingDeclaredMethod(runtime2, javaClass, methodName, argumentTypes);
    }

    public static Class<?>[] getArgumentTypes(ThreadContext context, IRubyObject[] args2, int offset2) {
        int length2 = args2.length;
        if (length2 == offset2) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] argumentTypes = new Class[length2 - offset2];
        for (int i2 = offset2; i2 < length2; ++i2) {
            argumentTypes[i2 - offset2] = Java.resolveClassType(context, args2[i2]);
        }
        return argumentTypes;
    }

    public IRubyObject emptyJavaArray(ThreadContext context) {
        return ArrayUtils.emptyJavaArrayDirect(context, this.javaClass());
    }

    @Deprecated
    public IRubyObject concatArrays(ThreadContext context, JavaArray original, JavaArray additional) {
        return ArrayUtils.concatArraysDirect(context, original.getValue(), additional.getValue());
    }

    @Deprecated
    public IRubyObject concatArrays(ThreadContext context, JavaArray original, IRubyObject additional) {
        return ArrayUtils.concatArraysDirect(context, original.getValue(), additional);
    }

    public final boolean isAssignableFrom(Class<?> clazz) {
        return JavaClass.assignable(this.javaClass(), clazz);
    }

    public static boolean assignable(Class<?> target, Class<?> from) {
        if (target.isPrimitive()) {
            target = CodegenUtils.getBoxType(target);
        } else if (from == Void.TYPE || target.isAssignableFrom(from)) {
            return true;
        }
        if (from.isPrimitive()) {
            from = CodegenUtils.getBoxType(from);
        }
        if (target.isAssignableFrom(from)) {
            return true;
        }
        if (Number.class.isAssignableFrom(target)) {
            if (Number.class.isAssignableFrom(from)) {
                return true;
            }
            if (from == Character.class) {
                return true;
            }
        } else if (target == Character.class && Number.class.isAssignableFrom(from)) {
            return true;
        }
        return false;
    }

    public static Constructor[] getConstructors(Class<?> clazz) {
        try {
            return clazz.getConstructors();
        }
        catch (SecurityException e) {
            return new Constructor[0];
        }
    }

    public static Class<?>[] getDeclaredClasses(Class<?> clazz) {
        try {
            return clazz.getDeclaredClasses();
        }
        catch (SecurityException e) {
            return new Class[0];
        }
        catch (NoClassDefFoundError cnfe) {
            return new Class[0];
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        try {
            return clazz.getDeclaredFields();
        }
        catch (SecurityException e) {
            return JavaClass.getFields(clazz);
        }
    }

    public static Field[] getFields(Class<?> clazz) {
        try {
            return clazz.getFields();
        }
        catch (SecurityException e) {
            return new Field[0];
        }
    }
}

